/*
 * Decompiled with CFR 0.152.
 */
package io.taktx.client.quarkus;

import io.quarkus.runtime.Startup;
import io.taktx.CleanupPolicy;
import io.taktx.client.AnnotationScanningExternalTaskTriggerConsumer;
import io.taktx.client.ExternalTaskTriggerConsumer;
import io.taktx.client.InstanceUpdateRecord;
import io.taktx.client.TaktXClient;
import io.taktx.client.WorkerBeanInstanceProvider;
import io.taktx.client.quarkus.InstanceUpdateRecordObserverChecker;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Produces;
import java.util.Properties;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
@Startup
public class TaktXClientProvider {
    private static TaktXClient taktClient;
    private final Config config;
    private final InstanceUpdateRecordObserverChecker observerChecker;
    private final Event<InstanceUpdateRecord> events;
    private final WorkerBeanInstanceProvider instanceProvider;
    @ConfigProperty(name="taktx.engine.topic.partitions", defaultValue="3")
    int partitions;
    @ConfigProperty(name="taktx.engine.topic.replicationFactor", defaultValue="1")
    short replicationFactor;

    public TaktXClientProvider(Config config, InstanceUpdateRecordObserverChecker observerChecker, Event<InstanceUpdateRecord> events, WorkerBeanInstanceProvider instanceProvider) {
        this.config = config;
        this.observerChecker = observerChecker;
        this.events = events;
        this.instanceProvider = instanceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    void init() {
        TaktXClient.TaktXClientBuilder taktClientBuilder = TaktXClient.newClientBuilder();
        Class<TaktXClientProvider> clazz = TaktXClientProvider.class;
        synchronized (TaktXClientProvider.class) {
            if (taktClient == null) {
                Properties taktProperties = new Properties();
                for (String name : this.config.getPropertyNames()) {
                    this.config.getOptionalValue(name, String.class).ifPresent(value -> taktProperties.put(name, value));
                }
                taktClient = taktClientBuilder.withProperties(taktProperties).build();
                taktClient.start();
                taktClient.deployTaktDeploymentAnnotatedClasses();
                AnnotationScanningExternalTaskTriggerConsumer externalTaskTriggerConsumer = new AnnotationScanningExternalTaskTriggerConsumer(taktClient.getParameterResolverFactory(), taktClient.getProcessInstanceResponder(), this.instanceProvider, taktClient.getExternalTaskTopicRequester(), this.partitions, CleanupPolicy.COMPACT, this.replicationFactor);
                taktClient.registerExternalTaskConsumer((ExternalTaskTriggerConsumer)externalTaskTriggerConsumer, "taktx-client-external-task-trigger-consumer");
                if (this.observerChecker.hasInstanceUpdateRecordObservers()) {
                    taktClient.registerInstanceUpdateConsumer(instanceUpdateRecords -> {
                        for (InstanceUpdateRecord instanceUpdateRecord : instanceUpdateRecords) {
                            this.events.fire((Object)instanceUpdateRecord);
                        }
                    });
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Produces
    public TaktXClient taktClient() {
        return taktClient;
    }
}

