/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.extension.example.log;

import com.github.lalyos.jfiglet.FigletFont;
import io.syndesis.extension.api.annotations.Action;
import io.syndesis.extension.api.annotations.ConfigurationProperty;
import java.io.IOException;
import org.apache.camel.Body;
import org.apache.camel.Handler;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(id="log-body", name="simple-log", description="A simple POJO based logging extension")
public class LogStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogStep.class);
    @ConfigurationProperty(name="ascii", displayName="ascii", description="Ascii")
    private boolean ascii;
    @ConfigurationProperty(name="font", displayName="font", description="Font")
    private String font;

    public void setAscii(boolean ascii) {
        this.ascii = ascii;
    }

    public boolean isAscii() {
        return this.ascii;
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    @Handler
    public void log(@Body String body) {
        try {
            if (this.ascii) {
                if (ObjectHelper.isNotEmpty((Object)this.font)) {
                    LOGGER.info("Body is: \n{}", (Object)FigletFont.convertOneLine((String)this.font, (String)body));
                } else {
                    LOGGER.info("Body is: \n{}", (Object)FigletFont.convertOneLine((String)body));
                }
            } else {
                LOGGER.info("Body is: {}", (Object)body);
            }
        }
        catch (IOException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

