/*
 * Decompiled with CFR 0.152.
 */
package io.synadia.bp;

import io.nats.client.Connection;
import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.MessageTtl;
import io.nats.client.NUID;
import io.nats.client.PublishOptions;
import io.nats.client.api.PublishAck;
import io.nats.client.impl.Headers;
import io.nats.client.support.Validator;
import io.synadia.bp.BatchPublishException;
import io.synadia.bp.BatchPublishOptions;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BatchPublisher {
    private final String batchId;
    private final Connection conn;
    private final Duration ackTimeout;
    private final boolean ackFirst;
    private final int ackEvery;
    private final MessageTtl messageTtl;
    private final Headers headers;
    private int lastSeq;
    private State state;

    private BatchPublisher(Builder b) {
        this.batchId = b.batchId;
        this.conn = b.conn;
        this.ackTimeout = b.ackTimeout;
        this.ackFirst = b.ackFirst;
        this.ackEvery = b.ackEvery;
        this.messageTtl = b.messageTtl;
        this.headers = new Headers();
        this.lastSeq = 0;
        this.state = State.Open;
    }

    public @Nullable String getBatchId() {
        return this.batchId;
    }

    public @NonNull Duration getAckTimeout() {
        return this.ackTimeout;
    }

    public boolean ackFirst() {
        return this.ackFirst;
    }

    public int getAckEvery() {
        return this.ackEvery;
    }

    public String getMessageTtl() {
        return this.messageTtl == null ? null : this.messageTtl.getTtlString();
    }

    public int size() {
        return this.lastSeq;
    }

    public void discard() {
        this.state = State.Discarded;
    }

    public boolean isOpen() {
        return this.state == State.Open;
    }

    public boolean isDiscarded() {
        return this.state == State.Discarded;
    }

    public boolean isClosed() {
        return this.state == State.Closed;
    }

    public void add(String subject, byte[] data) throws BatchPublishException {
        this.add(subject, null, data, null);
    }

    public void add(String subject, byte[] data, BatchPublishOptions opts) throws BatchPublishException {
        this.add(subject, null, data, opts);
    }

    public void add(String subject, Headers userHeaders, byte[] data) throws BatchPublishException {
        this.add(subject, userHeaders, data, null);
    }

    public void add(String subject, Headers userHeaders, byte[] data, BatchPublishOptions opts) throws BatchPublishException {
        if (this.state != State.Open) {
            throw new BatchPublishException(this.batchId, "Batch not open: " + (Object)((Object)this.state));
        }
        if (++this.lastSeq == 1 && this.ackFirst || this.ackEvery > 0 && this.lastSeq % this.ackEvery == 0) {
            this._addAcked(subject, userHeaders, data, opts);
        } else {
            this.updateHeaders(false, userHeaders, opts);
            this.conn.publish(subject, this.headers, data);
        }
    }

    public void addAcked(String subject, byte[] data) throws BatchPublishException {
        this.addAcked(subject, null, data, null);
    }

    public void addAcked(String subject, byte[] data, BatchPublishOptions opts) throws BatchPublishException {
        this.addAcked(subject, null, data, opts);
    }

    public void addAcked(String subject, Headers userHeaders, byte[] data) throws BatchPublishException {
        this.addAcked(subject, userHeaders, data, null);
    }

    public void addAcked(String subject, Headers userHeaders, byte[] data, BatchPublishOptions opts) throws BatchPublishException {
        if (this.state != State.Open) {
            throw new BatchPublishException(this.batchId, "Batch not open: " + (Object)((Object)this.state));
        }
        ++this.lastSeq;
        this._addAcked(subject, userHeaders, data, opts);
    }

    private void _addAcked(String subject, Headers userHeaders, byte[] data, BatchPublishOptions opts) throws BatchPublishException {
        Message m = this.request(subject, userHeaders, data, false, opts);
        if (m.getData().length != 0) {
            throw new BatchPublishException(this.batchId, "Invalid ack returned from add with confirm");
        }
    }

    public PublishAck commit(String subject, byte[] data) throws BatchPublishException {
        return this.commit(subject, null, data, null);
    }

    public PublishAck commit(String subject, byte[] data, BatchPublishOptions opts) throws BatchPublishException {
        return this.commit(subject, null, data, opts);
    }

    public PublishAck commit(String subject, Headers userHeaders, byte[] data) throws BatchPublishException {
        return this.commit(subject, userHeaders, data, null);
    }

    public PublishAck commit(String subject, Headers userHeaders, byte[] data, BatchPublishOptions opts) throws BatchPublishException {
        if (this.state != State.Open) {
            throw new BatchPublishException(this.batchId, "Batch not open: " + (Object)((Object)this.state));
        }
        try {
            ++this.lastSeq;
            Message m = this.request(subject, userHeaders, data, true, opts);
            PublishAck publishAck = new PublishAck(m);
            return publishAck;
        }
        catch (IOException e) {
            throw new BatchPublishException(this.batchId, e.getMessage());
        }
        catch (JetStreamApiException e) {
            throw new BatchPublishException(this.batchId, e);
        }
        finally {
            this.state = State.Closed;
        }
    }

    public CompletableFuture<PublishAck> commitAsync(String subject, byte[] data) throws BatchPublishException {
        return this.commitAsync(subject, null, data, null);
    }

    public CompletableFuture<PublishAck> commitAsync(String subject, byte[] data, BatchPublishOptions opts) throws BatchPublishException {
        return this.commitAsync(subject, null, data, opts);
    }

    public CompletableFuture<PublishAck> commitAsync(String subject, Headers userHeaders, byte[] data) throws BatchPublishException {
        return this.commitAsync(subject, userHeaders, data, null);
    }

    public CompletableFuture<PublishAck> commitAsync(String subject, Headers userHeaders, byte[] data, BatchPublishOptions opts) throws BatchPublishException {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.commit(subject, userHeaders, data, opts);
            }
            catch (BatchPublishException e) {
                throw new RuntimeException(e);
            }
        }, this.conn.getOptions().getExecutor());
    }

    private Message request(String subject, Headers userHeaders, byte[] data, boolean commit, BatchPublishOptions opts) throws BatchPublishException {
        try {
            this.updateHeaders(commit, userHeaders, opts);
            CompletableFuture f = this.conn.requestWithTimeout(subject, this.headers, data, this.ackTimeout);
            return (Message)f.get(this.ackTimeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new BatchPublishException(this.batchId, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BatchPublishException(this.batchId, e);
        }
    }

    private void updateHeaders(boolean commit, Headers userHeaders, BatchPublishOptions bpOpts) {
        this.headers.clear();
        this.headers.put("Nats-Batch-Id", new String[]{this.batchId});
        this.headers.put("Nats-Batch-Sequence", new String[]{Integer.toString(this.lastSeq)});
        if (commit) {
            this.headers.put("Nats-Batch-Commit", new String[]{"1"});
        }
        if (userHeaders != null && !userHeaders.isEmpty()) {
            Set keys = userHeaders.keySet();
            for (String key : keys) {
                this.headers.put(key, (Collection)userHeaders.get(key));
            }
        }
        if (bpOpts != null) {
            String temp;
            long value = bpOpts.getExpectedLastSequence();
            if (value > -1L) {
                this.headers.put("Nats-Expected-Last-Sequence", new String[]{Long.toString(value)});
            }
            if ((value = bpOpts.getExpectedLastSubjectSequence()) > -1L) {
                this.headers.put("Nats-Expected-Last-Subject-Sequence", new String[]{Long.toString(value)});
            }
            if ((temp = bpOpts.getExpectedLastSubjectSequenceSubject()) != null) {
                this.headers.put("Nats-Expected-Last-Subject-Sequence-Subject", new String[]{temp});
            }
            if ((temp = bpOpts.getExpectedStream()) != null) {
                this.headers.put("Nats-Expected-Stream", new String[]{temp});
            }
            if ((temp = bpOpts.getMessageTtl()) == null) {
                String string = temp = this.messageTtl == null ? null : this.messageTtl.getTtlString();
            }
            if (temp != null) {
                this.headers.put("Nats-TTL", new String[]{temp});
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Connection conn;
        private Duration ackTimeout;
        private String batchId;
        private boolean ackFirst = true;
        private int ackEvery;
        private MessageTtl messageTtl;

        public Builder connection(Connection conn) {
            this.conn = conn;
            return this;
        }

        public Builder batchId(String batchId) {
            this.batchId = batchId;
            return this;
        }

        public Builder ackTimeout(Duration ackTimeout) {
            this.ackTimeout = Validator.validateDurationNotRequiredGtOrEqZero((Duration)ackTimeout, (Duration)PublishOptions.DEFAULT_TIMEOUT);
            return this;
        }

        public Builder ackTimeout(long ackTimeoutMillis) {
            this.ackTimeout = ackTimeoutMillis < 1L ? PublishOptions.DEFAULT_TIMEOUT : Duration.ofMillis(ackTimeoutMillis);
            return this;
        }

        public Builder ackFirst(boolean ackFirst) {
            this.ackFirst = ackFirst;
            return this;
        }

        public Builder ackEvery(int ackEvery) {
            this.ackEvery = ackEvery < 1 ? 0 : ackEvery;
            return this;
        }

        public Builder messageTtlSeconds(int msgTtlSeconds) {
            this.messageTtl = msgTtlSeconds < 1 ? null : MessageTtl.seconds((int)msgTtlSeconds);
            return this;
        }

        public Builder messageTtlCustom(String msgTtlCustom) {
            this.messageTtl = Validator.nullOrEmpty((String)msgTtlCustom) ? null : MessageTtl.custom((String)msgTtlCustom);
            return this;
        }

        public Builder messageTtlNever() {
            this.messageTtl = MessageTtl.never();
            return this;
        }

        public Builder messageTtl(MessageTtl messageTtl) {
            this.messageTtl = messageTtl;
            return this;
        }

        public BatchPublisher build() {
            Validator.validateNotNull((Object)this.conn, (String)"Connection required,");
            if (!this.conn.getServerInfo().isNewerVersionThan("2.11.99")) {
                throw new IllegalArgumentException("Batch direct get not available until server version 2.11.0.");
            }
            if (this.ackTimeout == null) {
                this.ackTimeout = this.conn.getOptions().getConnectionTimeout();
            }
            this.batchId = Validator.emptyAsNull((String)this.batchId);
            if (this.batchId == null) {
                this.batchId = new NUID().next();
            } else if (this.batchId.length() > 64) {
                throw new IllegalArgumentException("Batch ID cannot be longer than 64 characters");
            }
            return new BatchPublisher(this);
        }
    }

    static enum State {
        Open,
        Closed,
        Discarded;

    }
}

