/*
 * Decompiled with CFR 0.152.
 */
package io.synadia.bp;

import io.nats.client.MessageTtl;
import io.nats.client.PublishOptions;
import io.nats.client.support.Validator;
import java.time.Duration;

public class BatchPublishOptions {
    public final String expectedStream;
    public final long expectedLastSeq;
    public final long expectedLastSubSeq;
    public final String expectedLastSubSeqSubject;
    public final MessageTtl messageTtl;

    private BatchPublishOptions(Builder b) {
        this.expectedStream = b.expectedStream;
        this.expectedLastSeq = b.expectedLastSeq;
        this.expectedLastSubSeq = b.expectedLastSubSeq;
        this.expectedLastSubSeqSubject = b.expectedLastSubSeqSubject;
        this.messageTtl = b.messageTtl;
    }

    public String toString() {
        return "BatchPublishOptions{, expectedStream='" + this.expectedStream + '\'' + ", expectedLastSeq=" + this.expectedLastSeq + ", expectedLastSubSeq=" + this.expectedLastSubSeq + ", expectedLastSubSeqSub=" + this.expectedLastSubSeqSubject + ", messageTtl=" + this.getMessageTtl() + '}';
    }

    public String getExpectedStream() {
        return this.expectedStream;
    }

    public long getExpectedLastSequence() {
        return this.expectedLastSeq;
    }

    public long getExpectedLastSubjectSequence() {
        return this.expectedLastSubSeq;
    }

    public String getExpectedLastSubjectSequenceSubject() {
        return this.expectedLastSubSeqSubject;
    }

    public String getMessageTtl() {
        return this.messageTtl == null ? null : this.messageTtl.getTtlString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        Duration ackTimeout = PublishOptions.DEFAULT_TIMEOUT;
        boolean ackFirst = true;
        int ackEvery = 0;
        String expectedStream;
        long expectedLastSeq = -1L;
        long expectedLastSubSeq = -1L;
        String expectedLastSubSeqSubject;
        MessageTtl messageTtl;

        public Builder ackTimeout(Duration ackTimeout) {
            this.ackTimeout = Validator.validateDurationNotRequiredGtOrEqZero((Duration)ackTimeout, (Duration)PublishOptions.DEFAULT_TIMEOUT);
            return this;
        }

        public Builder ackTimeout(long ackTimeoutMillis) {
            this.ackTimeout = ackTimeoutMillis < 1L ? PublishOptions.DEFAULT_TIMEOUT : Duration.ofMillis(ackTimeoutMillis);
            return this;
        }

        public Builder ackFirst(boolean ackFirst) {
            this.ackFirst = ackFirst;
            return this;
        }

        public Builder ackEvery(int ackEvery) {
            this.ackEvery = ackEvery < 1 ? 0 : ackEvery;
            return this;
        }

        public Builder expectedStream(String stream) {
            this.expectedStream = Validator.validateStreamName((String)stream, (boolean)false);
            return this;
        }

        public Builder expectedLastSequence(long sequence) {
            this.expectedLastSeq = Validator.validateGtEqMinus1((long)sequence, (String)"Last Sequence");
            return this;
        }

        public Builder expectedLastSubjectSequence(long sequence) {
            this.expectedLastSubSeq = Validator.validateGtEqMinus1((long)sequence, (String)"Last Subject Sequence");
            return this;
        }

        public Builder expectedLastSubjectSequenceSubject(String expectedLastSubSeqSubject) {
            this.expectedLastSubSeqSubject = expectedLastSubSeqSubject;
            return this;
        }

        public Builder messageTtlSeconds(int msgTtlSeconds) {
            this.messageTtl = msgTtlSeconds < 1 ? null : MessageTtl.seconds((int)msgTtlSeconds);
            return this;
        }

        public Builder messageTtlCustom(String msgTtlCustom) {
            this.messageTtl = Validator.nullOrEmpty((String)msgTtlCustom) ? null : MessageTtl.custom((String)msgTtlCustom);
            return this;
        }

        public Builder messageTtlNever() {
            this.messageTtl = MessageTtl.never();
            return this;
        }

        public Builder messageTtl(MessageTtl messageTtl) {
            this.messageTtl = messageTtl;
            return this;
        }

        public Builder clearExpected() {
            this.expectedLastSeq = -1L;
            this.expectedLastSubSeq = -1L;
            this.expectedLastSubSeqSubject = null;
            return this;
        }

        public BatchPublishOptions build() {
            return new BatchPublishOptions(this);
        }
    }
}

