/*
 * Decompiled with CFR 0.152.
 */
package io.synadia.bp;

import io.nats.client.JetStreamApiException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BatchPublishException
extends Exception {
    private final JetStreamApiException jsApiException;
    private final String batchId;

    public BatchPublishException(@NonNull String batchId, @NonNull String message) {
        super(message);
        this.batchId = batchId;
        this.jsApiException = null;
    }

    public BatchPublishException(@NonNull String batchId, @NonNull JetStreamApiException cause) {
        super((Throwable)cause);
        this.batchId = batchId;
        this.jsApiException = cause;
    }

    public BatchPublishException(@NonNull String batchId, @NonNull Throwable cause) {
        super(cause);
        this.batchId = batchId;
        this.jsApiException = null;
    }

    @Override
    public String getMessage() {
        return "[" + this.batchId + "] " + super.getMessage();
    }

    public @NonNull String getBatchId() {
        return this.batchId;
    }

    public @Nullable JetStreamApiException getJsApiException() {
        return this.jsApiException;
    }

    public int getErrorCode() {
        return this.jsApiException == null ? -1 : this.jsApiException.getErrorCode();
    }

    public int getApiErrorCode() {
        return this.jsApiException == null ? -1 : this.jsApiException.getApiErrorCode();
    }

    public @Nullable String getErrorDescription() {
        return this.jsApiException == null ? null : this.jsApiException.getErrorDescription();
    }
}

