/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.tui;

public enum Key {
    ESC(27, "ESC"),
    ENTER(10, "Enter"),
    ENTER_CR(13, "Enter"),
    TAB(9, "Tab"),
    BACKSPACE(127, "Backspace"),
    SPACE(32, "Space"),
    CTRL_A(1, "Ctrl+A"),
    CTRL_C(3, "Ctrl+C"),
    CTRL_D(4, "Ctrl+D"),
    CTRL_X(24, "Ctrl+X"),
    CTRL_Z(26, "Ctrl+Z"),
    QUESTION_MARK(63, "?");

    private final int keyCode;
    private final String displayName;

    private Key(int keyCode, String displayName) {
        this.keyCode = keyCode;
        this.displayName = displayName;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Key fromKeyCode(int keyCode) {
        for (Key key : Key.values()) {
            if (key.keyCode != keyCode) continue;
            return key;
        }
        return null;
    }

    public static String getKeyName(int keyCode) {
        Key key = Key.fromKeyCode(keyCode);
        if (key != null) {
            return key.getDisplayName();
        }
        if (keyCode >= 32 && keyCode <= 126) {
            return "'" + (char)keyCode + "'";
        }
        return "Key(" + keyCode + ")";
    }
}

