/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.tui;

import io.sundr.tui.TermInput;
import java.io.IOException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class JLineTermInput
implements TermInput {
    private final Terminal terminal;
    private volatile boolean closed = false;

    public JLineTermInput() {
        try {
            this.terminal = TerminalBuilder.builder().system(true).build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize terminal", e);
        }
    }

    @Override
    public AutoCloseable enterRawMode() {
        if (this.closed) {
            throw new IllegalStateException("TermInput is closed");
        }
        this.terminal.enterRawMode();
        return () -> {
            if (!this.closed && this.terminal != null) {
                try {
                    this.terminal.echo(true);
                    this.terminal.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public int readKey() {
        if (this.closed) {
            return -1;
        }
        try {
            return this.terminal.reader().read();
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public int readKey(long timeoutMillis) {
        if (this.closed) {
            return -1;
        }
        try {
            return this.terminal.reader().read(timeoutMillis);
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public boolean isInteractive() {
        if (this.closed) {
            return false;
        }
        return this.terminal != null && !"dumb".equals(this.terminal.getType());
    }

    @Override
    public void close() throws Exception {
        if (!this.closed && this.terminal != null) {
            this.closed = true;
            try {
                this.terminal.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Terminal getTerminal() {
        return this.terminal;
    }
}

