package io.sundr.model;

import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

import io.sundr.builder.BaseFluent;
import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IfDslThenStepFluent<A extends IfDslThenStepFluent<A>> extends BaseFluent<A> {
  public IfDslThenStepFluent() {
  }

  public IfDslThenStepFluent(IfDslThenStep instance) {
    this.copyInstance(instance);
  }

  private VisitableBuilder<? extends Expression, ?> condition;
  private ArrayList<VisitableBuilder<? extends Statement, ?>> statements = new ArrayList<VisitableBuilder<? extends Statement, ?>>();

  protected void copyInstance(IfDslThenStep instance) {
    if (instance != null) {
      this.withCondition(instance.getCondition());
      this.withStatements(instance.getStatements());
    }
  }

  public Expression buildCondition() {
    return this.condition != null ? this.condition.build() : null;
  }

  public A withCondition(Expression condition) {
    if (condition == null) {
      this.condition = null;
      this._visitables.remove("condition");
      return (A) this;
    } else {
      VisitableBuilder<? extends Expression, ?> builder = builder(condition);
      this._visitables.get("condition").clear();
      this._visitables.get("condition").add(builder);
      this.condition = builder;
      return (A) this;
    }
  }

  public boolean hasCondition() {
    return this.condition != null;
  }

  public MultiplyConditionNested<A> withNewMultiplyCondition() {
    return new MultiplyConditionNested(null);
  }

  public MultiplyConditionNested<A> withNewMultiplyConditionLike(Multiply item) {
    return new MultiplyConditionNested(item);
  }

  public A withNewMultiplyCondition(Object left, Object right) {
    return (A) withCondition(new Multiply(left, right));
  }

  public NewArrayConditionNested<A> withNewNewArrayCondition() {
    return new NewArrayConditionNested(null);
  }

  public NewArrayConditionNested<A> withNewNewArrayConditionLike(NewArray item) {
    return new NewArrayConditionNested(item);
  }

  public A withNewNewArrayCondition(Class type, Integer[] sizes) {
    return (A) withCondition(new NewArray(type, sizes));
  }

  public InstanceOfConditionNested<A> withNewInstanceOfCondition() {
    return new InstanceOfConditionNested(null);
  }

  public InstanceOfConditionNested<A> withNewInstanceOfConditionLike(InstanceOf item) {
    return new InstanceOfConditionNested(item);
  }

  public MethodCallConditionNested<A> withNewMethodCallCondition() {
    return new MethodCallConditionNested(null);
  }

  public MethodCallConditionNested<A> withNewMethodCallConditionLike(MethodCall item) {
    return new MethodCallConditionNested(item);
  }

  public InverseConditionNested<A> withNewInverseCondition() {
    return new InverseConditionNested(null);
  }

  public InverseConditionNested<A> withNewInverseConditionLike(Inverse item) {
    return new InverseConditionNested(item);
  }

  public IndexConditionNested<A> withNewIndexCondition() {
    return new IndexConditionNested(null);
  }

  public IndexConditionNested<A> withNewIndexConditionLike(Index item) {
    return new IndexConditionNested(item);
  }

  public GreaterThanOrEqualConditionNested<A> withNewGreaterThanOrEqualCondition() {
    return new GreaterThanOrEqualConditionNested(null);
  }

  public GreaterThanOrEqualConditionNested<A> withNewGreaterThanOrEqualConditionLike(GreaterThanOrEqual item) {
    return new GreaterThanOrEqualConditionNested(item);
  }

  public A withNewGreaterThanOrEqualCondition(Object left, Object right) {
    return (A) withCondition(new GreaterThanOrEqual(left, right));
  }

  public BitwiseAndConditionNested<A> withNewBitwiseAndCondition() {
    return new BitwiseAndConditionNested(null);
  }

  public BitwiseAndConditionNested<A> withNewBitwiseAndConditionLike(BitwiseAnd item) {
    return new BitwiseAndConditionNested(item);
  }

  public A withNewBitwiseAndCondition(Object left, Object right) {
    return (A) withCondition(new BitwiseAnd(left, right));
  }

  public MinusConditionNested<A> withNewMinusCondition() {
    return new MinusConditionNested(null);
  }

  public MinusConditionNested<A> withNewMinusConditionLike(Minus item) {
    return new MinusConditionNested(item);
  }

  public A withNewMinusCondition(Object left, Object right) {
    return (A) withCondition(new Minus(left, right));
  }

  public LogicalOrConditionNested<A> withNewLogicalOrCondition() {
    return new LogicalOrConditionNested(null);
  }

  public LogicalOrConditionNested<A> withNewLogicalOrConditionLike(LogicalOr item) {
    return new LogicalOrConditionNested(item);
  }

  public A withNewLogicalOrCondition(Object left, Object right) {
    return (A) withCondition(new LogicalOr(left, right));
  }

  public NotEqualsConditionNested<A> withNewNotEqualsCondition() {
    return new NotEqualsConditionNested(null);
  }

  public NotEqualsConditionNested<A> withNewNotEqualsConditionLike(NotEquals item) {
    return new NotEqualsConditionNested(item);
  }

  public A withNewNotEqualsCondition(Object left, Object right) {
    return (A) withCondition(new NotEquals(left, right));
  }

  public DivideConditionNested<A> withNewDivideCondition() {
    return new DivideConditionNested(null);
  }

  public DivideConditionNested<A> withNewDivideConditionLike(Divide item) {
    return new DivideConditionNested(item);
  }

  public A withNewDivideCondition(Object left, Object right) {
    return (A) withCondition(new Divide(left, right));
  }

  public LessThanConditionNested<A> withNewLessThanCondition() {
    return new LessThanConditionNested(null);
  }

  public LessThanConditionNested<A> withNewLessThanConditionLike(LessThan item) {
    return new LessThanConditionNested(item);
  }

  public A withNewLessThanCondition(Object left, Object right) {
    return (A) withCondition(new LessThan(left, right));
  }

  public BitwiseOrConditionNested<A> withNewBitwiseOrCondition() {
    return new BitwiseOrConditionNested(null);
  }

  public BitwiseOrConditionNested<A> withNewBitwiseOrConditionLike(BitwiseOr item) {
    return new BitwiseOrConditionNested(item);
  }

  public A withNewBitwiseOrCondition(Object left, Object right) {
    return (A) withCondition(new BitwiseOr(left, right));
  }

  public PropertyRefConditionNested<A> withNewPropertyRefCondition() {
    return new PropertyRefConditionNested(null);
  }

  public PropertyRefConditionNested<A> withNewPropertyRefConditionLike(PropertyRef item) {
    return new PropertyRefConditionNested(item);
  }

  public RightShiftConditionNested<A> withNewRightShiftCondition() {
    return new RightShiftConditionNested(null);
  }

  public RightShiftConditionNested<A> withNewRightShiftConditionLike(RightShift item) {
    return new RightShiftConditionNested(item);
  }

  public A withNewRightShiftCondition(Object left, Object right) {
    return (A) withCondition(new RightShift(left, right));
  }

  public SuperConditionNested<A> withNewSuperCondition() {
    return new SuperConditionNested(null);
  }

  public SuperConditionNested<A> withNewSuperConditionLike(Super item) {
    return new SuperConditionNested(item);
  }

  public GreaterThanConditionNested<A> withNewGreaterThanCondition() {
    return new GreaterThanConditionNested(null);
  }

  public GreaterThanConditionNested<A> withNewGreaterThanConditionLike(GreaterThan item) {
    return new GreaterThanConditionNested(item);
  }

  public A withNewGreaterThanCondition(Object left, Object right) {
    return (A) withCondition(new GreaterThan(left, right));
  }

  public DeclareConditionNested<A> withNewDeclareCondition() {
    return new DeclareConditionNested(null);
  }

  public DeclareConditionNested<A> withNewDeclareConditionLike(Declare item) {
    return new DeclareConditionNested(item);
  }

  public A withNewDeclareCondition(Class type, String name) {
    return (A) withCondition(new Declare(type, name));
  }

  public A withNewDeclareCondition(Class type, String name, Object value) {
    return (A) withCondition(new Declare(type, name, value));
  }

  public CastConditionNested<A> withNewCastCondition() {
    return new CastConditionNested(null);
  }

  public CastConditionNested<A> withNewCastConditionLike(Cast item) {
    return new CastConditionNested(item);
  }

  public ModuloConditionNested<A> withNewModuloCondition() {
    return new ModuloConditionNested(null);
  }

  public ModuloConditionNested<A> withNewModuloConditionLike(Modulo item) {
    return new ModuloConditionNested(item);
  }

  public A withNewModuloCondition(Object left, Object right) {
    return (A) withCondition(new Modulo(left, right));
  }

  public ValueRefConditionNested<A> withNewValueRefCondition() {
    return new ValueRefConditionNested(null);
  }

  public ValueRefConditionNested<A> withNewValueRefConditionLike(ValueRef item) {
    return new ValueRefConditionNested(item);
  }

  public A withNewValueRefCondition(Object value) {
    return (A) withCondition(new ValueRef(value));
  }

  public LeftShiftConditionNested<A> withNewLeftShiftCondition() {
    return new LeftShiftConditionNested(null);
  }

  public LeftShiftConditionNested<A> withNewLeftShiftConditionLike(LeftShift item) {
    return new LeftShiftConditionNested(item);
  }

  public A withNewLeftShiftCondition(Object left, Object right) {
    return (A) withCondition(new LeftShift(left, right));
  }

  public TernaryConditionNested<A> withNewTernaryCondition() {
    return new TernaryConditionNested(null);
  }

  public TernaryConditionNested<A> withNewTernaryConditionLike(Ternary item) {
    return new TernaryConditionNested(item);
  }

  public BinaryExpressionConditionNested<A> withNewBinaryExpressionCondition() {
    return new BinaryExpressionConditionNested(null);
  }

  public BinaryExpressionConditionNested<A> withNewBinaryExpressionConditionLike(BinaryExpression item) {
    return new BinaryExpressionConditionNested(item);
  }

  public EqualsConditionNested<A> withNewEqualsCondition() {
    return new EqualsConditionNested(null);
  }

  public EqualsConditionNested<A> withNewEqualsConditionLike(Equals item) {
    return new EqualsConditionNested(item);
  }

  public A withNewEqualsCondition(Object left, Object right) {
    return (A) withCondition(new Equals(left, right));
  }

  public EnclosedConditionNested<A> withNewEnclosedCondition() {
    return new EnclosedConditionNested(null);
  }

  public EnclosedConditionNested<A> withNewEnclosedConditionLike(Enclosed item) {
    return new EnclosedConditionNested(item);
  }

  public PreDecrementConditionNested<A> withNewPreDecrementCondition() {
    return new PreDecrementConditionNested(null);
  }

  public PreDecrementConditionNested<A> withNewPreDecrementConditionLike(PreDecrement item) {
    return new PreDecrementConditionNested(item);
  }

  public PostDecrementConditionNested<A> withNewPostDecrementCondition() {
    return new PostDecrementConditionNested(null);
  }

  public PostDecrementConditionNested<A> withNewPostDecrementConditionLike(PostDecrement item) {
    return new PostDecrementConditionNested(item);
  }

  public LambdaConditionNested<A> withNewLambdaCondition() {
    return new LambdaConditionNested(null);
  }

  public LambdaConditionNested<A> withNewLambdaConditionLike(Lambda item) {
    return new LambdaConditionNested(item);
  }

  public NotConditionNested<A> withNewNotCondition() {
    return new NotConditionNested(null);
  }

  public NotConditionNested<A> withNewNotConditionLike(Not item) {
    return new NotConditionNested(item);
  }

  public AssignConditionNested<A> withNewAssignCondition() {
    return new AssignConditionNested(null);
  }

  public AssignConditionNested<A> withNewAssignConditionLike(Assign item) {
    return new AssignConditionNested(item);
  }

  public ThisConditionNested<A> withNewThisCondition() {
    return new ThisConditionNested(null);
  }

  public ThisConditionNested<A> withNewThisConditionLike(This item) {
    return new ThisConditionNested(item);
  }

  public NegativeConditionNested<A> withNewNegativeCondition() {
    return new NegativeConditionNested(null);
  }

  public NegativeConditionNested<A> withNewNegativeConditionLike(Negative item) {
    return new NegativeConditionNested(item);
  }

  public LogicalAndConditionNested<A> withNewLogicalAndCondition() {
    return new LogicalAndConditionNested(null);
  }

  public LogicalAndConditionNested<A> withNewLogicalAndConditionLike(LogicalAnd item) {
    return new LogicalAndConditionNested(item);
  }

  public A withNewLogicalAndCondition(Object left, Object right) {
    return (A) withCondition(new LogicalAnd(left, right));
  }

  public PostIncrementConditionNested<A> withNewPostIncrementCondition() {
    return new PostIncrementConditionNested(null);
  }

  public PostIncrementConditionNested<A> withNewPostIncrementConditionLike(PostIncrement item) {
    return new PostIncrementConditionNested(item);
  }

  public RightUnsignedShiftConditionNested<A> withNewRightUnsignedShiftCondition() {
    return new RightUnsignedShiftConditionNested(null);
  }

  public RightUnsignedShiftConditionNested<A> withNewRightUnsignedShiftConditionLike(RightUnsignedShift item) {
    return new RightUnsignedShiftConditionNested(item);
  }

  public A withNewRightUnsignedShiftCondition(Object left, Object right) {
    return (A) withCondition(new RightUnsignedShift(left, right));
  }

  public PlusConditionNested<A> withNewPlusCondition() {
    return new PlusConditionNested(null);
  }

  public PlusConditionNested<A> withNewPlusConditionLike(Plus item) {
    return new PlusConditionNested(item);
  }

  public A withNewPlusCondition(Object left, Object right) {
    return (A) withCondition(new Plus(left, right));
  }

  public ConstructConditionNested<A> withNewConstructCondition() {
    return new ConstructConditionNested(null);
  }

  public ConstructConditionNested<A> withNewConstructConditionLike(Construct item) {
    return new ConstructConditionNested(item);
  }

  public XorConditionNested<A> withNewXorCondition() {
    return new XorConditionNested(null);
  }

  public XorConditionNested<A> withNewXorConditionLike(Xor item) {
    return new XorConditionNested(item);
  }

  public A withNewXorCondition(Object left, Object right) {
    return (A) withCondition(new Xor(left, right));
  }

  public PreIncrementConditionNested<A> withNewPreIncrementCondition() {
    return new PreIncrementConditionNested(null);
  }

  public PreIncrementConditionNested<A> withNewPreIncrementConditionLike(PreIncrement item) {
    return new PreIncrementConditionNested(item);
  }

  public PropertyConditionNested<A> withNewPropertyCondition() {
    return new PropertyConditionNested(null);
  }

  public PropertyConditionNested<A> withNewPropertyConditionLike(Property item) {
    return new PropertyConditionNested(item);
  }

  public LessThanOrEqualConditionNested<A> withNewLessThanOrEqualCondition() {
    return new LessThanOrEqualConditionNested(null);
  }

  public LessThanOrEqualConditionNested<A> withNewLessThanOrEqualConditionLike(LessThanOrEqual item) {
    return new LessThanOrEqualConditionNested(item);
  }

  public A withNewLessThanOrEqualCondition(Object left, Object right) {
    return (A) withCondition(new LessThanOrEqual(left, right));
  }

  public PositiveConditionNested<A> withNewPositiveCondition() {
    return new PositiveConditionNested(null);
  }

  public PositiveConditionNested<A> withNewPositiveConditionLike(Positive item) {
    return new PositiveConditionNested(item);
  }

  public A addToStatements(VisitableBuilder<? extends Statement, ?> builder) {
    if (this.statements == null) {
      this.statements = new ArrayList<VisitableBuilder<? extends Statement, ?>>();
    }
    _visitables.get("statements").add(builder);
    this.statements.add(builder);
    return (A) this;
  }

  public A addToStatements(int index, VisitableBuilder<? extends Statement, ?> builder) {
    if (this.statements == null) {
      this.statements = new ArrayList<VisitableBuilder<? extends Statement, ?>>();
    }
    if (index < 0 || index >= statements.size()) {
      _visitables.get("statements").add(builder);
      statements.add(builder);
    } else {
      _visitables.get("statements").add(builder);
      statements.add(index, builder);
    }
    return (A) this;
  }

  public A addToStatements(int index, Statement item) {
    if (this.statements == null) {
      this.statements = new ArrayList<VisitableBuilder<? extends Statement, ?>>();
    }
    VisitableBuilder<? extends Statement, ?> builder = builder(item);
    if (index < 0 || index >= statements.size()) {
      _visitables.get("statements").add(builder);
      statements.add(builder);
    } else {
      _visitables.get("statements").add(builder);
      statements.add(index, builder);
    }
    return (A) this;
  }

  public A setToStatements(int index, Statement item) {
    if (this.statements == null) {
      this.statements = new ArrayList<VisitableBuilder<? extends Statement, ?>>();
    }
    VisitableBuilder<? extends Statement, ?> builder = builder(item);
    if (index < 0 || index >= statements.size()) {
      _visitables.get("statements").add(builder);
      statements.add(builder);
    } else {
      _visitables.get("statements").add(builder);
      statements.set(index, builder);
    }
    return (A) this;
  }

  public A addToStatements(io.sundr.model.Statement... items) {
    if (this.statements == null) {
      this.statements = new ArrayList<VisitableBuilder<? extends Statement, ?>>();
    }
    for (Statement item : items) {
      VisitableBuilder<? extends Statement, ?> builder = builder(item);
      _visitables.get("statements").add(builder);
      this.statements.add(builder);
    }
    return (A) this;
  }

  public A addAllToStatements(Collection<Statement> items) {
    if (this.statements == null) {
      this.statements = new ArrayList<VisitableBuilder<? extends Statement, ?>>();
    }
    for (Statement item : items) {
      VisitableBuilder<? extends Statement, ?> builder = builder(item);
      _visitables.get("statements").add(builder);
      this.statements.add(builder);
    }
    return (A) this;
  }

  public A removeFromStatements(VisitableBuilder<? extends Statement, ?> builder) {
    if (this.statements == null)
      return (A) this;
    _visitables.get("statements").remove(builder);
    this.statements.remove(builder);
    return (A) this;
  }

  public A removeFromStatements(io.sundr.model.Statement... items) {
    if (this.statements == null)
      return (A) this;
    for (Statement item : items) {
      VisitableBuilder<? extends Statement, ?> builder = builder(item);
      _visitables.get("statements").remove(builder);
      this.statements.remove(builder);
    }
    return (A) this;
  }

  public A removeAllFromStatements(Collection<Statement> items) {
    if (this.statements == null)
      return (A) this;
    for (Statement item : items) {
      VisitableBuilder<? extends Statement, ?> builder = builder(item);
      _visitables.get("statements").remove(builder);
      this.statements.remove(builder);
    }
    return (A) this;
  }

  public A removeMatchingFromStatements(Predicate<VisitableBuilder<? extends Statement, ?>> predicate) {
    if (statements == null)
      return (A) this;
    final Iterator<VisitableBuilder<? extends Statement, ?>> each = statements.iterator();
    final List visitables = _visitables.get("statements");
    while (each.hasNext()) {
      VisitableBuilder<? extends Statement, ?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A) this;
  }

  public List<Statement> buildStatements() {
    return build(statements);
  }

  public Statement buildStatement(int index) {
    return this.statements.get(index).build();
  }

  public Statement buildFirstStatement() {
    return this.statements.get(0).build();
  }

  public Statement buildLastStatement() {
    return this.statements.get(statements.size() - 1).build();
  }

  public Statement buildMatchingStatement(Predicate<VisitableBuilder<? extends Statement, ?>> predicate) {
    for (VisitableBuilder<? extends Statement, ?> item : statements) {
      if (predicate.test(item)) {
        return item.build();
      }
    }
    return null;
  }

  public boolean hasMatchingStatement(Predicate<VisitableBuilder<? extends Statement, ?>> predicate) {
    for (VisitableBuilder<? extends Statement, ?> item : statements) {
      if (predicate.test(item)) {
        return true;
      }
    }
    return false;
  }

  public A withStatements(List<Statement> statements) {
    if (statements != null) {
      this.statements = new ArrayList();
      for (Statement item : statements) {
        this.addToStatements(item);
      }
    } else {
      this.statements = null;
    }
    return (A) this;
  }

  public A withStatements(io.sundr.model.Statement... statements) {
    if (this.statements != null) {
      this.statements.clear();
      _visitables.remove("statements");
    }
    if (statements != null) {
      for (Statement item : statements) {
        this.addToStatements(item);
      }
    }
    return (A) this;
  }

  public boolean hasStatements() {
    return this.statements != null && !(this.statements.isEmpty());
  }

  public ReturnDslThisStepStatementsNested<A> addNewReturnDslThisStepStatement() {
    return new ReturnDslThisStepStatementsNested(-1, null);
  }

  public ReturnDslThisStepStatementsNested<A> addNewReturnDslThisStepStatementLike(ReturnDslThisStep item) {
    return new ReturnDslThisStepStatementsNested(-1, item);
  }

  public ReturnDslThisStepStatementsNested<A> setNewReturnDslThisStepStatementLike(int index, ReturnDslThisStep item) {
    return new ReturnDslThisStepStatementsNested(index, item);
  }

  public MethodCallStatementsNested<A> addNewMethodCallStatement() {
    return new MethodCallStatementsNested(-1, null);
  }

  public MethodCallStatementsNested<A> addNewMethodCallStatementLike(MethodCall item) {
    return new MethodCallStatementsNested(-1, item);
  }

  public MethodCallStatementsNested<A> setNewMethodCallStatementLike(int index, MethodCall item) {
    return new MethodCallStatementsNested(index, item);
  }

  public SwitchStatementsNested<A> addNewSwitchStatement() {
    return new SwitchStatementsNested(-1, null);
  }

  public SwitchStatementsNested<A> addNewSwitchStatementLike(Switch item) {
    return new SwitchStatementsNested(-1, item);
  }

  public SwitchStatementsNested<A> setNewSwitchStatementLike(int index, Switch item) {
    return new SwitchStatementsNested(index, item);
  }

  public BreakStatementsNested<A> addNewBreakStatement() {
    return new BreakStatementsNested(-1, null);
  }

  public BreakStatementsNested<A> addNewBreakStatementLike(Break item) {
    return new BreakStatementsNested(-1, item);
  }

  public BreakStatementsNested<A> setNewBreakStatementLike(int index, Break item) {
    return new BreakStatementsNested(index, item);
  }

  public DeclareStatementsNested<A> addNewDeclareStatement() {
    return new DeclareStatementsNested(-1, null);
  }

  public DeclareStatementsNested<A> addNewDeclareStatementLike(Declare item) {
    return new DeclareStatementsNested(-1, item);
  }

  public A addNewDeclareStatement(Class type, String name) {
    return (A) addToStatements(new Declare(type, name));
  }

  public A addNewDeclareStatement(Class type, String name, Object value) {
    return (A) addToStatements(new Declare(type, name, value));
  }

  public DeclareStatementsNested<A> setNewDeclareStatementLike(int index, Declare item) {
    return new DeclareStatementsNested(index, item);
  }

  public WhileStatementsNested<A> addNewWhileStatement() {
    return new WhileStatementsNested(-1, null);
  }

  public WhileStatementsNested<A> addNewWhileStatementLike(While item) {
    return new WhileStatementsNested(-1, item);
  }

  public WhileStatementsNested<A> setNewWhileStatementLike(int index, While item) {
    return new WhileStatementsNested(index, item);
  }

  public ContinueStatementsNested<A> addNewContinueStatement() {
    return new ContinueStatementsNested(-1, null);
  }

  public ContinueStatementsNested<A> addNewContinueStatementLike(Continue item) {
    return new ContinueStatementsNested(-1, item);
  }

  public ContinueStatementsNested<A> setNewContinueStatementLike(int index, Continue item) {
    return new ContinueStatementsNested(index, item);
  }

  public ThrowStatementsNested<A> addNewThrowStatement() {
    return new ThrowStatementsNested(-1, null);
  }

  public ThrowStatementsNested<A> addNewThrowStatementLike(Throw item) {
    return new ThrowStatementsNested(-1, item);
  }

  public ThrowStatementsNested<A> setNewThrowStatementLike(int index, Throw item) {
    return new ThrowStatementsNested(index, item);
  }

  public StringStatementStatementsNested<A> addNewStringStatementStatement() {
    return new StringStatementStatementsNested(-1, null);
  }

  public StringStatementStatementsNested<A> addNewStringStatementStatementLike(StringStatement item) {
    return new StringStatementStatementsNested(-1, item);
  }

  public A addNewStringStatementStatement(String data) {
    return (A) addToStatements(new StringStatement(data));
  }

  public A addNewStringStatementStatement(String data, Object[] parameters) {
    return (A) addToStatements(new StringStatement(data, parameters));
  }

  public StringStatementStatementsNested<A> setNewStringStatementStatementLike(int index, StringStatement item) {
    return new StringStatementStatementsNested(index, item);
  }

  public DoStatementsNested<A> addNewDoStatement() {
    return new DoStatementsNested(-1, null);
  }

  public DoStatementsNested<A> addNewDoStatementLike(Do item) {
    return new DoStatementsNested(-1, item);
  }

  public DoStatementsNested<A> setNewDoStatementLike(int index, Do item) {
    return new DoStatementsNested(index, item);
  }

  public ForeachStatementsNested<A> addNewForeachStatement() {
    return new ForeachStatementsNested(-1, null);
  }

  public ForeachStatementsNested<A> addNewForeachStatementLike(Foreach item) {
    return new ForeachStatementsNested(-1, item);
  }

  public ForeachStatementsNested<A> setNewForeachStatementLike(int index, Foreach item) {
    return new ForeachStatementsNested(index, item);
  }

  public BlockStatementsNested<A> addNewBlockStatement() {
    return new BlockStatementsNested(-1, null);
  }

  public BlockStatementsNested<A> addNewBlockStatementLike(Block item) {
    return new BlockStatementsNested(-1, item);
  }

  public BlockStatementsNested<A> setNewBlockStatementLike(int index, Block item) {
    return new BlockStatementsNested(index, item);
  }

  public ReturnDslVariableStepStatementsNested<A> addNewReturnDslVariableStepStatement() {
    return new ReturnDslVariableStepStatementsNested(-1, null);
  }

  public ReturnDslVariableStepStatementsNested<A> addNewReturnDslVariableStepStatementLike(ReturnDslVariableStep item) {
    return new ReturnDslVariableStepStatementsNested(-1, item);
  }

  public A addNewReturnDslVariableStepStatement(String name) {
    return (A) addToStatements(new ReturnDslVariableStep(name));
  }

  public ReturnDslVariableStepStatementsNested<A> setNewReturnDslVariableStepStatementLike(int index,
      ReturnDslVariableStep item) {
    return new ReturnDslVariableStepStatementsNested(index, item);
  }

  public IfStatementsNested<A> addNewIfStatement() {
    return new IfStatementsNested(-1, null);
  }

  public IfStatementsNested<A> addNewIfStatementLike(If item) {
    return new IfStatementsNested(-1, item);
  }

  public IfStatementsNested<A> setNewIfStatementLike(int index, If item) {
    return new IfStatementsNested(index, item);
  }

  public LambdaStatementsNested<A> addNewLambdaStatement() {
    return new LambdaStatementsNested(-1, null);
  }

  public LambdaStatementsNested<A> addNewLambdaStatementLike(Lambda item) {
    return new LambdaStatementsNested(-1, item);
  }

  public LambdaStatementsNested<A> setNewLambdaStatementLike(int index, Lambda item) {
    return new LambdaStatementsNested(index, item);
  }

  public ReturnStatementsNested<A> addNewReturnStatement() {
    return new ReturnStatementsNested(-1, null);
  }

  public ReturnStatementsNested<A> addNewReturnStatementLike(Return item) {
    return new ReturnStatementsNested(-1, item);
  }

  public A addNewReturnStatement(Object object) {
    return (A) addToStatements(new Return(object));
  }

  public ReturnStatementsNested<A> setNewReturnStatementLike(int index, Return item) {
    return new ReturnStatementsNested(index, item);
  }

  public AssignStatementsNested<A> addNewAssignStatement() {
    return new AssignStatementsNested(-1, null);
  }

  public AssignStatementsNested<A> addNewAssignStatementLike(Assign item) {
    return new AssignStatementsNested(-1, item);
  }

  public AssignStatementsNested<A> setNewAssignStatementLike(int index, Assign item) {
    return new AssignStatementsNested(index, item);
  }

  public IfDslThenStepStatementsNested<A> addNewIfDslThenStepStatement() {
    return new IfDslThenStepStatementsNested(-1, null);
  }

  public IfDslThenStepStatementsNested<A> addNewIfDslThenStepStatementLike(IfDslThenStep item) {
    return new IfDslThenStepStatementsNested(-1, item);
  }

  public IfDslThenStepStatementsNested<A> setNewIfDslThenStepStatementLike(int index, IfDslThenStep item) {
    return new IfDslThenStepStatementsNested(index, item);
  }

  public ForStatementsNested<A> addNewForStatement() {
    return new ForStatementsNested(-1, null);
  }

  public ForStatementsNested<A> addNewForStatementLike(For item) {
    return new ForStatementsNested(-1, item);
  }

  public ForStatementsNested<A> setNewForStatementLike(int index, For item) {
    return new ForStatementsNested(index, item);
  }

  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (o == null || getClass() != o.getClass())
      return false;
    if (!super.equals(o))
      return false;
    IfDslThenStepFluent that = (IfDslThenStepFluent) o;
    if (!java.util.Objects.equals(condition, that.condition))
      return false;
    if (!java.util.Objects.equals(statements, that.statements))
      return false;
    return true;
  }

  public int hashCode() {
    return java.util.Objects.hash(condition, statements, super.hashCode());
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (condition != null) {
      sb.append("condition:");
      sb.append(condition + ",");
    }
    if (statements != null && !statements.isEmpty()) {
      sb.append("statements:");
      sb.append(statements);
    }
    sb.append("}");
    return sb.toString();
  }

  protected static <T> VisitableBuilder<T, ?> builder(Object item) {
    switch (item.getClass().getName()) {
      case "io.sundr.model." + "Multiply":
        return (VisitableBuilder<T, ?>) new MultiplyBuilder((Multiply) item);
      case "io.sundr.model." + "NewArray":
        return (VisitableBuilder<T, ?>) new NewArrayBuilder((NewArray) item);
      case "io.sundr.model." + "InstanceOf":
        return (VisitableBuilder<T, ?>) new InstanceOfBuilder((InstanceOf) item);
      case "io.sundr.model." + "MethodCall":
        return (VisitableBuilder<T, ?>) new MethodCallBuilder((MethodCall) item);
      case "io.sundr.model." + "Inverse":
        return (VisitableBuilder<T, ?>) new InverseBuilder((Inverse) item);
      case "io.sundr.model." + "Index":
        return (VisitableBuilder<T, ?>) new IndexBuilder((Index) item);
      case "io.sundr.model." + "GreaterThanOrEqual":
        return (VisitableBuilder<T, ?>) new GreaterThanOrEqualBuilder((GreaterThanOrEqual) item);
      case "io.sundr.model." + "BitwiseAnd":
        return (VisitableBuilder<T, ?>) new BitwiseAndBuilder((BitwiseAnd) item);
      case "io.sundr.model." + "Minus":
        return (VisitableBuilder<T, ?>) new MinusBuilder((Minus) item);
      case "io.sundr.model." + "LogicalOr":
        return (VisitableBuilder<T, ?>) new LogicalOrBuilder((LogicalOr) item);
      case "io.sundr.model." + "NotEquals":
        return (VisitableBuilder<T, ?>) new NotEqualsBuilder((NotEquals) item);
      case "io.sundr.model." + "Divide":
        return (VisitableBuilder<T, ?>) new DivideBuilder((Divide) item);
      case "io.sundr.model." + "LessThan":
        return (VisitableBuilder<T, ?>) new LessThanBuilder((LessThan) item);
      case "io.sundr.model." + "BitwiseOr":
        return (VisitableBuilder<T, ?>) new BitwiseOrBuilder((BitwiseOr) item);
      case "io.sundr.model." + "PropertyRef":
        return (VisitableBuilder<T, ?>) new PropertyRefBuilder((PropertyRef) item);
      case "io.sundr.model." + "RightShift":
        return (VisitableBuilder<T, ?>) new RightShiftBuilder((RightShift) item);
      case "io.sundr.model." + "Super":
        return (VisitableBuilder<T, ?>) new SuperBuilder((Super) item);
      case "io.sundr.model." + "GreaterThan":
        return (VisitableBuilder<T, ?>) new GreaterThanBuilder((GreaterThan) item);
      case "io.sundr.model." + "Declare":
        return (VisitableBuilder<T, ?>) new DeclareBuilder((Declare) item);
      case "io.sundr.model." + "Cast":
        return (VisitableBuilder<T, ?>) new CastBuilder((Cast) item);
      case "io.sundr.model." + "Modulo":
        return (VisitableBuilder<T, ?>) new ModuloBuilder((Modulo) item);
      case "io.sundr.model." + "ValueRef":
        return (VisitableBuilder<T, ?>) new ValueRefBuilder((ValueRef) item);
      case "io.sundr.model." + "LeftShift":
        return (VisitableBuilder<T, ?>) new LeftShiftBuilder((LeftShift) item);
      case "io.sundr.model." + "Ternary":
        return (VisitableBuilder<T, ?>) new TernaryBuilder((Ternary) item);
      case "io.sundr.model." + "BinaryExpression":
        return (VisitableBuilder<T, ?>) new BinaryExpressionBuilder((BinaryExpression) item);
      case "io.sundr.model." + "Equals":
        return (VisitableBuilder<T, ?>) new EqualsBuilder((Equals) item);
      case "io.sundr.model." + "Enclosed":
        return (VisitableBuilder<T, ?>) new EnclosedBuilder((Enclosed) item);
      case "io.sundr.model." + "PreDecrement":
        return (VisitableBuilder<T, ?>) new PreDecrementBuilder((PreDecrement) item);
      case "io.sundr.model." + "PostDecrement":
        return (VisitableBuilder<T, ?>) new PostDecrementBuilder((PostDecrement) item);
      case "io.sundr.model." + "Lambda":
        return (VisitableBuilder<T, ?>) new LambdaBuilder((Lambda) item);
      case "io.sundr.model." + "Not":
        return (VisitableBuilder<T, ?>) new NotBuilder((Not) item);
      case "io.sundr.model." + "Assign":
        return (VisitableBuilder<T, ?>) new AssignBuilder((Assign) item);
      case "io.sundr.model." + "This":
        return (VisitableBuilder<T, ?>) new ThisBuilder((This) item);
      case "io.sundr.model." + "Negative":
        return (VisitableBuilder<T, ?>) new NegativeBuilder((Negative) item);
      case "io.sundr.model." + "LogicalAnd":
        return (VisitableBuilder<T, ?>) new LogicalAndBuilder((LogicalAnd) item);
      case "io.sundr.model." + "PostIncrement":
        return (VisitableBuilder<T, ?>) new PostIncrementBuilder((PostIncrement) item);
      case "io.sundr.model." + "RightUnsignedShift":
        return (VisitableBuilder<T, ?>) new RightUnsignedShiftBuilder((RightUnsignedShift) item);
      case "io.sundr.model." + "Plus":
        return (VisitableBuilder<T, ?>) new PlusBuilder((Plus) item);
      case "io.sundr.model." + "Construct":
        return (VisitableBuilder<T, ?>) new ConstructBuilder((Construct) item);
      case "io.sundr.model." + "Xor":
        return (VisitableBuilder<T, ?>) new XorBuilder((Xor) item);
      case "io.sundr.model." + "PreIncrement":
        return (VisitableBuilder<T, ?>) new PreIncrementBuilder((PreIncrement) item);
      case "io.sundr.model." + "Property":
        return (VisitableBuilder<T, ?>) new PropertyBuilder((Property) item);
      case "io.sundr.model." + "LessThanOrEqual":
        return (VisitableBuilder<T, ?>) new LessThanOrEqualBuilder((LessThanOrEqual) item);
      case "io.sundr.model." + "Positive":
        return (VisitableBuilder<T, ?>) new PositiveBuilder((Positive) item);
      case "io.sundr.model." + "ReturnDslThisStep":
        return (VisitableBuilder<T, ?>) new ReturnDslThisStepBuilder((ReturnDslThisStep) item);
      case "io.sundr.model." + "Switch":
        return (VisitableBuilder<T, ?>) new SwitchBuilder((Switch) item);
      case "io.sundr.model." + "Break":
        return (VisitableBuilder<T, ?>) new BreakBuilder((Break) item);
      case "io.sundr.model." + "While":
        return (VisitableBuilder<T, ?>) new WhileBuilder((While) item);
      case "io.sundr.model." + "Continue":
        return (VisitableBuilder<T, ?>) new ContinueBuilder((Continue) item);
      case "io.sundr.model." + "Throw":
        return (VisitableBuilder<T, ?>) new ThrowBuilder((Throw) item);
      case "io.sundr.model." + "StringStatement":
        return (VisitableBuilder<T, ?>) new StringStatementBuilder((StringStatement) item);
      case "io.sundr.model." + "Do":
        return (VisitableBuilder<T, ?>) new DoBuilder((Do) item);
      case "io.sundr.model." + "Foreach":
        return (VisitableBuilder<T, ?>) new ForeachBuilder((Foreach) item);
      case "io.sundr.model." + "Block":
        return (VisitableBuilder<T, ?>) new BlockBuilder((Block) item);
      case "io.sundr.model." + "ReturnDslVariableStep":
        return (VisitableBuilder<T, ?>) new ReturnDslVariableStepBuilder((ReturnDslVariableStep) item);
      case "io.sundr.model." + "If":
        return (VisitableBuilder<T, ?>) new IfBuilder((If) item);
      case "io.sundr.model." + "Return":
        return (VisitableBuilder<T, ?>) new ReturnBuilder((Return) item);
      case "io.sundr.model." + "IfDslThenStep":
        return (VisitableBuilder<T, ?>) new IfDslThenStepBuilder((IfDslThenStep) item);
      case "io.sundr.model." + "For":
        return (VisitableBuilder<T, ?>) new ForBuilder((For) item);
    }
    return (VisitableBuilder<T, ?>) builderOf(item);
  }

  public class MultiplyConditionNested<N> extends MultiplyFluent<MultiplyConditionNested<N>> implements Nested<N> {
    MultiplyConditionNested(Multiply item) {
      this.builder = new MultiplyBuilder(this, item);
    }

    MultiplyBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endMultiplyCondition() {
      return and();
    }

  }

  public class NewArrayConditionNested<N> extends NewArrayFluent<NewArrayConditionNested<N>> implements Nested<N> {
    NewArrayConditionNested(NewArray item) {
      this.builder = new NewArrayBuilder(this, item);
    }

    NewArrayBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endNewArrayCondition() {
      return and();
    }

  }

  public class InstanceOfConditionNested<N> extends InstanceOfFluent<InstanceOfConditionNested<N>> implements Nested<N> {
    InstanceOfConditionNested(InstanceOf item) {
      this.builder = new InstanceOfBuilder(this, item);
    }

    InstanceOfBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endInstanceOfCondition() {
      return and();
    }

  }

  public class MethodCallConditionNested<N> extends MethodCallFluent<MethodCallConditionNested<N>> implements Nested<N> {
    MethodCallConditionNested(MethodCall item) {
      this.builder = new MethodCallBuilder(this, item);
    }

    MethodCallBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endMethodCallCondition() {
      return and();
    }

  }

  public class InverseConditionNested<N> extends InverseFluent<InverseConditionNested<N>> implements Nested<N> {
    InverseConditionNested(Inverse item) {
      this.builder = new InverseBuilder(this, item);
    }

    InverseBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endInverseCondition() {
      return and();
    }

  }

  public class IndexConditionNested<N> extends IndexFluent<IndexConditionNested<N>> implements Nested<N> {
    IndexConditionNested(Index item) {
      this.builder = new IndexBuilder(this, item);
    }

    IndexBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endIndexCondition() {
      return and();
    }

  }

  public class GreaterThanOrEqualConditionNested<N> extends GreaterThanOrEqualFluent<GreaterThanOrEqualConditionNested<N>>
      implements Nested<N> {
    GreaterThanOrEqualConditionNested(GreaterThanOrEqual item) {
      this.builder = new GreaterThanOrEqualBuilder(this, item);
    }

    GreaterThanOrEqualBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endGreaterThanOrEqualCondition() {
      return and();
    }

  }

  public class BitwiseAndConditionNested<N> extends BitwiseAndFluent<BitwiseAndConditionNested<N>> implements Nested<N> {
    BitwiseAndConditionNested(BitwiseAnd item) {
      this.builder = new BitwiseAndBuilder(this, item);
    }

    BitwiseAndBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endBitwiseAndCondition() {
      return and();
    }

  }

  public class MinusConditionNested<N> extends MinusFluent<MinusConditionNested<N>> implements Nested<N> {
    MinusConditionNested(Minus item) {
      this.builder = new MinusBuilder(this, item);
    }

    MinusBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endMinusCondition() {
      return and();
    }

  }

  public class LogicalOrConditionNested<N> extends LogicalOrFluent<LogicalOrConditionNested<N>> implements Nested<N> {
    LogicalOrConditionNested(LogicalOr item) {
      this.builder = new LogicalOrBuilder(this, item);
    }

    LogicalOrBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endLogicalOrCondition() {
      return and();
    }

  }

  public class NotEqualsConditionNested<N> extends NotEqualsFluent<NotEqualsConditionNested<N>> implements Nested<N> {
    NotEqualsConditionNested(NotEquals item) {
      this.builder = new NotEqualsBuilder(this, item);
    }

    NotEqualsBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endNotEqualsCondition() {
      return and();
    }

  }

  public class DivideConditionNested<N> extends DivideFluent<DivideConditionNested<N>> implements Nested<N> {
    DivideConditionNested(Divide item) {
      this.builder = new DivideBuilder(this, item);
    }

    DivideBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endDivideCondition() {
      return and();
    }

  }

  public class LessThanConditionNested<N> extends LessThanFluent<LessThanConditionNested<N>> implements Nested<N> {
    LessThanConditionNested(LessThan item) {
      this.builder = new LessThanBuilder(this, item);
    }

    LessThanBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endLessThanCondition() {
      return and();
    }

  }

  public class BitwiseOrConditionNested<N> extends BitwiseOrFluent<BitwiseOrConditionNested<N>> implements Nested<N> {
    BitwiseOrConditionNested(BitwiseOr item) {
      this.builder = new BitwiseOrBuilder(this, item);
    }

    BitwiseOrBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endBitwiseOrCondition() {
      return and();
    }

  }

  public class PropertyRefConditionNested<N> extends PropertyRefFluent<PropertyRefConditionNested<N>> implements Nested<N> {
    PropertyRefConditionNested(PropertyRef item) {
      this.builder = new PropertyRefBuilder(this, item);
    }

    PropertyRefBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endPropertyRefCondition() {
      return and();
    }

  }

  public class RightShiftConditionNested<N> extends RightShiftFluent<RightShiftConditionNested<N>> implements Nested<N> {
    RightShiftConditionNested(RightShift item) {
      this.builder = new RightShiftBuilder(this, item);
    }

    RightShiftBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endRightShiftCondition() {
      return and();
    }

  }

  public class SuperConditionNested<N> extends SuperFluent<SuperConditionNested<N>> implements Nested<N> {
    SuperConditionNested(Super item) {
      this.builder = new SuperBuilder(this, item);
    }

    SuperBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endSuperCondition() {
      return and();
    }

  }

  public class GreaterThanConditionNested<N> extends GreaterThanFluent<GreaterThanConditionNested<N>> implements Nested<N> {
    GreaterThanConditionNested(GreaterThan item) {
      this.builder = new GreaterThanBuilder(this, item);
    }

    GreaterThanBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endGreaterThanCondition() {
      return and();
    }

  }

  public class DeclareConditionNested<N> extends DeclareFluent<DeclareConditionNested<N>> implements Nested<N> {
    DeclareConditionNested(Declare item) {
      this.builder = new DeclareBuilder(this, item);
    }

    DeclareBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endDeclareCondition() {
      return and();
    }

  }

  public class CastConditionNested<N> extends CastFluent<CastConditionNested<N>> implements Nested<N> {
    CastConditionNested(Cast item) {
      this.builder = new CastBuilder(this, item);
    }

    CastBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endCastCondition() {
      return and();
    }

  }

  public class ModuloConditionNested<N> extends ModuloFluent<ModuloConditionNested<N>> implements Nested<N> {
    ModuloConditionNested(Modulo item) {
      this.builder = new ModuloBuilder(this, item);
    }

    ModuloBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endModuloCondition() {
      return and();
    }

  }

  public class ValueRefConditionNested<N> extends ValueRefFluent<ValueRefConditionNested<N>> implements Nested<N> {
    ValueRefConditionNested(ValueRef item) {
      this.builder = new ValueRefBuilder(this, item);
    }

    ValueRefBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endValueRefCondition() {
      return and();
    }

  }

  public class LeftShiftConditionNested<N> extends LeftShiftFluent<LeftShiftConditionNested<N>> implements Nested<N> {
    LeftShiftConditionNested(LeftShift item) {
      this.builder = new LeftShiftBuilder(this, item);
    }

    LeftShiftBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endLeftShiftCondition() {
      return and();
    }

  }

  public class TernaryConditionNested<N> extends TernaryFluent<TernaryConditionNested<N>> implements Nested<N> {
    TernaryConditionNested(Ternary item) {
      this.builder = new TernaryBuilder(this, item);
    }

    TernaryBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endTernaryCondition() {
      return and();
    }

  }

  public class BinaryExpressionConditionNested<N> extends BinaryExpressionFluent<BinaryExpressionConditionNested<N>>
      implements Nested<N> {
    BinaryExpressionConditionNested(BinaryExpression item) {
      this.builder = new BinaryExpressionBuilder(this, item);
    }

    BinaryExpressionBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endBinaryExpressionCondition() {
      return and();
    }

  }

  public class EqualsConditionNested<N> extends EqualsFluent<EqualsConditionNested<N>> implements Nested<N> {
    EqualsConditionNested(Equals item) {
      this.builder = new EqualsBuilder(this, item);
    }

    EqualsBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endEqualsCondition() {
      return and();
    }

  }

  public class EnclosedConditionNested<N> extends EnclosedFluent<EnclosedConditionNested<N>> implements Nested<N> {
    EnclosedConditionNested(Enclosed item) {
      this.builder = new EnclosedBuilder(this, item);
    }

    EnclosedBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endEnclosedCondition() {
      return and();
    }

  }

  public class PreDecrementConditionNested<N> extends PreDecrementFluent<PreDecrementConditionNested<N>> implements Nested<N> {
    PreDecrementConditionNested(PreDecrement item) {
      this.builder = new PreDecrementBuilder(this, item);
    }

    PreDecrementBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endPreDecrementCondition() {
      return and();
    }

  }

  public class PostDecrementConditionNested<N> extends PostDecrementFluent<PostDecrementConditionNested<N>>
      implements Nested<N> {
    PostDecrementConditionNested(PostDecrement item) {
      this.builder = new PostDecrementBuilder(this, item);
    }

    PostDecrementBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endPostDecrementCondition() {
      return and();
    }

  }

  public class LambdaConditionNested<N> extends LambdaFluent<LambdaConditionNested<N>> implements Nested<N> {
    LambdaConditionNested(Lambda item) {
      this.builder = new LambdaBuilder(this, item);
    }

    LambdaBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endLambdaCondition() {
      return and();
    }

  }

  public class NotConditionNested<N> extends NotFluent<NotConditionNested<N>> implements Nested<N> {
    NotConditionNested(Not item) {
      this.builder = new NotBuilder(this, item);
    }

    NotBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endNotCondition() {
      return and();
    }

  }

  public class AssignConditionNested<N> extends AssignFluent<AssignConditionNested<N>> implements Nested<N> {
    AssignConditionNested(Assign item) {
      this.builder = new AssignBuilder(this, item);
    }

    AssignBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endAssignCondition() {
      return and();
    }

  }

  public class ThisConditionNested<N> extends ThisFluent<ThisConditionNested<N>> implements Nested<N> {
    ThisConditionNested(This item) {
      this.builder = new ThisBuilder(this, item);
    }

    ThisBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endThisCondition() {
      return and();
    }

  }

  public class NegativeConditionNested<N> extends NegativeFluent<NegativeConditionNested<N>> implements Nested<N> {
    NegativeConditionNested(Negative item) {
      this.builder = new NegativeBuilder(this, item);
    }

    NegativeBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endNegativeCondition() {
      return and();
    }

  }

  public class LogicalAndConditionNested<N> extends LogicalAndFluent<LogicalAndConditionNested<N>> implements Nested<N> {
    LogicalAndConditionNested(LogicalAnd item) {
      this.builder = new LogicalAndBuilder(this, item);
    }

    LogicalAndBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endLogicalAndCondition() {
      return and();
    }

  }

  public class PostIncrementConditionNested<N> extends PostIncrementFluent<PostIncrementConditionNested<N>>
      implements Nested<N> {
    PostIncrementConditionNested(PostIncrement item) {
      this.builder = new PostIncrementBuilder(this, item);
    }

    PostIncrementBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endPostIncrementCondition() {
      return and();
    }

  }

  public class RightUnsignedShiftConditionNested<N> extends RightUnsignedShiftFluent<RightUnsignedShiftConditionNested<N>>
      implements Nested<N> {
    RightUnsignedShiftConditionNested(RightUnsignedShift item) {
      this.builder = new RightUnsignedShiftBuilder(this, item);
    }

    RightUnsignedShiftBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endRightUnsignedShiftCondition() {
      return and();
    }

  }

  public class PlusConditionNested<N> extends PlusFluent<PlusConditionNested<N>> implements Nested<N> {
    PlusConditionNested(Plus item) {
      this.builder = new PlusBuilder(this, item);
    }

    PlusBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endPlusCondition() {
      return and();
    }

  }

  public class ConstructConditionNested<N> extends ConstructFluent<ConstructConditionNested<N>> implements Nested<N> {
    ConstructConditionNested(Construct item) {
      this.builder = new ConstructBuilder(this, item);
    }

    ConstructBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endConstructCondition() {
      return and();
    }

  }

  public class XorConditionNested<N> extends XorFluent<XorConditionNested<N>> implements Nested<N> {
    XorConditionNested(Xor item) {
      this.builder = new XorBuilder(this, item);
    }

    XorBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endXorCondition() {
      return and();
    }

  }

  public class PreIncrementConditionNested<N> extends PreIncrementFluent<PreIncrementConditionNested<N>> implements Nested<N> {
    PreIncrementConditionNested(PreIncrement item) {
      this.builder = new PreIncrementBuilder(this, item);
    }

    PreIncrementBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endPreIncrementCondition() {
      return and();
    }

  }

  public class PropertyConditionNested<N> extends PropertyFluent<PropertyConditionNested<N>> implements Nested<N> {
    PropertyConditionNested(Property item) {
      this.builder = new PropertyBuilder(this, item);
    }

    PropertyBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endPropertyCondition() {
      return and();
    }

  }

  public class LessThanOrEqualConditionNested<N> extends LessThanOrEqualFluent<LessThanOrEqualConditionNested<N>>
      implements Nested<N> {
    LessThanOrEqualConditionNested(LessThanOrEqual item) {
      this.builder = new LessThanOrEqualBuilder(this, item);
    }

    LessThanOrEqualBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endLessThanOrEqualCondition() {
      return and();
    }

  }

  public class PositiveConditionNested<N> extends PositiveFluent<PositiveConditionNested<N>> implements Nested<N> {
    PositiveConditionNested(Positive item) {
      this.builder = new PositiveBuilder(this, item);
    }

    PositiveBuilder builder;

    public N and() {
      return (N) IfDslThenStepFluent.this.withCondition(builder.build());
    }

    public N endPositiveCondition() {
      return and();
    }

  }

  public class ReturnDslThisStepStatementsNested<N> extends ReturnDslThisStepFluent<ReturnDslThisStepStatementsNested<N>>
      implements Nested<N> {
    ReturnDslThisStepStatementsNested(int index, ReturnDslThisStep item) {
      this.index = index;
      this.builder = new ReturnDslThisStepBuilder(this, item);
    }

    ReturnDslThisStepBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endReturnDslThisStepStatement() {
      return and();
    }

  }

  public class MethodCallStatementsNested<N> extends MethodCallFluent<MethodCallStatementsNested<N>> implements Nested<N> {
    MethodCallStatementsNested(int index, MethodCall item) {
      this.index = index;
      this.builder = new MethodCallBuilder(this, item);
    }

    MethodCallBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endMethodCallStatement() {
      return and();
    }

  }

  public class SwitchStatementsNested<N> extends SwitchFluent<SwitchStatementsNested<N>> implements Nested<N> {
    SwitchStatementsNested(int index, Switch item) {
      this.index = index;
      this.builder = new SwitchBuilder(this, item);
    }

    SwitchBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endSwitchStatement() {
      return and();
    }

  }

  public class BreakStatementsNested<N> extends BreakFluent<BreakStatementsNested<N>> implements Nested<N> {
    BreakStatementsNested(int index, Break item) {
      this.index = index;
      this.builder = new BreakBuilder(this, item);
    }

    BreakBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endBreakStatement() {
      return and();
    }

  }

  public class DeclareStatementsNested<N> extends DeclareFluent<DeclareStatementsNested<N>> implements Nested<N> {
    DeclareStatementsNested(int index, Declare item) {
      this.index = index;
      this.builder = new DeclareBuilder(this, item);
    }

    DeclareBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endDeclareStatement() {
      return and();
    }

  }

  public class WhileStatementsNested<N> extends WhileFluent<WhileStatementsNested<N>> implements Nested<N> {
    WhileStatementsNested(int index, While item) {
      this.index = index;
      this.builder = new WhileBuilder(this, item);
    }

    WhileBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endWhileStatement() {
      return and();
    }

  }

  public class ContinueStatementsNested<N> extends ContinueFluent<ContinueStatementsNested<N>> implements Nested<N> {
    ContinueStatementsNested(int index, Continue item) {
      this.index = index;
      this.builder = new ContinueBuilder(this, item);
    }

    ContinueBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endContinueStatement() {
      return and();
    }

  }

  public class ThrowStatementsNested<N> extends ThrowFluent<ThrowStatementsNested<N>> implements Nested<N> {
    ThrowStatementsNested(int index, Throw item) {
      this.index = index;
      this.builder = new ThrowBuilder(this, item);
    }

    ThrowBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endThrowStatement() {
      return and();
    }

  }

  public class StringStatementStatementsNested<N> extends StringStatementFluent<StringStatementStatementsNested<N>>
      implements Nested<N> {
    StringStatementStatementsNested(int index, StringStatement item) {
      this.index = index;
      this.builder = new StringStatementBuilder(this, item);
    }

    StringStatementBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endStringStatementStatement() {
      return and();
    }

  }

  public class DoStatementsNested<N> extends DoFluent<DoStatementsNested<N>> implements Nested<N> {
    DoStatementsNested(int index, Do item) {
      this.index = index;
      this.builder = new DoBuilder(this, item);
    }

    DoBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endDoStatement() {
      return and();
    }

  }

  public class ForeachStatementsNested<N> extends ForeachFluent<ForeachStatementsNested<N>> implements Nested<N> {
    ForeachStatementsNested(int index, Foreach item) {
      this.index = index;
      this.builder = new ForeachBuilder(this, item);
    }

    ForeachBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endForeachStatement() {
      return and();
    }

  }

  public class BlockStatementsNested<N> extends BlockFluent<BlockStatementsNested<N>> implements Nested<N> {
    BlockStatementsNested(int index, Block item) {
      this.index = index;
      this.builder = new BlockBuilder(this, item);
    }

    BlockBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endBlockStatement() {
      return and();
    }

  }

  public class ReturnDslVariableStepStatementsNested<N>
      extends ReturnDslVariableStepFluent<ReturnDslVariableStepStatementsNested<N>> implements Nested<N> {
    ReturnDslVariableStepStatementsNested(int index, ReturnDslVariableStep item) {
      this.index = index;
      this.builder = new ReturnDslVariableStepBuilder(this, item);
    }

    ReturnDslVariableStepBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endReturnDslVariableStepStatement() {
      return and();
    }

  }

  public class IfStatementsNested<N> extends IfFluent<IfStatementsNested<N>> implements Nested<N> {
    IfStatementsNested(int index, If item) {
      this.index = index;
      this.builder = new IfBuilder(this, item);
    }

    IfBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endIfStatement() {
      return and();
    }

  }

  public class LambdaStatementsNested<N> extends LambdaFluent<LambdaStatementsNested<N>> implements Nested<N> {
    LambdaStatementsNested(int index, Lambda item) {
      this.index = index;
      this.builder = new LambdaBuilder(this, item);
    }

    LambdaBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endLambdaStatement() {
      return and();
    }

  }

  public class ReturnStatementsNested<N> extends ReturnFluent<ReturnStatementsNested<N>> implements Nested<N> {
    ReturnStatementsNested(int index, Return item) {
      this.index = index;
      this.builder = new ReturnBuilder(this, item);
    }

    ReturnBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endReturnStatement() {
      return and();
    }

  }

  public class AssignStatementsNested<N> extends AssignFluent<AssignStatementsNested<N>> implements Nested<N> {
    AssignStatementsNested(int index, Assign item) {
      this.index = index;
      this.builder = new AssignBuilder(this, item);
    }

    AssignBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endAssignStatement() {
      return and();
    }

  }

  public class IfDslThenStepStatementsNested<N> extends IfDslThenStepFluent<IfDslThenStepStatementsNested<N>>
      implements Nested<N> {
    IfDslThenStepStatementsNested(int index, IfDslThenStep item) {
      this.index = index;
      this.builder = new IfDslThenStepBuilder(this, item);
    }

    IfDslThenStepBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endIfDslThenStepStatement() {
      return and();
    }

  }

  public class ForStatementsNested<N> extends ForFluent<ForStatementsNested<N>> implements Nested<N> {
    ForStatementsNested(int index, For item) {
      this.index = index;
      this.builder = new ForBuilder(this, item);
    }

    ForBuilder builder;
    int index;

    public N and() {
      return (N) IfDslThenStepFluent.this.setToStatements(index, builder.build());
    }

    public N endForStatement() {
      return and();
    }

  }

}
