/*
 * Copyright 2015 The original authors.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package io.sundr.maven.filter;

import org.apache.maven.artifact.Artifact;

import io.sundr.maven.Constants;

public class IncludePomsFilter implements ArtifactFilter {

  private final boolean include;

  public IncludePomsFilter(boolean include) {
    this.include = include;
  }

  public Artifact apply(Artifact artifact) {
    return artifact == null ? null : (include == Constants.POM_TYPE.equals(artifact.getType()) ? artifact : null);
  }

}
