/*
 * Copyright 2015 The original authors.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package io.sundr.maven;

/**
 * Information related to an external BOM dependency that should be imported.
 */
public class BomImport {

  private String groupId;

  private String artifactId;

  private String version;

  private String repository;

  private ArtifactSet dependencyManagement = new ArtifactSet();

  public BomImport() {
  }

  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  public String getArtifactId() {
    return artifactId;
  }

  public void setArtifactId(String artifactId) {
    this.artifactId = artifactId;
  }

  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public String getRepository() {
    return repository;
  }

  public void setRepository(String repository) {
    this.repository = repository;
  }

  public ArtifactSet getDependencyManagement() {
    return dependencyManagement;
  }

  public void setDependencyManagement(ArtifactSet dependencyManagement) {
    this.dependencyManagement = dependencyManagement;
  }

  @Override
  public String toString() {
    return groupId + ":" + artifactId + ":" + version;
  }
}
