/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.velocity;

import io.sundr.SundrException;
import io.sundr.codegen.template.TemplateRenderer;
import io.sundr.codegen.velocity.DirectiveProviders;
import io.sundr.utils.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.ParserPoolImpl;
import org.apache.velocity.runtime.log.SystemLogChute;
import org.apache.velocity.runtime.resource.ResourceCacheImpl;
import org.apache.velocity.runtime.resource.ResourceManagerImpl;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.apache.velocity.util.introspection.UberspectImpl;

public class VelocityRenderer<T>
extends TemplateRenderer<T> {
    private static final String TEMPLATE = "template";
    private static final String MODEL = "model";
    private static final String PARAMETERS = "parameters";
    private final StringResourceRepository repo;
    private final VelocityEngine velocityEngine;
    private final Template template;
    private final String[] parameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VelocityRenderer(String templateContent, String ... parameters) {
        this.parameters = parameters;
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("resource.loader", (Object)"string");
        this.velocityEngine.setProperty("string.resource.loader.class", (Object)StringResourceLoader.class.getName());
        this.velocityEngine.setProperty("resource.manager.class", (Object)ResourceManagerImpl.class.getName());
        this.velocityEngine.setProperty("resource.manager.cache.class", (Object)ResourceCacheImpl.class.getName());
        this.velocityEngine.setProperty("parser.pool.class", (Object)ParserPoolImpl.class.getName());
        this.velocityEngine.setProperty("runtime.introspector.uberspect", (Object)UberspectImpl.class.getName());
        this.velocityEngine.setProperty("runtime.log.logsystem.class", (Object)SystemLogChute.class.getName());
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(VelocityEngine.class.getClassLoader());
            this.velocityEngine.init();
            this.repo = StringResourceLoader.getRepository();
            this.repo.putStringResource(TEMPLATE, templateContent);
            DirectiveProviders.listDirectives().forEach(arg_0 -> ((VelocityEngine)this.velocityEngine).loadDirective(arg_0));
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
        this.template = this.velocityEngine.getTemplate(TEMPLATE);
    }

    public static Optional<VelocityRenderer<?>> fromTemplate(String templateContent, String ... parameters) {
        return Optional.of(new VelocityRenderer(templateContent, parameters));
    }

    public static <T> Optional<VelocityRenderer<T>> fromTemplate(String templateContent, Class<T> type, String ... parameters) {
        return Optional.of(new VelocityRenderer<T>(templateContent, parameters));
    }

    public static Optional<VelocityRenderer<?>> fromTemplateUrl(URL templateUrl, String ... parameters) {
        try {
            if (templateUrl == null) {
                return Optional.empty();
            }
            return VelocityRenderer.fromTemplate(Strings.loadResource((URL)templateUrl), parameters);
        }
        catch (IOException e) {
            throw SundrException.launderThrowable((Throwable)e);
        }
    }

    public static <T> Optional<VelocityRenderer<T>> fromTemplateUrl(URL templateUrl, Class<T> type, String ... parameters) {
        try {
            if (templateUrl == null) {
                return Optional.empty();
            }
            return VelocityRenderer.fromTemplate(Strings.loadResource((URL)templateUrl), type, parameters);
        }
        catch (IOException e) {
            throw SundrException.launderThrowable((Throwable)e);
        }
    }

    public static Optional<VelocityRenderer<?>> fromTemplateResource(String templateResource, String ... parameters) {
        return VelocityRenderer.fromTemplateUrl(VelocityContext.class.getResource(templateResource), parameters);
    }

    public static <T> Optional<VelocityRenderer<T>> fromTemplateResource(String templateResource, Class<T> type, String ... parameters) {
        return VelocityRenderer.fromTemplateUrl(VelocityContext.class.getResource(templateResource), type, parameters);
    }

    public Class<T> getType() {
        return Class.class;
    }

    public Function<T, String> getFunction() {
        return item -> {
            String string;
            VelocityContext velocityContext = new VelocityContext();
            StringWriter writer = new StringWriter();
            try {
                velocityContext.put(MODEL, item);
                velocityContext.put(PARAMETERS, (Object)this.parameters);
                this.template.merge((Context)velocityContext, (Writer)writer);
                writer.flush();
                string = writer.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            writer.close();
            return string;
        };
    }
}

