/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.deps.com.github.javaparser.ast.stmt;

import io.sundr.deps.com.github.javaparser.Position;
import io.sundr.deps.com.github.javaparser.Range;
import io.sundr.deps.com.github.javaparser.ast.expr.VariableDeclarationExpr;
import io.sundr.deps.com.github.javaparser.ast.internal.Utils;
import io.sundr.deps.com.github.javaparser.ast.stmt.BlockStmt;
import io.sundr.deps.com.github.javaparser.ast.stmt.CatchClause;
import io.sundr.deps.com.github.javaparser.ast.stmt.Statement;
import io.sundr.deps.com.github.javaparser.ast.visitor.GenericVisitor;
import io.sundr.deps.com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.List;

public final class TryStmt
extends Statement {
    private List<VariableDeclarationExpr> resources;
    private BlockStmt tryBlock;
    private List<CatchClause> catchs;
    private BlockStmt finallyBlock;

    public TryStmt() {
    }

    public TryStmt(BlockStmt tryBlock, List<CatchClause> catchs, BlockStmt finallyBlock) {
        this.setTryBlock(tryBlock);
        this.setCatchs(catchs);
        this.setFinallyBlock(finallyBlock);
    }

    @Deprecated
    public TryStmt(int beginLine, int beginColumn, int endLine, int endColumn, List<VariableDeclarationExpr> resources, BlockStmt tryBlock, List<CatchClause> catchs, BlockStmt finallyBlock) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), resources, tryBlock, catchs, finallyBlock);
    }

    public TryStmt(Range range, List<VariableDeclarationExpr> resources, BlockStmt tryBlock, List<CatchClause> catchs, BlockStmt finallyBlock) {
        super(range);
        this.setResources(resources);
        this.setTryBlock(tryBlock);
        this.setCatchs(catchs);
        this.setFinallyBlock(finallyBlock);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<CatchClause> getCatchs() {
        this.catchs = Utils.ensureNotNull(this.catchs);
        return this.catchs;
    }

    public BlockStmt getFinallyBlock() {
        return this.finallyBlock;
    }

    public BlockStmt getTryBlock() {
        return this.tryBlock;
    }

    public List<VariableDeclarationExpr> getResources() {
        this.resources = Utils.ensureNotNull(this.resources);
        return this.resources;
    }

    public void setCatchs(List<CatchClause> catchs) {
        this.catchs = catchs;
        this.setAsParentNodeOf(this.catchs);
    }

    public void setFinallyBlock(BlockStmt finallyBlock) {
        this.finallyBlock = finallyBlock;
        this.setAsParentNodeOf(this.finallyBlock);
    }

    public void setTryBlock(BlockStmt tryBlock) {
        this.tryBlock = tryBlock;
        this.setAsParentNodeOf(this.tryBlock);
    }

    public void setResources(List<VariableDeclarationExpr> resources) {
        this.resources = resources;
        this.setAsParentNodeOf(this.resources);
    }
}

