/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.deps.com.github.javaparser.ast.expr;

import io.sundr.deps.com.github.javaparser.Position;
import io.sundr.deps.com.github.javaparser.Range;
import io.sundr.deps.com.github.javaparser.ast.expr.Expression;
import io.sundr.deps.com.github.javaparser.ast.expr.NameExpr;
import io.sundr.deps.com.github.javaparser.ast.internal.Utils;
import io.sundr.deps.com.github.javaparser.ast.type.Type;
import io.sundr.deps.com.github.javaparser.ast.visitor.GenericVisitor;
import io.sundr.deps.com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.List;

public final class FieldAccessExpr
extends Expression {
    private Expression scope;
    private List<Type> typeArgs;
    private NameExpr field;

    public FieldAccessExpr() {
    }

    public FieldAccessExpr(Expression scope, String field) {
        this.setScope(scope);
        this.setField(field);
    }

    @Deprecated
    public FieldAccessExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression scope, List<Type> typeArgs, String field) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), scope, typeArgs, field);
    }

    public FieldAccessExpr(Range range, Expression scope, List<Type> typeArgs, String field) {
        super(range);
        this.setScope(scope);
        this.setTypeArgs(typeArgs);
        this.setField(field);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public String getField() {
        return this.field.getName();
    }

    public NameExpr getFieldExpr() {
        return this.field;
    }

    public Expression getScope() {
        return this.scope;
    }

    public List<Type> getTypeArgs() {
        this.typeArgs = Utils.ensureNotNull(this.typeArgs);
        return this.typeArgs;
    }

    public void setField(String field) {
        this.setFieldExpr(new NameExpr(field));
    }

    public void setFieldExpr(NameExpr field) {
        this.field = field;
        this.setAsParentNodeOf(this.field);
    }

    public void setScope(Expression scope) {
        this.scope = scope;
        this.setAsParentNodeOf(this.scope);
    }

    public void setTypeArgs(List<Type> typeArgs) {
        this.typeArgs = typeArgs;
        this.setAsParentNodeOf(this.typeArgs);
    }
}

