/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.api;

import io.sundr.adapter.api.Adapter;
import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.api.AdapterContextAware;
import io.sundr.adapter.api.AdapterFactory;
import io.sundr.model.Method;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeRef;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class Adapters {
    public static <T, R, P, M> TypeDef adaptType(T input, AdapterContextAware ctx) {
        if (input == null) {
            throw new IllegalArgumentException("Adapter.adapt(null, ctx) is not allowed!");
        }
        return Adapters.getAdapterForType(input.getClass(), ctx).map(a -> a.adaptType(input)).orElseThrow(() -> new IllegalStateException("No adapter found for type: " + String.valueOf(input.getClass())));
    }

    public static <T, R, P, M> TypeRef adaptReference(R input, AdapterContextAware ctx) {
        if (input == null) {
            throw new IllegalArgumentException("Adapter.adapt(null, ctx) is not allowed!");
        }
        return Adapters.getAdapterForReference(input.getClass(), ctx).map(a -> a.adaptReference(input)).orElseThrow(() -> new IllegalStateException("No adapter found for reference: " + String.valueOf(input.getClass())));
    }

    public static <T, R, P, M> Property adaptProperty(P input, AdapterContextAware ctx) {
        if (input == null) {
            throw new IllegalArgumentException("Adapter.adapt(null, ctx) is not allowed!");
        }
        return Adapters.getAdapterForProperty(input.getClass(), ctx).map(a -> a.adaptProperty(input)).orElseThrow(() -> new IllegalStateException("No adapter found for property: " + String.valueOf(input.getClass())));
    }

    public static <T, R, P, M> Method adaptMethod(M input, AdapterContextAware ctx) {
        if (input == null) {
            throw new IllegalArgumentException("Adapter.adapt(null, ctx) is not allowed!");
        }
        return Adapters.getAdapterForMethod(input.getClass(), ctx).map(a -> a.adaptMethod(input)).orElseThrow(() -> new IllegalStateException("No adapter found for method: " + String.valueOf(input.getClass())));
    }

    public static <T, R, P, M> Optional<Adapter<T, R, P, M>> getAdapterForType(Class type, AdapterContextAware ctx) {
        return StreamSupport.stream(ServiceLoader.load(AdapterFactory.class, Adapter.class.getClassLoader()).spliterator(), false).filter(f -> f.getTypeAdapterType() != null).filter(f -> f.getTypeAdapterType().isAssignableFrom(type)).map(f -> f.create(ctx.getAdapterContext())).findFirst();
    }

    public static <T, R, P, M> Optional<Adapter<T, R, P, M>> getAdapterForReference(Class type, AdapterContextAware ctx) {
        return StreamSupport.stream(ServiceLoader.load(AdapterFactory.class, Adapter.class.getClassLoader()).spliterator(), false).filter(f -> f.getReferenceAdapterType() != null).filter(f -> f.getReferenceAdapterType().isAssignableFrom(type)).map(f -> f.create(ctx.getAdapterContext())).findFirst();
    }

    public static <T, R, P, M> Optional<Adapter<T, R, P, M>> getAdapterForProperty(Class type, AdapterContextAware ctx) {
        return StreamSupport.stream(ServiceLoader.load(AdapterFactory.class, Adapter.class.getClassLoader()).spliterator(), false).filter(f -> f.getPropertyAdapterType() != null).filter(f -> f.getPropertyAdapterType().isAssignableFrom(type)).map(f -> f.create(ctx.getAdapterContext())).findFirst();
    }

    public static <T, R, P, M> Optional<Adapter<T, R, P, M>> getAdapterForMethod(Class type, AdapterContextAware ctx) {
        return StreamSupport.stream(ServiceLoader.load(AdapterFactory.class, Adapter.class.getClassLoader()).spliterator(), false).filter(f -> f.getMethodAdapterType() != null).filter(f -> f.getMethodAdapterType().isAssignableFrom(type)).map(f -> f.create(ctx.getAdapterContext())).findFirst();
    }

    public static WithContext withContext(AdapterContext ctx) {
        return new WithContext(ctx);
    }

    public static class WithContext {
        private final AdapterContext ctx;

        public WithContext(AdapterContext ctx) {
            this.ctx = ctx;
        }

        public <T> TypeDef adaptType(T input) {
            return Adapters.adaptType(input, this.ctx);
        }

        public <R> TypeRef adaptReference(R input) {
            return Adapters.adaptReference(input, this.ctx);
        }

        public <P> Property adaptProperty(P input) {
            return Adapters.adaptProperty(input, this.ctx);
        }

        public <M> Method adaptMethod(M input) {
            return Adapters.adaptMethod(input, this.ctx);
        }
    }
}

