/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.examples.dto.generator;

import io.sundr.model.AnnotationRef;
import io.sundr.model.ClassRef;
import io.sundr.model.Method;
import io.sundr.model.ModifierSupportFluent;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.repo.DefinitionRepository;
import java.util.ArrayList;
import java.util.function.Function;

public class DtoGenerator
implements Function<TypeDef, TypeDef> {
    @Override
    public TypeDef apply(TypeDef originalType) {
        if (originalType == null) {
            return null;
        }
        ArrayList<Property> dtoProperties = new ArrayList<Property>();
        for (Property property : originalType.getProperties()) {
            Property transformedProperty = this.transformProperty(property);
            if (transformedProperty == null) continue;
            dtoProperties.add(transformedProperty);
        }
        return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(originalType).withName(originalType.getName() + "Dto")).withAnnotations(new AnnotationRef[0])).withProperties(dtoProperties)).withConstructors(new Method[0])).withMethods(new Method[0])).build();
    }

    private Property transformProperty(Property property) {
        TypeRef typeRef = property.getTypeRef();
        if (property.getModifiers().isStatic()) {
            return null;
        }
        if (typeRef instanceof ClassRef) {
            TypeRef idType;
            ClassRef classRef = (ClassRef)typeRef;
            TypeDef referencedType = DefinitionRepository.getRepository().getDefinition((TypeRef)classRef);
            if (this.isJpaEntity(referencedType) && (idType = this.findIdFieldType(referencedType)) != null) {
                return ((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((ModifierSupportFluent.ModifiersNested)new PropertyBuilder(property).withNewModifiers().withPublic()).endModifiers()).withTypeRef(idType)).withName(property.getName() + "Id")).withAnnotations(new AnnotationRef[0])).build();
            }
        }
        return ((PropertyBuilder)((PropertyBuilder)((ModifierSupportFluent.ModifiersNested)new PropertyBuilder(property).withNewModifiers().withPublic()).endModifiers()).withAnnotations(new AnnotationRef[0])).build();
    }

    private boolean isJpaEntity(TypeDef typeDef) {
        if (typeDef == null) {
            return false;
        }
        for (AnnotationRef annotation : typeDef.getAnnotations()) {
            if (!annotation.getClassRef().getFullyQualifiedName().equals("jakarta.persistence.Entity")) continue;
            return true;
        }
        for (Property property : typeDef.getProperties()) {
            for (AnnotationRef annotation : property.getAnnotations()) {
                if (!annotation.getClassRef().getFullyQualifiedName().equals("jakarta.persistence.Id")) continue;
                return true;
            }
        }
        return false;
    }

    private TypeRef findIdFieldType(TypeDef typeDef) {
        if (typeDef == null) {
            return null;
        }
        for (Property property : typeDef.getProperties()) {
            for (AnnotationRef annotation : property.getAnnotations()) {
                if (!annotation.getClassRef().getFullyQualifiedName().equals("jakarta.persistence.Id")) continue;
                return property.getTypeRef();
            }
        }
        return ClassRef.forName((String)"java.lang.Long");
    }
}

