/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.examples;

import io.sundr.builder.BaseFluent;
import io.sundr.examples.Person;
import java.util.Objects;

public class PersonFluent<A extends PersonFluent<A>>
extends BaseFluent<A> {
    private String firstName;
    private String lastName;

    public PersonFluent() {
    }

    public PersonFluent(Person instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Person instance) {
        if (instance != null) {
            this.withFirstName(instance.getFirstName());
            this.withLastName(instance.getLastName());
        }
    }

    public String getFirstName() {
        return this.firstName;
    }

    public A withFirstName(String firstName) {
        this.firstName = firstName;
        return (A)((Object)this);
    }

    public boolean hasFirstName() {
        return this.firstName != null;
    }

    public String getLastName() {
        return this.lastName;
    }

    public A withLastName(String lastName) {
        this.lastName = lastName;
        return (A)((Object)this);
    }

    public boolean hasLastName() {
        return this.lastName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersonFluent that = (PersonFluent)((Object)o);
        if (!Objects.equals(this.firstName, that.firstName)) {
            return false;
        }
        return Objects.equals(this.lastName, that.lastName);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.firstName != null) {
            sb.append("firstName:");
            sb.append(this.firstName);
            sb.append(",");
        }
        if (this.lastName != null) {
            sb.append("lastName:");
            sb.append(this.lastName);
        }
        sb.append("}");
        return sb.toString();
    }
}

