/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.examples;

import io.sundr.builder.BaseFluent;
import io.sundr.builder.Nested;
import io.sundr.examples.Family;
import io.sundr.examples.Person;
import io.sundr.examples.PersonBuilder;
import io.sundr.examples.PersonFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class FamilyFluent<A extends FamilyFluent<A>>
extends BaseFluent<A> {
    private PersonBuilder father;
    private PersonBuilder mother;
    private ArrayList<PersonBuilder> children;

    public FamilyFluent() {
    }

    public FamilyFluent(Family instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Family instance) {
        if (instance != null) {
            this.withFather(instance.getFather());
            this.withMother(instance.getMother());
            this.withChildren(instance.getChildren());
        }
    }

    public Person buildFather() {
        return this.father != null ? this.father.build() : null;
    }

    public A withFather(Person father) {
        this._visitables.remove((Object)"father");
        if (father != null) {
            this.father = new PersonBuilder(father);
            this._visitables.get((Object)"father").add(this.father);
        } else {
            this.father = null;
            this._visitables.get((Object)"father").remove((Object)this.father);
        }
        return (A)((Object)this);
    }

    public boolean hasFather() {
        return this.father != null;
    }

    public FatherNested<A> withNewFather() {
        return new FatherNested(null);
    }

    public FatherNested<A> withNewFatherLike(Person item) {
        return new FatherNested(item);
    }

    public FatherNested<A> editFather() {
        return this.withNewFatherLike(Optional.ofNullable(this.buildFather()).orElse(null));
    }

    public FatherNested<A> editOrNewFather() {
        return this.withNewFatherLike(Optional.ofNullable(this.buildFather()).orElse(new PersonBuilder().build()));
    }

    public FatherNested<A> editOrNewFatherLike(Person item) {
        return this.withNewFatherLike(Optional.ofNullable(this.buildFather()).orElse(item));
    }

    public Person buildMother() {
        return this.mother != null ? this.mother.build() : null;
    }

    public A withMother(Person mother) {
        this._visitables.remove((Object)"mother");
        if (mother != null) {
            this.mother = new PersonBuilder(mother);
            this._visitables.get((Object)"mother").add(this.mother);
        } else {
            this.mother = null;
            this._visitables.get((Object)"mother").remove((Object)this.mother);
        }
        return (A)((Object)this);
    }

    public boolean hasMother() {
        return this.mother != null;
    }

    public MotherNested<A> withNewMother() {
        return new MotherNested(null);
    }

    public MotherNested<A> withNewMotherLike(Person item) {
        return new MotherNested(item);
    }

    public MotherNested<A> editMother() {
        return this.withNewMotherLike(Optional.ofNullable(this.buildMother()).orElse(null));
    }

    public MotherNested<A> editOrNewMother() {
        return this.withNewMotherLike(Optional.ofNullable(this.buildMother()).orElse(new PersonBuilder().build()));
    }

    public MotherNested<A> editOrNewMotherLike(Person item) {
        return this.withNewMotherLike(Optional.ofNullable(this.buildMother()).orElse(item));
    }

    public A addToChildren(int index, Person item) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        PersonBuilder builder = new PersonBuilder(item);
        if (index < 0 || index >= this.children.size()) {
            this._visitables.get((Object)"children").add(builder);
            this.children.add(builder);
        } else {
            this._visitables.get((Object)"children").add(builder);
            this.children.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToChildren(int index, Person item) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        PersonBuilder builder = new PersonBuilder(item);
        if (index < 0 || index >= this.children.size()) {
            this._visitables.get((Object)"children").add(builder);
            this.children.add(builder);
        } else {
            this._visitables.get((Object)"children").add(builder);
            this.children.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToChildren(Person ... items) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        for (Person item : items) {
            PersonBuilder builder = new PersonBuilder(item);
            this._visitables.get((Object)"children").add(builder);
            this.children.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToChildren(Collection<Person> items) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        for (Person item : items) {
            PersonBuilder builder = new PersonBuilder(item);
            this._visitables.get((Object)"children").add(builder);
            this.children.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromChildren(Person ... items) {
        if (this.children == null) {
            return (A)((Object)this);
        }
        for (Person item : items) {
            PersonBuilder builder = new PersonBuilder(item);
            this._visitables.get((Object)"children").remove((Object)builder);
            this.children.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromChildren(Collection<Person> items) {
        if (this.children == null) {
            return (A)((Object)this);
        }
        for (Person item : items) {
            PersonBuilder builder = new PersonBuilder(item);
            this._visitables.get((Object)"children").remove((Object)builder);
            this.children.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromChildren(Predicate<PersonBuilder> predicate) {
        if (this.children == null) {
            return (A)((Object)this);
        }
        Iterator<PersonBuilder> each = this.children.iterator();
        List visitables = this._visitables.get((Object)"children");
        while (each.hasNext()) {
            PersonBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Person> buildChildren() {
        return this.children != null ? FamilyFluent.build(this.children) : null;
    }

    public Person buildChild(int index) {
        return this.children.get(index).build();
    }

    public Person buildFirstChild() {
        return this.children.get(0).build();
    }

    public Person buildLastChild() {
        return this.children.get(this.children.size() - 1).build();
    }

    public Person buildMatchingChild(Predicate<PersonBuilder> predicate) {
        for (PersonBuilder item : this.children) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingChild(Predicate<PersonBuilder> predicate) {
        for (PersonBuilder item : this.children) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withChildren(List<Person> children) {
        if (this.children != null) {
            this._visitables.get((Object)"children").clear();
        }
        if (children != null) {
            this.children = new ArrayList();
            for (Person item : children) {
                this.addToChildren(item);
            }
        } else {
            this.children = null;
        }
        return (A)((Object)this);
    }

    public A withChildren(Person ... children) {
        if (this.children != null) {
            this.children.clear();
            this._visitables.remove((Object)"children");
        }
        if (children != null) {
            for (Person item : children) {
                this.addToChildren(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public ChildrenNested<A> addNewChild() {
        return new ChildrenNested(-1, null);
    }

    public ChildrenNested<A> addNewChildLike(Person item) {
        return new ChildrenNested(-1, item);
    }

    public ChildrenNested<A> setNewChildLike(int index, Person item) {
        return new ChildrenNested(index, item);
    }

    public ChildrenNested<A> editChild(int index) {
        if (index <= this.children.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "children"));
        }
        return this.setNewChildLike(index, this.buildChild(index));
    }

    public ChildrenNested<A> editFirstChild() {
        if (this.children.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "children"));
        }
        return this.setNewChildLike(0, this.buildChild(0));
    }

    public ChildrenNested<A> editLastChild() {
        int index = this.children.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "children"));
        }
        return this.setNewChildLike(index, this.buildChild(index));
    }

    public ChildrenNested<A> editMatchingChild(Predicate<PersonBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!predicate.test(this.children.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "children"));
        }
        return this.setNewChildLike(index, this.buildChild(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FamilyFluent that = (FamilyFluent)((Object)o);
        if (!Objects.equals((Object)this.father, (Object)that.father)) {
            return false;
        }
        if (!Objects.equals((Object)this.mother, (Object)that.mother)) {
            return false;
        }
        return Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.father, this.mother, this.children});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.father != null) {
            sb.append("father:");
            sb.append((Object)this.father);
            sb.append(",");
        }
        if (this.mother != null) {
            sb.append("mother:");
            sb.append((Object)this.mother);
            sb.append(",");
        }
        if (this.children != null && !this.children.isEmpty()) {
            sb.append("children:");
            sb.append(this.children);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FatherNested<N>
    extends PersonFluent<FatherNested<N>>
    implements Nested<N> {
        PersonBuilder builder;

        FatherNested(Person item) {
            this.builder = new PersonBuilder(this, item);
        }

        public N and() {
            return (N)FamilyFluent.this.withFather(this.builder.build());
        }

        public N endFather() {
            return this.and();
        }
    }

    public class MotherNested<N>
    extends PersonFluent<MotherNested<N>>
    implements Nested<N> {
        PersonBuilder builder;

        MotherNested(Person item) {
            this.builder = new PersonBuilder(this, item);
        }

        public N and() {
            return (N)FamilyFluent.this.withMother(this.builder.build());
        }

        public N endMother() {
            return this.and();
        }
    }

    public class ChildrenNested<N>
    extends PersonFluent<ChildrenNested<N>>
    implements Nested<N> {
        PersonBuilder builder;
        int index;

        ChildrenNested(int index, Person item) {
            this.index = index;
            this.builder = new PersonBuilder(this, item);
        }

        public N and() {
            return (N)FamilyFluent.this.setToChildren(this.index, this.builder.build());
        }

        public N endChild() {
            return this.and();
        }
    }
}

