package io.sundr.examples;

import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import io.sundr.builder.BaseFluent;
import java.util.Objects;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PersonFluent<A extends io.sundr.examples.PersonFluent<A>> extends BaseFluent<A>{
  public PersonFluent() {
  }
  
  public PersonFluent(Person instance) {
    this.copyInstance(instance);
  }
  private String firstName;
  private String lastName;
  
  protected void copyInstance(Person instance) {
    instance = instance != null ? instance : new Person();
    if (instance != null) {
        this.withFirstName(instance.getFirstName());
        this.withLastName(instance.getLastName());
    }
  }
  
  public String getFirstName() {
    return this.firstName;
  }
  
  public A withFirstName(String firstName) {
    this.firstName = firstName;
    return (A) this;
  }
  
  public boolean hasFirstName() {
    return this.firstName != null;
  }
  
  public String getLastName() {
    return this.lastName;
  }
  
  public A withLastName(String lastName) {
    this.lastName = lastName;
    return (A) this;
  }
  
  public boolean hasLastName() {
    return this.lastName != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }
    if (!(super.equals(o))) {
      return false;
    }
    PersonFluent that = (PersonFluent) o;
    if (!(Objects.equals(firstName, that.firstName))) {
      return false;
    }
    if (!(Objects.equals(lastName, that.lastName))) {
      return false;
    }
    return true;
  }
  
  public int hashCode() {
    return Objects.hash(firstName, lastName);
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (!(firstName == null)) {
        sb.append("firstName:");
        sb.append(firstName);
        sb.append(",");
    }
    if (!(lastName == null)) {
        sb.append("lastName:");
        sb.append(lastName);
    }
    sb.append("}");
    return sb.toString();
  }
  

}