package io.sundr.examples;

import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import io.sundr.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.RuntimeException;
import io.sundr.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Objects;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FamilyFluent<A extends io.sundr.examples.FamilyFluent<A>> extends BaseFluent<A>{
  public FamilyFluent() {
  }
  
  public FamilyFluent(Family instance) {
    this.copyInstance(instance);
  }
  private PersonBuilder father;
  private PersonBuilder mother;
  private ArrayList<PersonBuilder> children;
  
  protected void copyInstance(Family instance) {
    if (instance != null) {
        this.withFather(instance.getFather());
        this.withMother(instance.getMother());
        this.withChildren(instance.getChildren());
    }
  }
  
  public Person buildFather() {
    return this.father != null ? this.father.build() : null;
  }
  
  public A withFather(Person father) {
    this._visitables.remove("father");
    if (father != null) {
        this.father = new PersonBuilder(father);
        this._visitables.get("father").add(this.father);
    } else {
        this.father = null;
        this._visitables.get("father").remove(this.father);
    }
    return (A) this;
  }
  
  public boolean hasFather() {
    return this.father != null;
  }
  
  public FatherNested<A> withNewFather() {
    return new FatherNested(null);
  }
  
  public FatherNested<A> withNewFatherLike(Person item) {
    return new FatherNested(item);
  }
  
  public FatherNested<A> editFather() {
    return this.withNewFatherLike(Optional.ofNullable(this.buildFather()).orElse(null));
  }
  
  public FatherNested<A> editOrNewFather() {
    return this.withNewFatherLike(Optional.ofNullable(this.buildFather()).orElse(new PersonBuilder().build()));
  }
  
  public FatherNested<A> editOrNewFatherLike(Person item) {
    return this.withNewFatherLike(Optional.ofNullable(this.buildFather()).orElse(item));
  }
  
  public Person buildMother() {
    return this.mother != null ? this.mother.build() : null;
  }
  
  public A withMother(Person mother) {
    this._visitables.remove("mother");
    if (mother != null) {
        this.mother = new PersonBuilder(mother);
        this._visitables.get("mother").add(this.mother);
    } else {
        this.mother = null;
        this._visitables.get("mother").remove(this.mother);
    }
    return (A) this;
  }
  
  public boolean hasMother() {
    return this.mother != null;
  }
  
  public MotherNested<A> withNewMother() {
    return new MotherNested(null);
  }
  
  public MotherNested<A> withNewMotherLike(Person item) {
    return new MotherNested(item);
  }
  
  public MotherNested<A> editMother() {
    return this.withNewMotherLike(Optional.ofNullable(this.buildMother()).orElse(null));
  }
  
  public MotherNested<A> editOrNewMother() {
    return this.withNewMotherLike(Optional.ofNullable(this.buildMother()).orElse(new PersonBuilder().build()));
  }
  
  public MotherNested<A> editOrNewMotherLike(Person item) {
    return this.withNewMotherLike(Optional.ofNullable(this.buildMother()).orElse(item));
  }
  
  public A addToChildren(int index,Person item) {
    if (this.children == null) {
      this.children = new ArrayList();
    }
    PersonBuilder builder = new PersonBuilder(item);
    if (index < 0 || index >= children.size()) {
        _visitables.get("children").add(builder);
        children.add(builder);
    } else {
        _visitables.get("children").add(builder);
        children.add(index, builder);
    }
    return (A) this;
  }
  
  public A setToChildren(int index,Person item) {
    if (this.children == null) {
      this.children = new ArrayList();
    }
    PersonBuilder builder = new PersonBuilder(item);
    if (index < 0 || index >= children.size()) {
        _visitables.get("children").add(builder);
        children.add(builder);
    } else {
        _visitables.get("children").add(builder);
        children.set(index, builder);
    }
    return (A) this;
  }
  
  public A addToChildren(Person... items) {
    if (this.children == null) {
      this.children = new ArrayList();
    }
    for (Person item : items) {
        PersonBuilder builder = new PersonBuilder(item);
        _visitables.get("children").add(builder);
        this.children.add(builder);
    }
    return (A) this;
  }
  
  public A addAllToChildren(Collection<Person> items) {
    if (this.children == null) {
      this.children = new ArrayList();
    }
    for (Person item : items) {
        PersonBuilder builder = new PersonBuilder(item);
        _visitables.get("children").add(builder);
        this.children.add(builder);
    }
    return (A) this;
  }
  
  public A removeFromChildren(Person... items) {
    if (this.children == null) {
      return (A) this;
    }
    for (Person item : items) {
        PersonBuilder builder = new PersonBuilder(item);
        _visitables.get("children").remove(builder);
        this.children.remove(builder);
    }
    return (A) this;
  }
  
  public A removeAllFromChildren(Collection<Person> items) {
    if (this.children == null) {
      return (A) this;
    }
    for (Person item : items) {
        PersonBuilder builder = new PersonBuilder(item);
        _visitables.get("children").remove(builder);
        this.children.remove(builder);
    }
    return (A) this;
  }
  
  public A removeMatchingFromChildren(Predicate<PersonBuilder> predicate) {
    if (children == null) {
      return (A) this;
    }
    Iterator<PersonBuilder> each = children.iterator();
    List visitables = _visitables.get("children");
    while (each.hasNext()) {
        PersonBuilder builder = each.next();
        if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
        }
    }
    return (A) this;
  }
  
  public List<Person> buildChildren() {
    return this.children != null ? build(children) : null;
  }
  
  public Person buildChild(int index) {
    return this.children.get(index).build();
  }
  
  public Person buildFirstChild() {
    return this.children.get(0).build();
  }
  
  public Person buildLastChild() {
    return this.children.get(children.size() - 1).build();
  }
  
  public Person buildMatchingChild(Predicate<PersonBuilder> predicate) {
      for (PersonBuilder item : children) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingChild(Predicate<PersonBuilder> predicate) {
      for (PersonBuilder item : children) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withChildren(List<Person> children) {
    if (this.children != null) {
      this._visitables.get("children").clear();
    }
    if (children != null) {
        this.children = new ArrayList();
        for (Person item : children) {
          this.addToChildren(item);
        }
    } else {
      this.children = null;
    }
    return (A) this;
  }
  
  public A withChildren(Person... children) {
    if (this.children != null) {
        this.children.clear();
        _visitables.remove("children");
    }
    if (children != null) {
      for (Person item : children) {
        this.addToChildren(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasChildren() {
    return this.children != null && !(this.children.isEmpty());
  }
  
  public ChildrenNested<A> addNewChild() {
    return new ChildrenNested(-1, null);
  }
  
  public ChildrenNested<A> addNewChildLike(Person item) {
    return new ChildrenNested(-1, item);
  }
  
  public ChildrenNested<A> setNewChildLike(int index,Person item) {
    return new ChildrenNested(index, item);
  }
  
  public ChildrenNested<A> editChild(int index) {
    if (index <= children.size()) {
      throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "children"));
    }
    return this.setNewChildLike(index, this.buildChild(index));
  }
  
  public ChildrenNested<A> editFirstChild() {
    if (children.size() == 0) {
      throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "children"));
    }
    return this.setNewChildLike(0, this.buildChild(0));
  }
  
  public ChildrenNested<A> editLastChild() {
    int index = children.size() - 1;
    if (index < 0) {
      throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "children"));
    }
    return this.setNewChildLike(index, this.buildChild(index));
  }
  
  public ChildrenNested<A> editMatchingChild(Predicate<PersonBuilder> predicate) {
    int index = -1;
    for (int i = 0;i < children.size();i++) {
      if (predicate.test(children.get(i))) {
          index = i;
          break;
      }
    }
    if (index < 0) {
      throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "children"));
    }
    return this.setNewChildLike(index, this.buildChild(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }
    if (!(super.equals(o))) {
      return false;
    }
    FamilyFluent that = (FamilyFluent) o;
    if (!(Objects.equals(father, that.father))) {
      return false;
    }
    if (!(Objects.equals(mother, that.mother))) {
      return false;
    }
    if (!(Objects.equals(children, that.children))) {
      return false;
    }
    return true;
  }
  
  public int hashCode() {
    return Objects.hash(father, mother, children);
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (!(father == null)) {
        sb.append("father:");
        sb.append(father);
        sb.append(",");
    }
    if (!(mother == null)) {
        sb.append("mother:");
        sb.append(mother);
        sb.append(",");
    }
    if (!(children == null) && !(children.isEmpty())) {
        sb.append("children:");
        sb.append(children);
    }
    sb.append("}");
    return sb.toString();
  }
  public class FatherNested<N> extends PersonFluent<FatherNested<N>> implements Nested<N>{
    FatherNested(Person item) {
      this.builder = new PersonBuilder(this, item);
    }
    PersonBuilder builder;
    
    public N and() {
      return (N) FamilyFluent.this.withFather(builder.build());
    }
    
    public N endFather() {
      return and();
    }
    
  
  }
  public class MotherNested<N> extends PersonFluent<MotherNested<N>> implements Nested<N>{
    MotherNested(Person item) {
      this.builder = new PersonBuilder(this, item);
    }
    PersonBuilder builder;
    
    public N and() {
      return (N) FamilyFluent.this.withMother(builder.build());
    }
    
    public N endMother() {
      return and();
    }
    
  
  }
  public class ChildrenNested<N> extends PersonFluent<ChildrenNested<N>> implements Nested<N>{
    ChildrenNested(int index,Person item) {
      this.index = index;
      this.builder = new PersonBuilder(this, item);
    }
    PersonBuilder builder;
    int index;
    
    public N and() {
      return (N) FamilyFluent.this.setToChildren(index, builder.build());
    }
    
    public N endChild() {
      return and();
    }
    
  
  }

}