package io.sundr.examples;

import io.sundr.examples.builder.VisitableBuilder;
import java.lang.Object;

/**
 * Generated
 */
public class PersonBuilder extends PersonFluent<PersonBuilder> implements VisitableBuilder<Person,PersonBuilder>{

  PersonFluent<?> fluent;

  public PersonBuilder() {
    this.fluent = this;
  }
  
  public PersonBuilder(PersonFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public PersonBuilder(Person instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  
  public PersonBuilder(PersonFluent<?> fluent,Person instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }

  public EditablePerson build() {
    EditablePerson buildable = new EditablePerson(fluent.getFirstName(), fluent.getLastName());
    return buildable;
  }
  
}