package io.sundr.examples;

import io.sundr.examples.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.Objects;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PersonFluent<A extends io.sundr.examples.PersonFluent<A>> extends BaseFluent<A>{

  private String firstName;
  private String lastName;

  public PersonFluent() {
  }
  
  public PersonFluent(Person instance) {
    this.copyInstance(instance);
  }

  protected void copyInstance(Person instance) {
    if (instance != null) {
        this.withFirstName(instance.getFirstName());
        this.withLastName(instance.getLastName());
    }
  }
  
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }
    if (!(super.equals(o))) {
      return false;
    }
    PersonFluent that = (PersonFluent) o;
    if (!(Objects.equals(firstName, that.firstName))) {
      return false;
    }
    if (!(Objects.equals(lastName, that.lastName))) {
      return false;
    }
    return true;
  }
  
  public String getFirstName() {
    return this.firstName;
  }
  
  public String getLastName() {
    return this.lastName;
  }
  
  public boolean hasFirstName() {
    return this.firstName != null;
  }
  
  public boolean hasLastName() {
    return this.lastName != null;
  }
  
  public int hashCode() {
    return Objects.hash(firstName, lastName);
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (!(firstName == null)) {
        sb.append("firstName:");
        sb.append(firstName);
        sb.append(",");
    }
    if (!(lastName == null)) {
        sb.append("lastName:");
        sb.append(lastName);
    }
    sb.append("}");
    return sb.toString();
  }
  
  public A withFirstName(String firstName) {
    this.firstName = firstName;
    return (A) this;
  }
  
  public A withLastName(String lastName) {
    this.lastName = lastName;
    return (A) this;
  }
  
}