/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.LogFormatter;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SnapshotFormatter;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidSnapshotTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidSnapshotTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final File testData = new File(System.getProperty("test.data.dir", "src/test/resources/data"));

    @Test
    public void testLogFormatter() throws Exception {
        File snapDir = new File(testData, "invalidsnap");
        File logfile = new File(new File(snapDir, "version-2"), "log.274");
        String[] args = new String[]{logfile.getCanonicalFile().toString()};
        LogFormatter.main((String[])args);
    }

    @Test
    public void testSnapshotFormatter() throws Exception {
        File snapDir = new File(testData, "invalidsnap");
        File snapfile = new File(new File(snapDir, "version-2"), "snapshot.272");
        String[] args = new String[]{snapfile.getCanonicalFile().toString()};
        SnapshotFormatter.main((String[])args);
    }

    @Test
    public void testSnapshotFormatterWithNull() throws Exception {
        File snapDir = new File(testData, "invalidsnap");
        File snapfile = new File(new File(snapDir, "version-2"), "snapshot.273");
        String[] args = new String[]{snapfile.getCanonicalFile().toString()};
        SnapshotFormatter.main((String[])args);
    }

    @Test
    public void testSnapshotFormatterWithInvalidSnap() throws Exception {
        File snapDir = new File(testData, "invalidsnap");
        File snapfile = new File(new File(snapDir, "version-2"), "snapshot.83f");
        String[] args = new String[]{snapfile.getCanonicalFile().toString()};
        try {
            SnapshotFormatter.main((String[])args);
            Assert.fail((String)("Snapshot '" + snapfile + "' unexpectedly parsed without error."));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unreasonable length = 977468229"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshot() throws Exception {
        File origSnapDir = new File(testData, "invalidsnap");
        File snapDir = ClientBase.createTmpDir();
        FileUtils.copyDirectory((File)origSnapDir, (File)snapDir);
        ZooKeeperServer zks = new ZooKeeperServer(snapDir, snapDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        LOG.info("starting up the zookeeper server .. waiting");
        Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
            Assert.assertTrue((zk.exists("/9/9/8", false) != null ? 1 : 0) != 0);
        }
        f.shutdown();
        zks.shutdown();
        Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
    }
}

