/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.common.X509KeyType;
import org.apache.zookeeper.common.X509TestContext;
import org.apache.zookeeper.server.ZooKeeperServerMainTest;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.admin.JettyAdminServer;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyAdminServerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(JettyAdminServerTest.class);
    private static final String URL_FORMAT = "http://localhost:%d/commands";
    private static final String HTTPS_URL_FORMAT = "https://localhost:%d/commands";
    private static final int jettyAdminPort = PortAssignment.unique();

    @Before
    public void enableServer() {
        System.setProperty("zookeeper.admin.enableServer", "true");
        System.setProperty("zookeeper.admin.serverPort", "" + jettyAdminPort);
    }

    @Before
    public void setupEncryption() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        File tmpDir = null;
        X509TestContext x509TestContext = null;
        try {
            tmpDir = ClientBase.createEmptyTestDir();
            x509TestContext = X509TestContext.newBuilder().setTempDir(tmpDir).setKeyStorePassword("").setKeyStoreKeyType(X509KeyType.EC).setTrustStorePassword("").setTrustStoreKeyType(X509KeyType.EC).build();
            System.setProperty("zookeeper.ssl.quorum.keyStore.location", x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath());
            System.setProperty("zookeeper.ssl.quorum.trustStore.location", x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath());
        }
        catch (Exception e) {
            LOG.info("Problems encountered while setting up encryption for Jetty admin server test", (Throwable)e);
        }
        System.setProperty("zookeeper.ssl.quorum.keyStore.password", "");
        System.setProperty("zookeeper.ssl.quorum.keyStore.type", "PEM");
        System.setProperty("zookeeper.ssl.quorum.trustStore.password", "");
        System.setProperty("zookeeper.ssl.quorum.trustStore.type", "PEM");
        System.setProperty("zookeeper.admin.portUnification", "true");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (Exception e) {
            LOG.error("Failed to customize encryption for HTTPS", (Throwable)e);
        }
        HostnameVerifier allValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(allValid);
    }

    @After
    public void cleanUp() {
        Security.removeProvider("BC");
        System.clearProperty("zookeeper.admin.enableServer");
        System.clearProperty("zookeeper.admin.serverPort");
        System.clearProperty("zookeeper.ssl.quorum.keyStore.location");
        System.clearProperty("zookeeper.ssl.quorum.keyStore.password");
        System.clearProperty("zookeeper.ssl.quorum.keyStore.type");
        System.clearProperty("zookeeper.ssl.quorum.trustStore.location");
        System.clearProperty("zookeeper.ssl.quorum.trustStore.password");
        System.clearProperty("zookeeper.ssl.quorum.trustStore.type");
        System.clearProperty("zookeeper.admin.portUnification");
        System.clearProperty("zookeeper.admin.forceHttps");
    }

    @Test
    public void testJettyAdminServer() throws AdminServer.AdminServerException, IOException, X509Exception.SSLContextException, GeneralSecurityException {
        JettyAdminServer server = new JettyAdminServer();
        try {
            server.start();
            this.queryAdminServer(jettyAdminPort);
            this.traceAdminServer(jettyAdminPort);
        }
        finally {
            server.shutdown();
        }
    }

    @Test
    public void testStandalone() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        ZooKeeperServerMainTest.MainThread main = new ZooKeeperServerMainTest.MainThread(CLIENT_PORT, false, null);
        main.start();
        Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT));
        this.queryAdminServer(jettyAdminPort);
        main.shutdown();
        Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT));
    }

    @Test
    public void testQuorum() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        int ADMIN_SERVER_PORT1 = PortAssignment.unique();
        int ADMIN_SERVER_PORT2 = PortAssignment.unique();
        String quorumCfgSection = String.format("server.1=127.0.0.1:%d:%d;%d\nserver.2=127.0.0.1:%d:%d;%d", PortAssignment.unique(), PortAssignment.unique(), CLIENT_PORT_QP1, PortAssignment.unique(), PortAssignment.unique(), CLIENT_PORT_QP2);
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, ADMIN_SERVER_PORT1, quorumCfgSection, null);
        q1.start();
        Thread.sleep(500L);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, ADMIN_SERVER_PORT2, quorumCfgSection, null);
        q2.start();
        Thread.sleep(500L);
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        this.queryAdminServer(ADMIN_SERVER_PORT1);
        this.queryAdminServer(ADMIN_SERVER_PORT2);
        q1.shutdown();
        q2.shutdown();
        Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
    }

    @Test
    public void testForceHttpsPortUnificationEnabled() throws Exception {
        this.testForceHttps(true);
    }

    @Test
    public void testForceHttpsPortUnificationDisabled() throws Exception {
        this.testForceHttps(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testForceHttps(boolean portUnification) throws Exception {
        System.setProperty("zookeeper.admin.forceHttps", "true");
        System.setProperty("zookeeper.admin.portUnification", String.valueOf(portUnification));
        boolean httpsPassed = false;
        JettyAdminServer server = new JettyAdminServer();
        try {
            server.start();
            this.queryAdminServer(String.format(HTTPS_URL_FORMAT, jettyAdminPort), true);
            httpsPassed = true;
            this.queryAdminServer(String.format(URL_FORMAT, jettyAdminPort), false);
            Assert.fail((String)"http call should have failed since forceHttps=true");
        }
        catch (SocketException socketException) {
        }
        finally {
            server.shutdown();
        }
        Assert.assertTrue((boolean)httpsPassed);
    }

    private void queryAdminServer(int port) throws IOException, X509Exception.SSLContextException {
        this.queryAdminServer(String.format(URL_FORMAT, port), false);
        this.queryAdminServer(String.format(HTTPS_URL_FORMAT, port), true);
    }

    private void queryAdminServer(String urlStr, boolean encrypted) throws IOException, X509Exception.SSLContextException {
        BufferedReader dis;
        URL url = new URL(urlStr);
        if (!encrypted) {
            dis = new BufferedReader(new InputStreamReader(url.openStream()));
        } else {
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            dis = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        }
        String line = dis.readLine();
        Assert.assertTrue((line.length() > 0 ? 1 : 0) != 0);
    }

    private void traceAdminServer(int port) throws IOException {
        this.traceAdminServer(String.format(URL_FORMAT, port));
        this.traceAdminServer(String.format(HTTPS_URL_FORMAT, port));
    }

    private void traceAdminServer(String urlStr) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(urlStr).openConnection();
        conn.setRequestMethod("TRACE");
        conn.connect();
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }
}

