/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TxnLogCountTest {
    @Test
    public void testTxnLogCount() throws IOException {
        int i;
        File tmpDir = ClientBase.createTmpDir();
        FileTxnSnapLog snapLog = new FileTxnSnapLog(tmpDir, tmpDir);
        ZKDatabase zkDatabase = new ZKDatabase(snapLog);
        int txnRequestCnt = 10;
        int nonTxnRequestCnt = 10;
        for (i = 0; i < txnRequestCnt && zkDatabase.append(this.mockTxnRequest()); ++i) {
        }
        Assert.assertEquals((long)txnRequestCnt, (long)zkDatabase.getTxnCount());
        for (i = 0; i < nonTxnRequestCnt && !zkDatabase.append(this.mockNonTxnRequest()); ++i) {
        }
        Assert.assertEquals((long)txnRequestCnt, (long)zkDatabase.getTxnCount());
    }

    private Request mockTxnRequest() throws IOException {
        TxnHeader header = (TxnHeader)Mockito.mock(TxnHeader.class);
        ((TxnHeader)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("header", "test");
                return null;
            }
        }).when((Object)header)).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), ArgumentMatchers.anyString());
        Request request = new Request(1L, 2, 3, header, null, 4L);
        return request;
    }

    private Request mockNonTxnRequest() {
        Request request = new Request(0L, 0, 0, null, null, 0L);
        return request;
    }
}

