/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.ZooKeeperMain;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.CliException;
import org.apache.zookeeper.cli.CliWrapperException;
import org.apache.zookeeper.cli.LsCommand;
import org.apache.zookeeper.cli.MalformedCommandException;
import org.apache.zookeeper.cli.MalformedPathException;
import org.apache.zookeeper.cli.SyncCommand;
import org.apache.zookeeper.client.ConnectStringParser;
import org.apache.zookeeper.client.HostProvider;
import org.apache.zookeeper.client.StaticHostProvider;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.common.StringUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class ZooKeeperTest
extends ClientBase {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    @Test
    public void testDeleteRecursive() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        this.setupDataTree((ZooKeeper)zk);
        Assert.assertTrue((boolean)ZKUtil.deleteRecursive((ZooKeeper)zk, (String)"/a/c", (int)1000));
        List children = zk.getChildren("/a", false);
        Assert.assertEquals((String)"1 children - c should be deleted ", (long)1L, (long)children.size());
        Assert.assertTrue((boolean)children.contains("b"));
        Assert.assertTrue((boolean)ZKUtil.deleteRecursive((ZooKeeper)zk, (String)"/a", (int)1000));
        Assert.assertNull((Object)zk.exists("/a", null));
    }

    @Test
    public void testDeleteRecursiveFail() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        this.setupDataTree((ZooKeeper)zk);
        ACL deleteProtection = new ACL(8, new Id("digest", "user:tl+z3z0vO6PfPfEENfLF96E6pM0="));
        List<ACL> acls = Arrays.asList(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE), deleteProtection);
        zk.create("/a/c/0/surprise", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((long)1L, (long)zk.getACL("/a/c/0", new Stat()).size());
        zk.setACL("/a/c/0", acls, -1);
        Assert.assertEquals((long)2L, (long)zk.getACL("/a/c/0", new Stat()).size());
        Assert.assertFalse((boolean)ZKUtil.deleteRecursive((ZooKeeper)zk, (String)"/a/c", (int)1000));
        List children = zk.getChildren("/a", false);
        Assert.assertEquals((String)"2 children - c should fail to be deleted ", (long)2L, (long)children.size());
        Assert.assertTrue((boolean)children.contains("b"));
        Assert.assertTrue((boolean)ZKUtil.deleteRecursive((ZooKeeper)zk, (String)"/a/b", (int)1000));
        children = zk.getChildren("/a", false);
        Assert.assertEquals((String)"1 children - b should be deleted ", (long)1L, (long)children.size());
        zk.addAuthInfo(deleteProtection.getId().getScheme(), "user:test".getBytes());
        Assert.assertTrue((boolean)ZKUtil.deleteRecursive((ZooKeeper)zk, (String)"/a", (int)1000));
        Assert.assertNull((Object)zk.exists("/a", null));
    }

    private void setupDataTree(ZooKeeper zk) throws KeeperException, InterruptedException {
        int i;
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (i = 1000; i < 3000; ++i) {
            zk.create("/a/b/v/" + i, "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.create("/a/c", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/c/v", "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (i = 0; i < 500; ++i) {
            zk.create("/a/c/" + i, "some".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        List children = zk.getChildren("/a", false);
        Assert.assertEquals((String)"2 children - b & c should be present ", (long)2L, (long)children.size());
        Assert.assertTrue((boolean)children.contains("b"));
        Assert.assertTrue((boolean)children.contains("c"));
    }

    @Test
    public void testDeleteRecursiveCli() throws IOException, InterruptedException, CliException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v/1", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/c", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/c/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        List children = zk.getChildren("/a", false);
        Assert.assertEquals((String)"2 children - b & c should be present ", (long)children.size(), (long)2L);
        Assert.assertTrue((boolean)children.contains("b"));
        Assert.assertTrue((boolean)children.contains("c"));
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring1 = "deleteall /a";
        zkMain.cl.parseCommand(cmdstring1);
        Assert.assertFalse((boolean)zkMain.processZKCmd(zkMain.cl));
        Assert.assertNull((Object)zk.exists("/a", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursiveAsync() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v/1", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/c", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/c/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int i = 0; i < 50; ++i) {
            zk.create("/a/c/" + i, "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        List children = zk.getChildren("/a", false);
        Assert.assertEquals((String)"2 children - b & c should be present ", (long)children.size(), (long)2L);
        Assert.assertTrue((boolean)children.contains("b"));
        Assert.assertTrue((boolean)children.contains("c"));
        AsyncCallback.VoidCallback cb = new AsyncCallback.VoidCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResult(int rc, String path, Object ctx) {
                Object object = ctx;
                synchronized (object) {
                    ((AtomicInteger)ctx).set(4);
                    ctx.notify();
                }
            }
        };
        AtomicInteger ctx = new AtomicInteger(3);
        ZKUtil.deleteRecursive((ZooKeeper)zk, (String)"/a", (AsyncCallback.VoidCallback)cb, (Object)ctx);
        AtomicInteger atomicInteger = ctx;
        synchronized (atomicInteger) {
            ctx.wait();
        }
        Assert.assertEquals((long)4L, (long)ctx.get());
    }

    @Test
    public void testStatWhenPathDoesNotExist() throws IOException, InterruptedException, MalformedCommandException {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain main = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "stat /invalidPath";
        main.cl.parseCommand(cmdstring);
        try {
            main.processZKCmd(main.cl);
            Assert.fail((String)"As Node does not exist, command should fail by throwing No Node Exception.");
        }
        catch (CliException e) {
            Assert.assertEquals((Object)"Node does not exist: /invalidPath", (Object)e.getMessage());
        }
    }

    @Test
    public void testParseWithExtraSpaces() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "      ls       /  ";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertEquals((String)"Spaces also considered as characters", (long)zkMain.cl.getNumArguments(), (long)2L);
        Assert.assertEquals((String)"ls is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"ls");
        Assert.assertEquals((String)"/ is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/");
    }

    @Test
    public void testParseWithQuotes() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        for (String quoteChar : new String[]{"'", "\""}) {
            String cmdstring = String.format("create /node %1$squoted data%1$s", quoteChar);
            zkMain.cl.parseCommand(cmdstring);
            Assert.assertEquals((String)"quotes combine arguments", (long)zkMain.cl.getNumArguments(), (long)3L);
            Assert.assertEquals((String)"create is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"create");
            Assert.assertEquals((String)"/node is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/node");
            Assert.assertEquals((String)"quoted data is not taken as third argument", (Object)zkMain.cl.getCmdArgument(2), (Object)"quoted data");
        }
    }

    @Test
    public void testParseWithMixedQuotes() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        for (String[] quoteChars : new String[][]{{"'", "\""}, {"\"", "'"}}) {
            String outerQuotes = quoteChars[0];
            String innerQuotes = quoteChars[1];
            String cmdstring = String.format("create /node %1$s%2$squoted data%2$s%1$s", outerQuotes, innerQuotes);
            zkMain.cl.parseCommand(cmdstring);
            Assert.assertEquals((String)"quotes combine arguments", (long)zkMain.cl.getNumArguments(), (long)3L);
            Assert.assertEquals((String)"create is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"create");
            Assert.assertEquals((String)"/node is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/node");
            Assert.assertEquals((String)"quoted data is not taken as third argument", (Object)zkMain.cl.getCmdArgument(2), (Object)(innerQuotes + "quoted data" + innerQuotes));
        }
    }

    @Test
    public void testParseWithEmptyQuotes() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create /node ''";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertEquals((String)"empty quotes should produce arguments", (long)zkMain.cl.getNumArguments(), (long)3L);
        Assert.assertEquals((String)"create is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"create");
        Assert.assertEquals((String)"/node is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/node");
        Assert.assertEquals((String)"empty string is not taken as third argument", (Object)zkMain.cl.getCmdArgument(2), (Object)"");
    }

    @Test
    public void testParseWithMultipleQuotes() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create /node '' ''";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertEquals((String)"expected 5 arguments", (long)zkMain.cl.getNumArguments(), (long)4L);
        Assert.assertEquals((String)"create is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"create");
        Assert.assertEquals((String)"/node is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/node");
        Assert.assertEquals((String)"empty string is not taken as third argument", (Object)zkMain.cl.getCmdArgument(2), (Object)"");
        Assert.assertEquals((String)"empty string is not taken as fourth argument", (Object)zkMain.cl.getCmdArgument(3), (Object)"");
    }

    @Test
    public void testNonexistantCommand() throws Exception {
        this.testInvalidCommand("cret -s /node1", 127);
    }

    @Test
    public void testCreateCommandWithoutPath() throws Exception {
        this.testInvalidCommand("create", 1);
    }

    @Test
    public void testCreateEphemeralCommandWithoutPath() throws Exception {
        this.testInvalidCommand("create -e ", 1);
    }

    @Test
    public void testCreateSequentialCommandWithoutPath() throws Exception {
        this.testInvalidCommand("create -s ", 1);
    }

    @Test
    public void testCreateEphemeralSequentialCommandWithoutPath() throws Exception {
        this.testInvalidCommand("create -s -e ", 1);
    }

    private void testInvalidCommand(String cmdString, int exitCode) throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        zkMain.cl.parseCommand(cmdString);
        zkMain.processCmd(zkMain.cl);
        Assert.assertEquals((long)exitCode, (long)zkMain.exitCode);
        try {
            zkMain.processZKCmd(zkMain.cl);
            Assert.fail();
        }
        catch (CliException e) {
            return;
        }
        Assert.fail((String)"invalid command should throw CliException");
    }

    @Test
    public void testCreateNodeWithoutData() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create -s /node ";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Doesn't create node without data", (boolean)zkMain.processZKCmd(zkMain.cl));
        cmdstring = "create  -e /node ";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Doesn't create node without data", (boolean)zkMain.processZKCmd(zkMain.cl));
        cmdstring = "create -s -e /node ";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Doesn't create node without data", (boolean)zkMain.processZKCmd(zkMain.cl));
        cmdstring = "create -s y /node";
        zkMain.cl.parseCommand(cmdstring);
        try {
            Assert.assertTrue((String)"Created node with wrong option", (boolean)zkMain.processZKCmd(zkMain.cl));
            Assert.fail((String)"Created the node with wrong option should throw Exception.");
        }
        catch (MalformedPathException e) {
            Assert.assertEquals((Object)"Path must start with / character", (Object)e.getMessage());
        }
    }

    @Test
    public void testACLWithExtraAgruments() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create -s /l data ip:10.18.52.144:cdrwa f g h";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Not considering the extra arguments after the acls.", (boolean)zkMain.processZKCmd(zkMain.cl));
    }

    @Test
    public void testCreatePersistentNode() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create /node2";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Not creating Persistent node.", (boolean)zkMain.processZKCmd(zkMain.cl));
    }

    @Test
    public void testDelete() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring1 = "create -e /node2 data";
        String cmdstring2 = "delete /node2";
        String cmdstring3 = "ls /node2";
        zkMain.cl.parseCommand(cmdstring1);
        Assert.assertTrue((boolean)zkMain.processZKCmd(zkMain.cl));
        zkMain.cl.parseCommand(cmdstring2);
        Assert.assertFalse((boolean)zkMain.processZKCmd(zkMain.cl));
        zkMain.cl.parseCommand(cmdstring3);
        Assert.assertFalse((String)"", (boolean)zkMain.processCmd(zkMain.cl));
    }

    @Test
    public void testDeleteNonexistantNode() throws Exception {
        this.testInvalidCommand("delete /blahblahblah", 1);
    }

    @Test
    public void testStatCommand() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring1 = "create -e /node3 data";
        String cmdstring2 = "stat /node3";
        String cmdstring3 = "delete /node3";
        zkMain.cl.parseCommand(cmdstring1);
        Assert.assertTrue((boolean)zkMain.processZKCmd(zkMain.cl));
        zkMain.cl.parseCommand(cmdstring2);
        Assert.assertFalse((boolean)zkMain.processZKCmd(zkMain.cl));
        zkMain.cl.parseCommand(cmdstring3);
        Assert.assertFalse((boolean)zkMain.processZKCmd(zkMain.cl));
    }

    @Test
    public void testInvalidStatCommand() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring1 = "stat /node123";
        zkMain.cl.parseCommand(cmdstring1);
        try {
            Assert.assertFalse((boolean)zkMain.processZKCmd(zkMain.cl));
            Assert.fail((String)"Path doesn't exists so, command should fail.");
        }
        catch (CliWrapperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((KeeperException)e.getCause()).code());
        }
    }

    @Test
    public void testSetData() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring1 = "create -e /node4 data";
        String cmdstring2 = "set /node4 data";
        String cmdstring3 = "delete /node4";
        Stat stat = new Stat();
        int version = 0;
        zkMain.cl.parseCommand(cmdstring1);
        Assert.assertTrue((boolean)zkMain.processZKCmd(zkMain.cl));
        stat = zk.exists("/node4", true);
        version = stat.getVersion();
        zkMain.cl.parseCommand(cmdstring2);
        Assert.assertFalse((boolean)zkMain.processZKCmd(zkMain.cl));
        stat = zk.exists("/node4", true);
        Assert.assertEquals((long)(version + 1), (long)stat.getVersion());
        zkMain.cl.parseCommand(cmdstring3);
        Assert.assertFalse((boolean)zkMain.processZKCmd(zkMain.cl));
    }

    @Test
    public void testCheckInvalidAcls() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create -s -e /node data ip:scheme:gggsd";
        zkMain.executeLine(cmdstring);
    }

    @Test
    public void testDeleteWithInvalidVersionNo() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create -s -e /node1 data ";
        String cmdstring1 = "delete /node1 2";
        zkMain.executeLine(cmdstring);
        zkMain.executeLine(cmdstring1);
    }

    @Test
    public void testCliCommandsNotEchoingUsage() throws Exception {
        PrintStream systemErr = System.err;
        ByteArrayOutputStream errContent = new ByteArrayOutputStream();
        System.setErr(new PrintStream(errContent));
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmd1 = "printwatches";
        zkMain.executeLine(cmd1);
        String cmd2 = "history";
        zkMain.executeLine(cmd2);
        String cmd3 = "redo";
        zkMain.executeLine(cmd3);
        System.setErr(systemErr);
        if (errContent.toString().contains("ZooKeeper -server host:port cmd args")) {
            Assert.fail((String)"CLI commands (history, redo, connect, printwatches) display usage info!");
        }
    }

    @Test
    public void testRedoWithNegativeCmdNumber() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmd1 = "redo -1";
        String result = this.executeLine(zkMain, cmd1);
        Assert.assertEquals((Object)"Command index out of range", (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeLine(ZooKeeperMain zkMain, String cmd) throws InterruptedException, IOException {
        PrintStream systemErr = System.err;
        ByteArrayOutputStream errContent = new ByteArrayOutputStream();
        System.setErr(new PrintStream(errContent));
        try {
            zkMain.executeLine(cmd);
            String string = errContent.toString().trim();
            return string;
        }
        finally {
            System.setErr(systemErr);
        }
    }

    private static void runCommandExpect(CliCommand command, List<String> expectedResults) throws Exception {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(byteStream);
        command.setOut(out);
        command.exec();
        String result = byteStream.toString();
        Assert.assertTrue((String)result, (boolean)result.contains(StringUtils.joinStrings(expectedResults, (String)LINE_SEPARATOR)));
    }

    @Test
    public void testSortedLs() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        zkMain.executeLine("create /aa1");
        zkMain.executeLine("create /aa2");
        zkMain.executeLine("create /aa3");
        zkMain.executeLine("create /test1");
        zkMain.executeLine("create /zk1");
        LsCommand cmd = new LsCommand();
        cmd.setZk((ZooKeeper)zk);
        cmd.parse("ls /".split(" "));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("[aa1, aa2, aa3, test1, zk1, zookeeper]");
        ZooKeeperTest.runCommandExpect((CliCommand)cmd, expected);
    }

    @Test
    public void testLsrCommand() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        zkMain.executeLine("create /a");
        zkMain.executeLine("create /a/b");
        zkMain.executeLine("create /a/c");
        zkMain.executeLine("create /a/b/d");
        zkMain.executeLine("create /a/c/e");
        zkMain.executeLine("create /a/f");
        LsCommand cmd = new LsCommand();
        cmd.setZk((ZooKeeper)zk);
        cmd.parse("ls -R /a".split(" "));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("/a");
        expected.add("/a/b");
        expected.add("/a/c");
        expected.add("/a/f");
        expected.add("/a/b/d");
        expected.add("/a/c/e");
        ZooKeeperTest.runCommandExpect((CliCommand)cmd, expected);
    }

    @Test
    public void testLsrRootCommand() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        LsCommand cmd = new LsCommand();
        cmd.setZk((ZooKeeper)zk);
        cmd.parse("ls -R /".split(" "));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("/");
        expected.add("/zookeeper");
        ZooKeeperTest.runCommandExpect((CliCommand)cmd, expected);
    }

    @Test
    public void testLsrLeafCommand() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        zkMain.executeLine("create /b");
        zkMain.executeLine("create /b/c");
        LsCommand cmd = new LsCommand();
        cmd.setZk((ZooKeeper)zk);
        cmd.parse("ls -R /b/c".split(" "));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("/b/c");
        ZooKeeperTest.runCommandExpect((CliCommand)cmd, expected);
    }

    @Test
    public void testLsrNonexistantZnodeCommand() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        zkMain.executeLine("create /b");
        zkMain.executeLine("create /b/c");
        LsCommand cmd = new LsCommand();
        cmd.setZk((ZooKeeper)zk);
        cmd.parse("ls -R /b/c/d".split(" "));
        try {
            ZooKeeperTest.runCommandExpect((CliCommand)cmd, new ArrayList<String>());
            Assert.fail((String)"Path doesn't exists so, command should fail.");
        }
        catch (CliWrapperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((KeeperException)e.getCause()).code());
        }
    }

    @Test
    public void testSetAclRecursive() throws Exception {
        TestableZooKeeper zk = this.createClient();
        byte[] EMPTY = new byte[]{};
        zk.setData("/", EMPTY, -1);
        zk.create("/a", EMPTY, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", EMPTY, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/c", EMPTY, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/d", EMPTY, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/e", EMPTY, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String setAclCommand = "setAcl -R /a world:anyone:r";
        zkMain.cl.parseCommand(setAclCommand);
        Assert.assertFalse((boolean)zkMain.processZKCmd(zkMain.cl));
        Assert.assertEquals((Object)ZooDefs.Ids.READ_ACL_UNSAFE, (Object)zk.getACL("/a", new Stat()));
        Assert.assertEquals((Object)ZooDefs.Ids.READ_ACL_UNSAFE, (Object)zk.getACL("/a/b", new Stat()));
        Assert.assertEquals((Object)ZooDefs.Ids.READ_ACL_UNSAFE, (Object)zk.getACL("/a/b/c", new Stat()));
        Assert.assertEquals((Object)ZooDefs.Ids.READ_ACL_UNSAFE, (Object)zk.getACL("/a/d", new Stat()));
        Assert.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)zk.getACL("/e", new Stat()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientReconnectWithZKClientConfig() throws Exception {
        TestableZooKeeper zk = null;
        ZooKeeper newZKClient = null;
        try {
            zk = this.createClient();
            ZKClientConfig clientConfig = new ZKClientConfig();
            clientConfig.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
            ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
            StaticHostProvider aHostProvider = new StaticHostProvider((Collection)new ConnectStringParser(this.hostPort).getServerAddresses());
            newZKClient = new ZooKeeper(this.hostPort, zk.getSessionTimeout(), (Watcher)watcher, zk.getSessionId(), zk.getSessionPasswd(), false, (HostProvider)aHostProvider, clientConfig);
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            Assert.assertEquals((String)"Old client session id and new clinet session id must be same", (long)zk.getSessionId(), (long)newZKClient.getSessionId());
        }
        finally {
            zk.close();
            newZKClient.close();
        }
    }

    @Test
    public void testSyncCommand() throws Exception {
        TestableZooKeeper zk = this.createClient();
        SyncCommand cmd = new SyncCommand();
        cmd.setZk((ZooKeeper)zk);
        cmd.parse("sync /".split(" "));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Sync is OK");
        ZooKeeperTest.runCommandExpect((CliCommand)cmd, expected);
    }

    @Test
    public void testInsufficientPermission() throws Exception {
        TestableZooKeeper zk = this.createClient();
        zk.create("/permZNode", "".getBytes(), ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.PERSISTENT);
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String zNodeToBeCreated = "/permZNode/child1";
        String errorMessage = this.executeLine(zkMain, "create " + zNodeToBeCreated);
        Assert.assertEquals((Object)("Insufficient permission : " + zNodeToBeCreated), (Object)errorMessage);
        List<ACL> writeAcl = Arrays.asList(new ACL(2, ZooDefs.Ids.ANYONE_ID_UNSAFE));
        String noReadPermZNodePath = "/noReadPermZNode";
        zk.create(noReadPermZNodePath, "newData".getBytes(), writeAcl, CreateMode.PERSISTENT);
        errorMessage = this.executeLine(zkMain, "get " + noReadPermZNodePath);
        Assert.assertEquals((Object)("Insufficient permission : " + noReadPermZNodePath), (Object)errorMessage);
    }

    @Test
    public void testWaitForConnection() throws Exception {
        int invalidPort = PortAssignment.unique();
        long timeout = 3000L;
        String[] args1 = new String[]{"-server", "localhost:" + invalidPort, "-timeout", Long.toString(timeout), "-waitforconnection", "ls", "/"};
        long startTime = System.currentTimeMillis();
        try {
            ZooKeeperMain zkMain = new ZooKeeperMain(args1);
            Assert.fail((String)"IOException was expected");
        }
        catch (IOException zkMain) {
            // empty catch block
        }
        long endTime = System.currentTimeMillis();
        Assert.assertTrue((String)"ZooKeeperMain does not wait until the specified timeout", (endTime - startTime >= timeout ? 1 : 0) != 0);
    }
}

