/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.recipes.leader;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.recipes.leader.LeaderElectionAware;
import org.apache.zookeeper.recipes.leader.LeaderElectionSupport;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectionSupportTest
extends ClientBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderElectionSupportTest.class);
    private static final String TEST_ROOT_NODE = "/" + System.currentTimeMillis() + "_";
    private ZooKeeper zooKeeper;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.zooKeeper = this.createClient();
        this.zooKeeper.create(TEST_ROOT_NODE + Thread.currentThread().getId(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    @After
    public void tearDown() throws Exception {
        if (this.zooKeeper != null) {
            this.zooKeeper.delete(TEST_ROOT_NODE + Thread.currentThread().getId(), -1);
        }
        super.tearDown();
    }

    @Test
    public void testNode() throws Exception {
        LeaderElectionSupport electionSupport = this.createLeaderElectionSupport();
        electionSupport.start();
        Thread.sleep(3000L);
        electionSupport.stop();
    }

    @Test
    public void testNodes3() throws Exception {
        int testIterations = 3;
        CountDownLatch latch = new CountDownLatch(testIterations);
        AtomicInteger failureCounter = new AtomicInteger();
        for (int i = 0; i < testIterations; ++i) {
            this.runElectionSupportThread(latch, failureCounter);
        }
        Assert.assertEquals((long)0L, (long)failureCounter.get());
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            LOGGER.info("Waited for all threads to start, but timed out. We had {} failures.", (Object)failureCounter);
        }
    }

    @Test
    public void testNodes9() throws Exception {
        int testIterations = 9;
        CountDownLatch latch = new CountDownLatch(testIterations);
        AtomicInteger failureCounter = new AtomicInteger();
        for (int i = 0; i < testIterations; ++i) {
            this.runElectionSupportThread(latch, failureCounter);
        }
        Assert.assertEquals((long)0L, (long)failureCounter.get());
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            LOGGER.info("Waited for all threads to start, but timed out. We had {} failures.", (Object)failureCounter);
        }
    }

    @Test
    public void testNodes20() throws Exception {
        int testIterations = 20;
        CountDownLatch latch = new CountDownLatch(testIterations);
        AtomicInteger failureCounter = new AtomicInteger();
        for (int i = 0; i < testIterations; ++i) {
            this.runElectionSupportThread(latch, failureCounter);
        }
        Assert.assertEquals((long)0L, (long)failureCounter.get());
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            LOGGER.info("Waited for all threads to start, but timed out. We had {} failures.", (Object)failureCounter);
        }
    }

    @Test
    public void testNodes100() throws Exception {
        int testIterations = 100;
        CountDownLatch latch = new CountDownLatch(testIterations);
        AtomicInteger failureCounter = new AtomicInteger();
        for (int i = 0; i < testIterations; ++i) {
            this.runElectionSupportThread(latch, failureCounter);
        }
        Assert.assertEquals((long)0L, (long)failureCounter.get());
        if (!latch.await(20L, TimeUnit.SECONDS)) {
            LOGGER.info("Waited for all threads to start, but timed out. We had {} failures.", (Object)failureCounter);
        }
    }

    @Test
    public void testOfferShuffle() throws InterruptedException {
        int testIterations = 10;
        CountDownLatch latch = new CountDownLatch(testIterations);
        AtomicInteger failureCounter = new AtomicInteger();
        ArrayList<Thread> threads = new ArrayList<Thread>(testIterations);
        for (int i = 1; i <= testIterations; ++i) {
            threads.add(this.runElectionSupportThread(latch, failureCounter, Math.min(i * 1200, 10000)));
        }
        if (!latch.await(60L, TimeUnit.SECONDS)) {
            LOGGER.info("Waited for all threads to start, but timed out. We had {} failures.", (Object)failureCounter);
        }
    }

    @Test
    public void testGetLeaderHostName() throws Exception {
        LeaderElectionSupport electionSupport = this.createLeaderElectionSupport();
        electionSupport.start();
        Thread.sleep(3000L);
        String leaderHostName = electionSupport.getLeaderHostName();
        Assert.assertNotNull((Object)leaderHostName);
        Assert.assertEquals((Object)"foohost", (Object)leaderHostName);
        electionSupport.stop();
    }

    @Test
    public void testReadyOffer() throws Exception {
        final ArrayList events = new ArrayList();
        final CountDownLatch electedComplete = new CountDownLatch(1);
        final LeaderElectionSupport electionSupport1 = this.createLeaderElectionSupport();
        electionSupport1.start();
        LeaderElectionSupport electionSupport2 = this.createLeaderElectionSupport();
        LeaderElectionAware listener = new LeaderElectionAware(){
            boolean stoppedElectedNode = false;

            public void onElectionEvent(LeaderElectionSupport.EventType eventType) {
                events.add(eventType);
                if (!this.stoppedElectedNode && eventType == LeaderElectionSupport.EventType.DETERMINE_COMPLETE) {
                    this.stoppedElectedNode = true;
                    try {
                        electionSupport1.stop();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected exception", (Throwable)e);
                    }
                }
                if (eventType == LeaderElectionSupport.EventType.ELECTED_COMPLETE) {
                    electedComplete.countDown();
                }
            }
        };
        electionSupport2.addListener(listener);
        electionSupport2.start();
        electedComplete.await(CONNECTION_TIMEOUT / 3, TimeUnit.MILLISECONDS);
        ArrayList<LeaderElectionSupport.EventType> expectedevents = new ArrayList<LeaderElectionSupport.EventType>();
        expectedevents.add(LeaderElectionSupport.EventType.START);
        expectedevents.add(LeaderElectionSupport.EventType.OFFER_START);
        expectedevents.add(LeaderElectionSupport.EventType.OFFER_COMPLETE);
        expectedevents.add(LeaderElectionSupport.EventType.DETERMINE_START);
        expectedevents.add(LeaderElectionSupport.EventType.DETERMINE_COMPLETE);
        expectedevents.add(LeaderElectionSupport.EventType.DETERMINE_START);
        expectedevents.add(LeaderElectionSupport.EventType.DETERMINE_COMPLETE);
        expectedevents.add(LeaderElectionSupport.EventType.ELECTED_START);
        expectedevents.add(LeaderElectionSupport.EventType.ELECTED_COMPLETE);
        Assert.assertEquals((String)"Events has failed to executed in the order", expectedevents, events);
        electionSupport2.stop();
    }

    private LeaderElectionSupport createLeaderElectionSupport() {
        LeaderElectionSupport electionSupport = new LeaderElectionSupport();
        electionSupport.setZooKeeper(this.zooKeeper);
        electionSupport.setRootNodeName(TEST_ROOT_NODE + Thread.currentThread().getId());
        electionSupport.setHostName("foohost");
        return electionSupport;
    }

    private Thread runElectionSupportThread(CountDownLatch latch, AtomicInteger failureCounter) {
        return this.runElectionSupportThread(latch, failureCounter, 3000L);
    }

    private Thread runElectionSupportThread(CountDownLatch latch, AtomicInteger failureCounter, long sleepDuration) {
        LeaderElectionSupport electionSupport = this.createLeaderElectionSupport();
        Thread t = new Thread(() -> {
            try {
                electionSupport.start();
                Thread.sleep(sleepDuration);
                electionSupport.stop();
                latch.countDown();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to run leader election.", (Throwable)e);
                failureCounter.incrementAndGet();
            }
        });
        t.start();
        return t;
    }
}

