/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.util.Recycler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.mledger.offload.OffloadUtils;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlock;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexEntry;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.OffloadIndexEntryImpl;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffloadIndexBlockImpl
implements OffloadIndexBlock {
    private static final Logger log = LoggerFactory.getLogger(OffloadIndexBlockImpl.class);
    private static final int INDEX_MAGIC_WORD = -565715385;
    private LedgerMetadata segmentMetadata;
    private long dataObjectLength;
    private long dataHeaderLength;
    private TreeMap<Long, OffloadIndexEntryImpl> indexEntries;
    private final Recycler.Handle<OffloadIndexBlockImpl> recyclerHandle;
    private static final Recycler<OffloadIndexBlockImpl> RECYCLER = new Recycler<OffloadIndexBlockImpl>(){

        protected OffloadIndexBlockImpl newObject(Recycler.Handle<OffloadIndexBlockImpl> handle) {
            return new OffloadIndexBlockImpl(handle);
        }
    };

    private OffloadIndexBlockImpl(Recycler.Handle<OffloadIndexBlockImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public static OffloadIndexBlockImpl get(LedgerMetadata metadata, long dataObjectLength, long dataHeaderLength, List<OffloadIndexEntryImpl> entries) {
        OffloadIndexBlockImpl block = (OffloadIndexBlockImpl)RECYCLER.get();
        block.indexEntries = Maps.newTreeMap();
        entries.forEach(entry -> block.indexEntries.putIfAbsent(entry.getEntryId(), (OffloadIndexEntryImpl)entry));
        Preconditions.checkState((entries.size() == block.indexEntries.size() ? 1 : 0) != 0);
        block.segmentMetadata = metadata;
        block.dataObjectLength = dataObjectLength;
        block.dataHeaderLength = dataHeaderLength;
        return block;
    }

    public static OffloadIndexBlockImpl get(int magic, DataInputStream stream) throws IOException {
        if (magic != -565715385) {
            throw new IOException(String.format("Invalid MagicWord. read: 0x%x  expected: 0x%x", magic, -565715385));
        }
        OffloadIndexBlockImpl block = (OffloadIndexBlockImpl)RECYCLER.get();
        block.indexEntries = Maps.newTreeMap();
        block.fromStream(stream);
        return block;
    }

    public void recycle() {
        this.dataObjectLength = -1L;
        this.dataHeaderLength = -1L;
        this.segmentMetadata = null;
        this.indexEntries.clear();
        this.indexEntries = null;
        if (this.recyclerHandle != null) {
            this.recyclerHandle.recycle((Object)this);
        }
    }

    @Override
    public OffloadIndexEntry getIndexEntryForEntry(long messageEntryId) throws IOException {
        if (messageEntryId > this.segmentMetadata.getLastEntryId()) {
            log.warn("Try to get entry: {}, which beyond lastEntryId {}, return null", (Object)messageEntryId, (Object)this.segmentMetadata.getLastEntryId());
            throw new IndexOutOfBoundsException("Entry index: " + messageEntryId + " beyond lastEntryId: " + this.segmentMetadata.getLastEntryId());
        }
        return this.indexEntries.floorEntry(messageEntryId).getValue();
    }

    @Override
    public int getEntryCount() {
        return this.indexEntries.size();
    }

    @Override
    public LedgerMetadata getLedgerMetadata() {
        return this.segmentMetadata;
    }

    @Override
    public long getDataObjectLength() {
        return this.dataObjectLength;
    }

    @Override
    public long getDataBlockHeaderLength() {
        return this.dataHeaderLength;
    }

    @Override
    public OffloadIndexBlock.IndexInputStream toStream() throws IOException {
        int indexEntryCount = this.indexEntries.size();
        byte[] ledgerMetadataByte = OffloadUtils.buildLedgerMetadataFormat((LedgerMetadata)this.segmentMetadata);
        int segmentMetadataLength = ledgerMetadataByte.length;
        int indexBlockLength = 32 + segmentMetadataLength + indexEntryCount * 20;
        ByteBuf out = PulsarByteBufAllocator.DEFAULT.buffer(indexBlockLength, indexBlockLength);
        out.writeInt(-565715385).writeInt(indexBlockLength).writeLong(this.dataObjectLength).writeLong(this.dataHeaderLength).writeInt(indexEntryCount).writeInt(segmentMetadataLength);
        out.writeBytes(ledgerMetadataByte);
        this.indexEntries.entrySet().forEach(entry -> out.writeLong(((OffloadIndexEntryImpl)entry.getValue()).getEntryId()).writeInt(((OffloadIndexEntryImpl)entry.getValue()).getPartId()).writeLong(((OffloadIndexEntryImpl)entry.getValue()).getOffset()));
        return new OffloadIndexBlock.IndexInputStream((InputStream)new ByteBufInputStream(out, true), indexBlockLength);
    }

    private static LedgerMetadata parseLedgerMetadata(byte[] bytes) throws IOException {
        DataFormats.LedgerMetadataFormat.Builder builder = DataFormats.LedgerMetadataFormat.newBuilder();
        builder.mergeFrom(bytes);
        return new InternalLedgerMetadata(builder.build());
    }

    private OffloadIndexBlock fromStream(DataInputStream dis) throws IOException {
        dis.readInt();
        this.dataObjectLength = dis.readLong();
        this.dataHeaderLength = dis.readLong();
        int indexEntryCount = dis.readInt();
        int segmentMetadataLength = dis.readInt();
        byte[] metadataBytes = new byte[segmentMetadataLength];
        if (segmentMetadataLength != dis.read(metadataBytes)) {
            log.error("Read ledgerMetadata from bytes failed");
            throw new IOException("Read ledgerMetadata from bytes failed");
        }
        this.segmentMetadata = OffloadIndexBlockImpl.parseLedgerMetadata(metadataBytes);
        for (int i = 0; i < indexEntryCount; ++i) {
            long entryId = dis.readLong();
            this.indexEntries.putIfAbsent(entryId, OffloadIndexEntryImpl.of(entryId, dis.readInt(), dis.readLong(), this.dataHeaderLength));
        }
        return this;
    }

    public static int getIndexMagicWord() {
        return -565715385;
    }

    @Override
    public void close() {
        this.recycle();
    }

    private static class InternalLedgerMetadata
    implements LedgerMetadata {
        private int ensembleSize;
        private int writeQuorumSize;
        private int ackQuorumSize;
        private long lastEntryId;
        private long length;
        private DataFormats.LedgerMetadataFormat.DigestType digestType;
        private long ctime;
        private LedgerMetadata.State state;
        private Map<String, byte[]> customMetadata = Maps.newHashMap();
        private TreeMap<Long, ArrayList<BookieId>> ensembles = new TreeMap();

        InternalLedgerMetadata(DataFormats.LedgerMetadataFormat ledgerMetadataFormat) {
            this.ensembleSize = ledgerMetadataFormat.getEnsembleSize();
            this.writeQuorumSize = ledgerMetadataFormat.getQuorumSize();
            this.ackQuorumSize = ledgerMetadataFormat.getAckQuorumSize();
            this.lastEntryId = ledgerMetadataFormat.getLastEntryId();
            this.length = ledgerMetadataFormat.getLength();
            this.digestType = ledgerMetadataFormat.getDigestType();
            this.ctime = ledgerMetadataFormat.getCtime();
            this.state = LedgerMetadata.State.valueOf((String)ledgerMetadataFormat.getState().toString());
            if (ledgerMetadataFormat.getCustomMetadataCount() > 0) {
                ledgerMetadataFormat.getCustomMetadataList().forEach(entry -> this.customMetadata.put(entry.getKey(), entry.getValue().toByteArray()));
            }
            ledgerMetadataFormat.getSegmentList().forEach(segment -> {
                ArrayList addressArrayList = new ArrayList();
                segment.getEnsembleMemberList().forEach(address -> {
                    try {
                        addressArrayList.add(BookieId.parse((String)address));
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Exception when create BookieSocketAddress. ", (Throwable)e);
                    }
                });
                this.ensembles.put(segment.getFirstEntryId(), addressArrayList);
            });
        }

        public long getLedgerId() {
            throw new UnsupportedOperationException();
        }

        public int getEnsembleSize() {
            return this.ensembleSize;
        }

        public int getWriteQuorumSize() {
            return this.writeQuorumSize;
        }

        public int getAckQuorumSize() {
            return this.ackQuorumSize;
        }

        public long getLastEntryId() {
            return this.lastEntryId;
        }

        public long getLength() {
            return this.length;
        }

        public DigestType getDigestType() {
            switch (this.digestType) {
                case HMAC: {
                    return DigestType.MAC;
                }
                case CRC32: {
                    return DigestType.CRC32;
                }
                case CRC32C: {
                    return DigestType.CRC32C;
                }
                case DUMMY: {
                    return DigestType.DUMMY;
                }
            }
            throw new IllegalArgumentException("Unable to convert digest type " + this.digestType);
        }

        public long getCtime() {
            return this.ctime;
        }

        public boolean isClosed() {
            return this.state == LedgerMetadata.State.CLOSED;
        }

        public Map<String, byte[]> getCustomMetadata() {
            return this.customMetadata;
        }

        public List<BookieId> getEnsembleAt(long entryId) {
            return this.ensembles.get(this.ensembles.headMap(entryId + 1L).lastKey());
        }

        public NavigableMap<Long, ? extends List<BookieId>> getAllEnsembles() {
            return this.ensembles;
        }

        public long getCToken() {
            return 0L;
        }

        public int getMetadataFormatVersion() {
            return 0;
        }

        public byte[] getPassword() {
            return null;
        }

        public LedgerMetadata.State getState() {
            return this.state;
        }

        public boolean hasPassword() {
            return false;
        }

        public String toSafeString() {
            return null;
        }
    }
}

