/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlockV2;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexEntry;

@InterfaceStability.Unstable
public interface OffloadIndexBlock
extends Closeable,
OffloadIndexBlockV2 {
    @Override
    public IndexInputStream toStream() throws IOException;

    public OffloadIndexEntry getIndexEntryForEntry(long var1) throws IOException;

    @Override
    public int getEntryCount();

    public LedgerMetadata getLedgerMetadata();

    @Override
    public long getDataObjectLength();

    @Override
    public long getDataBlockHeaderLength();

    @Override
    default public OffloadIndexEntry getIndexEntryForEntry(long ledgerId, long messageEntryId) throws IOException {
        return this.getIndexEntryForEntry(messageEntryId);
    }

    @Override
    default public long getStartEntryId(long ledgerId) {
        return 0L;
    }

    @Override
    default public LedgerMetadata getLedgerMetadata(long ledgerId) {
        return this.getLedgerMetadata();
    }

    public static class IndexInputStream
    extends FilterInputStream {
        final long streamSize;

        public IndexInputStream(InputStream in, long streamSize) {
            super(in);
            this.streamSize = streamSize;
        }

        public long getStreamSize() {
            return this.streamSize;
        }
    }
}

