/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.impl;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.impl.LedgerEntriesImpl;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.mledger.offload.jcloud.BackedInputStream;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlock;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlockBuilder;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.BlobStoreBackedInputStreamImpl;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.DataBlockUtils;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreBackedReadHandleImpl
implements ReadHandle {
    private static final Logger log = LoggerFactory.getLogger(BlobStoreBackedReadHandleImpl.class);
    private final long ledgerId;
    private final OffloadIndexBlock index;
    private final BackedInputStream inputStream;
    private final DataInputStream dataStream;
    private final ExecutorService executor;

    private BlobStoreBackedReadHandleImpl(long ledgerId, OffloadIndexBlock index, BackedInputStream inputStream, ExecutorService executor) {
        this.ledgerId = ledgerId;
        this.index = index;
        this.inputStream = inputStream;
        this.dataStream = new DataInputStream(inputStream);
        this.executor = executor;
    }

    public long getId() {
        return this.ledgerId;
    }

    public LedgerMetadata getLedgerMetadata() {
        return this.index.getLedgerMetadata();
    }

    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            try {
                this.index.close();
                this.inputStream.close();
                promise.complete(null);
            }
            catch (IOException t) {
                promise.completeExceptionally(t);
            }
        });
        return promise;
    }

    public CompletableFuture<LedgerEntries> readAsync(long firstEntry, long lastEntry) {
        log.debug("Ledger {}: reading {} - {}", new Object[]{this.getId(), firstEntry, lastEntry});
        CompletableFuture<LedgerEntries> promise = new CompletableFuture<LedgerEntries>();
        this.executor.submit(() -> {
            if (firstEntry > lastEntry || firstEntry < 0L || lastEntry > this.getLastAddConfirmed()) {
                promise.completeExceptionally((Throwable)new BKException.BKIncorrectParameterException());
                return;
            }
            long entriesToRead = lastEntry - firstEntry + 1L;
            ArrayList<LedgerEntryImpl> entries = new ArrayList<LedgerEntryImpl>();
            long nextExpectedId = firstEntry;
            try {
                while (entriesToRead > 0L) {
                    int length = this.dataStream.readInt();
                    if (length < 0) {
                        this.inputStream.seek(this.index.getIndexEntryForEntry(nextExpectedId).getDataOffset());
                        continue;
                    }
                    long entryId = this.dataStream.readLong();
                    if (entryId == nextExpectedId) {
                        ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(length, length);
                        entries.add(LedgerEntryImpl.create((long)this.ledgerId, (long)entryId, (long)length, (ByteBuf)buf));
                        for (int toWrite = length; toWrite > 0; toWrite -= buf.writeBytes((InputStream)this.dataStream, toWrite)) {
                        }
                        --entriesToRead;
                        ++nextExpectedId;
                        continue;
                    }
                    if (entryId > nextExpectedId) {
                        this.inputStream.seek(this.index.getIndexEntryForEntry(nextExpectedId).getDataOffset());
                        continue;
                    }
                    if (entryId < nextExpectedId && !this.index.getIndexEntryForEntry(nextExpectedId).equals(this.index.getIndexEntryForEntry(entryId))) {
                        this.inputStream.seek(this.index.getIndexEntryForEntry(nextExpectedId).getDataOffset());
                        continue;
                    }
                    if (entryId > lastEntry) {
                        log.info("Expected to read {}, but read {}, which is greater than last entry {}", new Object[]{nextExpectedId, entryId, lastEntry});
                        throw new BKException.BKUnexpectedConditionException();
                    }
                    this.inputStream.skip(length);
                }
                promise.complete((LedgerEntries)LedgerEntriesImpl.create(entries));
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
                entries.forEach(LedgerEntry::close);
            }
        });
        return promise;
    }

    public CompletableFuture<LedgerEntries> readUnconfirmedAsync(long firstEntry, long lastEntry) {
        return this.readAsync(firstEntry, lastEntry);
    }

    public CompletableFuture<Long> readLastAddConfirmedAsync() {
        return CompletableFuture.completedFuture(this.getLastAddConfirmed());
    }

    public CompletableFuture<Long> tryReadLastAddConfirmedAsync() {
        return CompletableFuture.completedFuture(this.getLastAddConfirmed());
    }

    public long getLastAddConfirmed() {
        return this.getLedgerMetadata().getLastEntryId();
    }

    public long getLength() {
        return this.getLedgerMetadata().getLength();
    }

    public boolean isClosed() {
        return this.getLedgerMetadata().isClosed();
    }

    public CompletableFuture<LastConfirmedAndEntry> readLastAddConfirmedAndEntryAsync(long entryId, long timeOutInMillis, boolean parallel) {
        CompletableFuture<LastConfirmedAndEntry> promise = new CompletableFuture<LastConfirmedAndEntry>();
        promise.completeExceptionally(new UnsupportedOperationException());
        return promise;
    }

    public static ReadHandle open(ScheduledExecutorService executor, BlobStore blobStore, String bucket, String key, String indexKey, DataBlockUtils.VersionCheck versionCheck, long ledgerId, int readBufferSize) throws IOException {
        Blob blob = blobStore.getBlob(bucket, indexKey);
        versionCheck.check(indexKey, blob);
        OffloadIndexBlockBuilder indexBuilder = OffloadIndexBlockBuilder.create();
        OffloadIndexBlock index = indexBuilder.fromStream(blob.getPayload().openStream());
        BlobStoreBackedInputStreamImpl inputStream = new BlobStoreBackedInputStreamImpl(blobStore, bucket, key, versionCheck, index.getDataObjectLength(), readBufferSize);
        return new BlobStoreBackedReadHandleImpl(ledgerId, index, inputStream, executor);
    }
}

