/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.impl;

import com.google.common.io.CountingInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bookkeeper.mledger.offload.jcloud.DataBlockHeader;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;

public class StreamingDataBlockHeaderImpl
implements DataBlockHeader {
    static final int MAGIC_WORD = 648441138;
    public static final int HEADER_MAX_SIZE = 128;
    private static final int HEADER_BYTES_USED = 36;
    private static final byte[] PADDING = new byte[92];
    private final long ledgerId;
    private final long headerLength;
    private final long blockLength;
    private final long firstEntryId;

    public long getLedgerId() {
        return this.ledgerId;
    }

    public static StreamingDataBlockHeaderImpl of(int blockLength, long ledgerId, long firstEntryId) {
        return new StreamingDataBlockHeaderImpl(128L, blockLength, ledgerId, firstEntryId);
    }

    public static int getBlockMagicWord() {
        return 648441138;
    }

    public static int getDataStartOffset() {
        return 128;
    }

    @Override
    public long getBlockLength() {
        return this.blockLength;
    }

    @Override
    public long getHeaderLength() {
        return this.headerLength;
    }

    @Override
    public long getFirstEntryId() {
        return this.firstEntryId;
    }

    public StreamingDataBlockHeaderImpl(long headerLength, long blockLength, long ledgerId, long firstEntryId) {
        this.headerLength = headerLength;
        this.blockLength = blockLength;
        this.firstEntryId = firstEntryId;
        this.ledgerId = ledgerId;
    }

    public static StreamingDataBlockHeaderImpl fromStream(InputStream stream) throws IOException {
        CountingInputStream countingStream = new CountingInputStream(stream);
        DataInputStream dis = new DataInputStream((InputStream)countingStream);
        int magic = dis.readInt();
        if (magic != 648441138) {
            throw new IOException("Data block header magic word not match. read: " + magic + " expected: " + 648441138);
        }
        long headerLen = dis.readLong();
        long blockLen = dis.readLong();
        long firstEntryId = dis.readLong();
        long ledgerId = dis.readLong();
        long toSkip = headerLen - countingStream.getCount();
        if (dis.skip(toSkip) != toSkip) {
            throw new EOFException("Header was too small");
        }
        return new StreamingDataBlockHeaderImpl(headerLen, blockLen, ledgerId, firstEntryId);
    }

    @Override
    public InputStream toStream() {
        ByteBuf out = PulsarByteBufAllocator.DEFAULT.buffer(128, 128);
        out.writeInt(648441138).writeLong(this.headerLength).writeLong(this.blockLength).writeLong(this.firstEntryId).writeLong(this.ledgerId).writeBytes(PADDING);
        return new ByteBufInputStream(out, true);
    }

    public String toString() {
        return String.format("StreamingDataBlockHeader(len:%d,hlen:%d,firstEntry:%d,ledger:%d)", this.blockLength, this.headerLength, this.firstEntryId, this.ledgerId);
    }
}

