/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlock;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlockBuilder;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlockV2;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlockV2Builder;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.OffloadIndexBlockImpl;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.OffloadIndexBlockV2Impl;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.OffloadIndexEntryImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;

public class OffloadIndexBlockV2BuilderImpl
implements OffloadIndexBlockBuilder,
OffloadIndexBlockV2Builder {
    private final Map<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgerMetadataMap;
    private LedgerMetadata ledgerMetadata;
    private long dataObjectLength;
    private long dataHeaderLength;
    private List<OffloadIndexEntryImpl> entries;
    private int lastBlockSize;
    private int lastStreamingBlockSize;
    private long streamingOffset = 0L;
    private final SortedMap<Long, List<OffloadIndexEntryImpl>> entryMap = new TreeMap<Long, List<OffloadIndexEntryImpl>>();

    public OffloadIndexBlockV2BuilderImpl() {
        this.entries = Lists.newArrayList();
        this.ledgerMetadataMap = new HashMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
    }

    @Override
    public OffloadIndexBlockV2BuilderImpl withDataObjectLength(long dataObjectLength) {
        this.dataObjectLength = dataObjectLength;
        return this;
    }

    @Override
    public OffloadIndexBlockV2BuilderImpl withDataBlockHeaderLength(long dataHeaderLength) {
        this.dataHeaderLength = dataHeaderLength;
        return this;
    }

    @Override
    public OffloadIndexBlockV2BuilderImpl withLedgerMetadata(LedgerMetadata metadata) {
        this.ledgerMetadata = metadata;
        return this;
    }

    @Override
    public OffloadIndexBlockV2BuilderImpl addLedgerMeta(Long ledgerId, MLDataFormats.ManagedLedgerInfo.LedgerInfo metadata) {
        this.ledgerMetadataMap.put(ledgerId, metadata);
        return this;
    }

    @Override
    public OffloadIndexBlockBuilder addBlock(long firstEntryId, int partId, int blockSize) {
        long offset;
        Preconditions.checkState((this.dataHeaderLength > 0L ? 1 : 0) != 0);
        if (firstEntryId == 0L) {
            Preconditions.checkState((this.entries.size() == 0 ? 1 : 0) != 0);
            offset = 0L;
        } else {
            Preconditions.checkState((this.entries.size() > 0 ? 1 : 0) != 0);
            offset = this.entries.get(this.entries.size() - 1).getOffset() + (long)this.lastBlockSize;
        }
        this.lastBlockSize = blockSize;
        this.entries.add(OffloadIndexEntryImpl.of(firstEntryId, partId, offset, this.dataHeaderLength));
        return this;
    }

    @Override
    public OffloadIndexBlockV2Builder addBlock(long ledgerId, long firstEntryId, int partId, int blockSize) {
        Preconditions.checkState((this.dataHeaderLength > 0L ? 1 : 0) != 0);
        this.streamingOffset += (long)this.lastStreamingBlockSize;
        this.lastStreamingBlockSize = blockSize;
        List list = this.entryMap.getOrDefault(ledgerId, new LinkedList());
        list.add(OffloadIndexEntryImpl.of(firstEntryId, partId, this.streamingOffset, this.dataHeaderLength));
        this.entryMap.put(ledgerId, list);
        return this;
    }

    @Override
    public OffloadIndexBlockV2 fromStream(InputStream is) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(is);
        int magic = dataInputStream.readInt();
        if (magic == OffloadIndexBlockImpl.getIndexMagicWord()) {
            return OffloadIndexBlockImpl.get(magic, dataInputStream);
        }
        if (magic == OffloadIndexBlockV2Impl.getIndexMagicWord()) {
            return OffloadIndexBlockV2Impl.get(magic, dataInputStream);
        }
        throw new IOException(String.format("Invalid MagicWord. read: 0x%x  expected: 0x%x or 0x%x", magic, OffloadIndexBlockImpl.getIndexMagicWord(), OffloadIndexBlockV2Impl.getIndexMagicWord()));
    }

    @Override
    public OffloadIndexBlock build() {
        Preconditions.checkState((this.ledgerMetadata != null ? 1 : 0) != 0);
        Preconditions.checkState((!this.entries.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.dataObjectLength > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.dataHeaderLength > 0L ? 1 : 0) != 0);
        return OffloadIndexBlockImpl.get(this.ledgerMetadata, this.dataObjectLength, this.dataHeaderLength, this.entries);
    }

    @Override
    public OffloadIndexBlockV2 buildV2() {
        Preconditions.checkState((!this.ledgerMetadataMap.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)true);
        Preconditions.checkState((!this.entryMap.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.dataObjectLength > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.dataHeaderLength > 0L ? 1 : 0) != 0);
        return OffloadIndexBlockV2Impl.get(this.ledgerMetadataMap, this.dataObjectLength, this.dataHeaderLength, this.entryMap);
    }
}

