/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.impl;

import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexEntry;

public class OffloadIndexEntryImpl
implements OffloadIndexEntry {
    private final long entryId;
    private final int partId;
    private final long offset;
    private final long blockHeaderSize;

    public static OffloadIndexEntryImpl of(long entryId, int partId, long offset, long blockHeaderSize) {
        return new OffloadIndexEntryImpl(entryId, partId, offset, blockHeaderSize);
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public int getPartId() {
        return this.partId;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getDataOffset() {
        return this.offset + this.blockHeaderSize;
    }

    private OffloadIndexEntryImpl(long entryId, int partId, long offset, long blockHeaderSize) {
        this.entryId = entryId;
        this.partId = partId;
        this.offset = offset;
        this.blockHeaderSize = blockHeaderSize;
    }

    public String toString() {
        return String.format("[eid:%d, part:%d, offset:%d, doffset:%d]", this.entryId, this.partId, this.offset, this.getDataOffset());
    }
}

