/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.provider;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.bookkeeper.mledger.offload.jcloud.provider.TieredStorageConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.aws.s3.AWSS3ProviderMetadata;
import org.jclouds.azureblob.AzureBlobProviderMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.TransientApiMetadata;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.googlecloud.GoogleCredentialsFromJson;
import org.jclouds.googlecloudstorage.GoogleCloudStorageProviderMetadata;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.s3.S3ApiMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JCloudBlobStoreProvider implements Serializable,
TieredStorageConfiguration.ConfigValidation,
TieredStorageConfiguration.BlobStoreBuilder,
TieredStorageConfiguration.CredentialBuilder
{
    AWS_S3("aws-s3", (ProviderMetadata)new AWSS3ProviderMetadata()){

        @Override
        public void validate(TieredStorageConfiguration config) throws IllegalArgumentException {
            VALIDATION.validate(config);
        }

        @Override
        public BlobStore getBlobStore(TieredStorageConfiguration config) {
            return BLOB_STORE_BUILDER.getBlobStore(config);
        }

        @Override
        public void buildCredentials(TieredStorageConfiguration config) {
            AWS_CREDENTIAL_BUILDER.buildCredentials(config);
        }
    }
    ,
    GOOGLE_CLOUD_STORAGE("google-cloud-storage", (ProviderMetadata)new GoogleCloudStorageProviderMetadata()){

        @Override
        public void validate(TieredStorageConfiguration config) throws IllegalArgumentException {
            VALIDATION.validate(config);
        }

        @Override
        public BlobStore getBlobStore(TieredStorageConfiguration config) {
            return BLOB_STORE_BUILDER.getBlobStore(config);
        }

        @Override
        public void buildCredentials(TieredStorageConfiguration config) {
            if (config.getCredentials() == null) {
                try {
                    String gcsKeyContent = Files.asCharSource((File)new File(config.getConfigProperty("gcsManagedLedgerOffloadServiceAccountKeyFile")), (Charset)Charset.defaultCharset()).read();
                    config.setProviderCredentials(() -> new GoogleCredentialsFromJson(gcsKeyContent).get());
                }
                catch (IOException ioe) {
                    log.error("Cannot read GCS service account credentials file: {}", (Object)config.getConfigProperty("gcsManagedLedgerOffloadServiceAccountKeyFile"));
                    throw new IllegalArgumentException(ioe);
                }
            }
        }
    }
    ,
    AZURE_BLOB("azureblob", (ProviderMetadata)new AzureBlobProviderMetadata()){

        @Override
        public void validate(TieredStorageConfiguration config) throws IllegalArgumentException {
            VALIDATION.validate(config);
        }

        @Override
        public BlobStore getBlobStore(TieredStorageConfiguration config) {
            ContextBuilder contextBuilder = ContextBuilder.newBuilder((ProviderMetadata)config.getProviderMetadata());
            contextBuilder.overrides(config.getOverrides());
            if (config.getProviderCredentials() != null) {
                Credentials credentials = config.getProviderCredentials().get();
                return ((BlobStoreContext)contextBuilder.credentials(credentials.identity, credentials.credential).buildView(BlobStoreContext.class)).getBlobStore();
            }
            log.warn("The credentials is null. driver: {}, bucket: {}", (Object)config.getDriver(), (Object)config.getBucket());
            return ((BlobStoreContext)contextBuilder.buildView(BlobStoreContext.class)).getBlobStore();
        }

        @Override
        public void buildCredentials(TieredStorageConfiguration config) {
            String accountName = System.getenv("AZURE_STORAGE_ACCOUNT");
            if (StringUtils.isEmpty((CharSequence)accountName)) {
                throw new IllegalArgumentException("Couldn't get the azure storage account.");
            }
            String accountKey = System.getenv("AZURE_STORAGE_ACCESS_KEY");
            if (StringUtils.isEmpty((CharSequence)accountKey)) {
                throw new IllegalArgumentException("Couldn't get the azure storage access key.");
            }
            config.setProviderCredentials(() -> new Credentials(accountName, accountKey));
        }
    }
    ,
    ALIYUN_OSS("aliyun-oss", (ProviderMetadata)new AnonymousProviderMetadata((ApiMetadata)new S3ApiMetadata(), "")){

        @Override
        public void validate(TieredStorageConfiguration config) throws IllegalArgumentException {
            ALIYUN_OSS_VALIDATION.validate(config);
        }

        @Override
        public BlobStore getBlobStore(TieredStorageConfiguration config) {
            return ALIYUN_OSS_BLOB_STORE_BUILDER.getBlobStore(config);
        }

        @Override
        public void buildCredentials(TieredStorageConfiguration config) {
            ALIYUN_OSS_CREDENTIAL_BUILDER.buildCredentials(config);
        }
    }
    ,
    TRANSIENT("transient", (ProviderMetadata)new AnonymousProviderMetadata((ApiMetadata)new TransientApiMetadata(), "")){

        @Override
        public void validate(TieredStorageConfiguration config) throws IllegalArgumentException {
            if (Strings.isNullOrEmpty((String)config.getBucket())) {
                throw new IllegalArgumentException("Bucket cannot be empty for Local offload");
            }
        }

        @Override
        public BlobStore getBlobStore(TieredStorageConfiguration config) {
            ContextBuilder builder = ContextBuilder.newBuilder((String)"transient");
            BlobStoreContext ctx = (BlobStoreContext)builder.buildView(BlobStoreContext.class);
            BlobStore bs = ctx.getBlobStore();
            if (!bs.containerExists(config.getBucket())) {
                Location loc = new LocationBuilder().scope(LocationScope.HOST).id(UUID.randomUUID() + "").description("Transient " + config.getBucket()).build();
                bs.createContainerInLocation(loc, config.getBucket());
            }
            System.out.println("Returning " + bs);
            return bs;
        }

        @Override
        public void buildCredentials(TieredStorageConfiguration config) {
        }
    };

    private static final Logger log;
    private String driver;
    private ProviderMetadata providerMetadata;
    static final TieredStorageConfiguration.ConfigValidation VALIDATION;
    static final TieredStorageConfiguration.BlobStoreBuilder BLOB_STORE_BUILDER;
    static final TieredStorageConfiguration.CredentialBuilder AWS_CREDENTIAL_BUILDER;
    static final TieredStorageConfiguration.BlobStoreBuilder ALIYUN_OSS_BLOB_STORE_BUILDER;
    static final TieredStorageConfiguration.ConfigValidation ALIYUN_OSS_VALIDATION;
    static final TieredStorageConfiguration.CredentialBuilder ALIYUN_OSS_CREDENTIAL_BUILDER;

    public static JCloudBlobStoreProvider getProvider(String driver) {
        if (StringUtils.isEmpty((CharSequence)driver)) {
            return null;
        }
        for (JCloudBlobStoreProvider provider : JCloudBlobStoreProvider.values()) {
            if (!provider.driver.equalsIgnoreCase(driver)) continue;
            return provider;
        }
        return null;
    }

    public static final boolean driverSupported(String driverName) {
        for (JCloudBlobStoreProvider provider : JCloudBlobStoreProvider.values()) {
            if (!provider.getDriver().equalsIgnoreCase(driverName)) continue;
            return true;
        }
        return false;
    }

    private JCloudBlobStoreProvider(String s, ProviderMetadata providerMetadata) {
        this.driver = s;
        this.providerMetadata = providerMetadata;
    }

    public String getDriver() {
        return this.driver;
    }

    public ProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    private static /* synthetic */ Credentials lambda$null$2(AWSCredentialsProvider authChain) {
        AWSCredentials newCreds = authChain.getCredentials();
        Object jcloudCred = null;
        jcloudCred = newCreds instanceof AWSSessionCredentials ? SessionCredentials.builder().accessKeyId(newCreds.getAWSAccessKeyId()).secretAccessKey(newCreds.getAWSSecretKey()).sessionToken(((AWSSessionCredentials)newCreds).getSessionToken()).build() : new Credentials(newCreds.getAWSAccessKeyId(), newCreds.getAWSSecretKey());
        return jcloudCred;
    }

    static {
        log = LoggerFactory.getLogger(JCloudBlobStoreProvider.class);
        VALIDATION = config -> {
            if (Strings.isNullOrEmpty((String)config.getRegion()) && Strings.isNullOrEmpty((String)config.getServiceEndpoint())) {
                throw new IllegalArgumentException("Either Region or ServiceEndpoint must specified for " + config.getDriver() + " offload");
            }
            if (Strings.isNullOrEmpty((String)config.getBucket())) {
                throw new IllegalArgumentException("Bucket cannot be empty for " + config.getDriver() + " offload");
            }
            if (config.getMaxBlockSizeInBytes() < 0x500000) {
                throw new IllegalArgumentException("ManagedLedgerOffloadMaxBlockSizeInBytes cannot be less than 5MB for " + config.getDriver() + " offload");
            }
        };
        BLOB_STORE_BUILDER = config -> {
            ContextBuilder contextBuilder = ContextBuilder.newBuilder((ProviderMetadata)config.getProviderMetadata());
            contextBuilder.overrides(config.getOverrides());
            if (StringUtils.isNotEmpty((CharSequence)config.getServiceEndpoint())) {
                contextBuilder.endpoint(config.getServiceEndpoint());
            }
            if (config.getProviderCredentials() != null) {
                return ((BlobStoreContext)contextBuilder.credentialsSupplier(((Supplier<Credentials>)config.getCredentials())::get).buildView(BlobStoreContext.class)).getBlobStore();
            }
            log.warn("The credentials is null. driver: {}, bucket: {}", (Object)config.getDriver(), (Object)config.getBucket());
            return ((BlobStoreContext)contextBuilder.buildView(BlobStoreContext.class)).getBlobStore();
        };
        AWS_CREDENTIAL_BUILDER = config -> {
            if (config.getCredentials() == null) {
                try {
                    Object authChain;
                    if (!Strings.isNullOrEmpty((String)config.getConfigProperty("s3ManagedLedgerOffloadCredentialId")) && !Strings.isNullOrEmpty((String)config.getConfigProperty("s3ManagedLedgerOffloadCredentialSecret"))) {
                        AWSCredentials awsCredentials = new AWSCredentials(){

                            public String getAWSAccessKeyId() {
                                return config.getConfigProperty("s3ManagedLedgerOffloadCredentialId");
                            }

                            public String getAWSSecretKey() {
                                return config.getConfigProperty("s3ManagedLedgerOffloadCredentialSecret");
                            }
                        };
                        authChain = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(config.getConfigProperty("s3ManagedLedgerOffloadCredentialId"), config.getConfigProperty("s3ManagedLedgerOffloadCredentialSecret")));
                    } else {
                        authChain = Strings.isNullOrEmpty((String)config.getConfigProperty("s3ManagedLedgerOffloadRole")) ? DefaultAWSCredentialsProviderChain.getInstance() : new STSAssumeRoleSessionCredentialsProvider.Builder(config.getConfigProperty("s3ManagedLedgerOffloadRole"), config.getConfigProperty("s3ManagedLedgerOffloadRoleSessionName")).build();
                    }
                    config.setProviderCredentials(() -> JCloudBlobStoreProvider.lambda$null$2((AWSCredentialsProvider)authChain));
                }
                catch (Exception e) {
                    log.warn("Exception when get credentials for s3 ", (Throwable)e);
                }
            }
        };
        ALIYUN_OSS_BLOB_STORE_BUILDER = config -> {
            ContextBuilder contextBuilder = ContextBuilder.newBuilder((ProviderMetadata)config.getProviderMetadata());
            Properties overrides = config.getOverrides();
            overrides.setProperty("jclouds.s3.virtual-host-buckets", "true");
            contextBuilder.overrides(overrides);
            contextBuilder.endpoint(config.getServiceEndpoint());
            if (config.getProviderCredentials() != null) {
                return ((BlobStoreContext)contextBuilder.credentialsSupplier(((Supplier<Credentials>)config.getCredentials())::get).buildView(BlobStoreContext.class)).getBlobStore();
            }
            log.warn("The credentials is null. driver: {}, bucket: {}", (Object)config.getDriver(), (Object)config.getBucket());
            return ((BlobStoreContext)contextBuilder.buildView(BlobStoreContext.class)).getBlobStore();
        };
        ALIYUN_OSS_VALIDATION = config -> {
            if (Strings.isNullOrEmpty((String)config.getServiceEndpoint())) {
                throw new IllegalArgumentException("ServiceEndpoint must specified for " + config.getDriver() + " offload");
            }
            if (Strings.isNullOrEmpty((String)config.getBucket())) {
                throw new IllegalArgumentException("Bucket cannot be empty for " + config.getDriver() + " offload");
            }
            if (config.getMaxBlockSizeInBytes() < 0x500000) {
                throw new IllegalArgumentException("ManagedLedgerOffloadMaxBlockSizeInBytes cannot be less than 5MB for " + config.getDriver() + " offload");
            }
        };
        ALIYUN_OSS_CREDENTIAL_BUILDER = config -> {
            String accountName = System.getenv("ALIYUN_OSS_ACCESS_KEY_ID");
            if (StringUtils.isEmpty((CharSequence)accountName)) {
                throw new IllegalArgumentException("Couldn't get the aliyun oss access key id.");
            }
            String accountKey = System.getenv("ALIYUN_OSS_ACCESS_KEY_SECRET");
            if (StringUtils.isEmpty((CharSequence)accountKey)) {
                throw new IllegalArgumentException("Couldn't get the aliyun oss access key secret.");
            }
            Credentials credentials = new Credentials(accountName, accountKey);
            config.setProviderCredentials(() -> credentials);
        };
    }
}

