/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlet;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.eclipse.jetty.servlet.ServletHolder;

public class RandomAdditionalServlet
extends HttpServlet
implements AdditionalServlet {
    private int sequenceLength;

    public void loadConfig(PulsarConfiguration pulsarConfiguration) {
        this.sequenceLength = Integer.parseInt(pulsarConfiguration.getProperties().getProperty("randomServletSequenceLength"));
    }

    public String getBasePath() {
        return "/random";
    }

    public ServletHolder getServletHolder() {
        return new ServletHolder((Servlet)this);
    }

    public void close() {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/plain");
        List numbers = IntStream.range(0, this.sequenceLength).boxed().collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(numbers);
        String responseBody = numbers.stream().map(Object::toString).collect(Collectors.joining(","));
        ServletOutputStream output = resp.getOutputStream();
        output.write(responseBody.getBytes());
        output.close();
    }
}

