/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.plugins;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBrokerInterceptor
implements BrokerInterceptor {
    private final Logger log = LoggerFactory.getLogger(LoggingBrokerInterceptor.class);

    public void onPulsarCommand(BaseCommand command, ServerCnx cnx) {
        this.log.info("onPulsarCommand");
    }

    public void onConnectionClosed(ServerCnx cnx) {
        this.log.info("onConnectionClosed");
    }

    public void onWebserviceRequest(ServletRequest request) {
        this.log.info("onWebserviceRequest");
    }

    public void onWebserviceResponse(ServletRequest request, ServletResponse response) {
        this.log.info("onWebserviceResponse");
    }

    public void initialize(PulsarService pulsarService) {
        this.log.info("initialize: " + (pulsarService != null ? "OK" : "NULL"));
    }

    public void close() {
        this.log.info("close");
    }

    public void beforeSendMessage(Subscription subscription, Entry entry, long[] ackSet, MessageMetadata msgMetadata) {
        this.log.info("beforeSendMessage: " + ("producer".equals(msgMetadata.getProducerName()) ? "OK" : "WRONG"));
    }

    public void onConnectionCreated(ServerCnx cnx) {
        this.log.info("onConnectionCreated");
    }

    public void producerCreated(ServerCnx cnx, Producer producer, Map<String, String> metadata) {
        this.log.info("producerCreated");
    }

    public void consumerCreated(ServerCnx cnx, Consumer consumer, Map<String, String> metadata) {
        this.log.info("consumerCreated");
    }

    public void messageProduced(ServerCnx cnx, Producer producer, long startTimeNs, long ledgerId, long entryId, Topic.PublishContext publishContext) {
        this.log.info("messageProduced");
    }

    public void messageDispatched(ServerCnx cnx, Consumer consumer, long ledgerId, long entryId, ByteBuf headersAndPayload) {
        this.log.info("messageDispatched");
    }

    public void messageAcked(ServerCnx cnx, Consumer consumer, CommandAck ackCmd) {
        this.log.info("messageAcked");
    }

    public void txnOpened(long tcId, String txnID) {
        this.log.info("txnOpened");
    }

    public void txnEnded(String txnID, long txnAction) {
        this.log.info("txnEnded");
    }

    public void onFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        this.log.info("onFilter");
    }
}

