/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.functions;

import org.apache.pulsar.client.api.schema.GenericObject;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.api.Function;
import org.apache.pulsar.functions.api.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericObjectFunction
implements Function<GenericObject, Void> {
    private static final Logger log = LoggerFactory.getLogger(GenericObjectFunction.class);

    public Void process(GenericObject genericObject, Context context) throws Exception {
        Record currentRecord = context.getCurrentRecord();
        log.info("apply to {} {}", (Object)genericObject, genericObject.getNativeObject());
        log.info("record with schema {} {}", (Object)currentRecord.getSchema(), (Object)currentRecord);
        if (switch (currentRecord.getSchema().getSchemaInfo().getType()) {
            case SchemaType.AVRO, SchemaType.JSON, SchemaType.PROTOBUF_NATIVE -> true;
            default -> false;
        }) {
            context.newOutputMessage(context.getOutputTopic(), currentRecord.getSchema()).value((Object)genericObject).send();
        } else {
            context.newOutputMessage(context.getOutputTopic(), currentRecord.getSchema()).value(genericObject.getNativeObject()).send();
        }
        return null;
    }
}

