/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.Source;
import org.apache.pulsar.io.core.SourceContext;

public class TestStateSource
implements Source<String> {
    private SourceContext sourceContext;
    private int count;

    public void open(Map<String, Object> config, SourceContext sourceContext) throws Exception {
        sourceContext.putState("initial", ByteBuffer.wrap("val1".getBytes()));
        this.sourceContext = sourceContext;
    }

    public Record<String> read() throws Exception {
        Thread.sleep(50L);
        String initial = new String(this.sourceContext.getState("initial").array());
        String val = String.format("%s-%d", initial, this.count);
        this.sourceContext.putState("now", ByteBuffer.wrap(val.getBytes()));
        ++this.count;
        return () -> val;
    }

    public void close() throws Exception {
    }
}

