/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiPredicate;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockZooKeeper
extends ZooKeeper {
    private TreeMap<String, MockZNode> tree;
    private SetMultimap<String, Watcher> watchers;
    private volatile boolean stopped;
    private AtomicReference<KeeperException.Code> alwaysFail;
    private CopyOnWriteArrayList<Failure> failures;
    private ExecutorService executor;
    private Watcher sessionWatcher;
    private long sessionId = 0L;
    private int readOpDelayMs;
    private ReentrantLock mutex;
    private AtomicLong sequentialIdGenerator;
    private ThreadLocal<Long> epheralOwnerThreadLocal;
    private static final Objenesis objenesis = new ObjenesisStd();
    private List<PersistentWatcher> persistentWatchers;
    private ThreadLocal<SingleAcquireAndReleaseLock> lockInstance;
    private static final Logger log = LoggerFactory.getLogger(MockZooKeeper.class);

    public static MockZooKeeper newInstance() {
        return MockZooKeeper.newInstance(null);
    }

    public static MockZooKeeper newInstance(ExecutorService executor) {
        return MockZooKeeper.newInstance(executor, -1);
    }

    public static MockZooKeeper newInstanceForGlobalZK(ExecutorService executor) {
        return MockZooKeeper.newInstanceForGlobalZK(executor, -1);
    }

    public static MockZooKeeper newInstanceForGlobalZK(ExecutorService executor, int readOpDelayMs) {
        try {
            return MockZooKeeper.createMockZooKeeperInstance(executor, readOpDelayMs);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create object", e);
        }
    }

    public static MockZooKeeper newInstance(ExecutorService executor, int readOpDelayMs) {
        try {
            MockZooKeeper zk = MockZooKeeper.createMockZooKeeperInstance(executor, readOpDelayMs);
            ObjectInstantiator clientCnxnObjectInstantiator = objenesis.getInstantiatorOf(ClientCnxn.class);
            Whitebox.setInternalState((Object)((Object)zk), (String)"cnxn", (Object)clientCnxnObjectInstantiator.newInstance());
            return zk;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create object", e);
        }
    }

    private static MockZooKeeper createMockZooKeeperInstance(ExecutorService executor, int readOpDelayMs) {
        ObjectInstantiator mockZooKeeperInstantiator = objenesis.getInstantiatorOf(MockZooKeeper.class);
        MockZooKeeper zk = (MockZooKeeper)((Object)mockZooKeeperInstantiator.newInstance());
        zk.epheralOwnerThreadLocal = new ThreadLocal();
        zk.init(executor);
        zk.readOpDelayMs = readOpDelayMs;
        zk.mutex = new ReentrantLock();
        zk.lockInstance = ThreadLocal.withInitial(zk::createLock);
        zk.sequentialIdGenerator = new AtomicLong();
        return zk;
    }

    private void init(ExecutorService executor) {
        this.tree = Maps.newTreeMap();
        this.executor = executor != null ? executor : Executors.newFixedThreadPool(1, (ThreadFactory)new DefaultThreadFactory("mock-zookeeper"));
        HashMultimap w = HashMultimap.create();
        this.watchers = Multimaps.synchronizedSetMultimap((SetMultimap)w);
        this.stopped = false;
        this.alwaysFail = new AtomicReference<KeeperException.Code>(KeeperException.Code.OK);
        this.failures = new CopyOnWriteArrayList();
        this.persistentWatchers = new ArrayList<PersistentWatcher>();
    }

    public int getSessionTimeout() {
        return 30000;
    }

    private MockZooKeeper(String quorum) throws Exception {
        super(quorum, 1, event -> {});
        assert (false);
    }

    public ZooKeeper.States getState() {
        return ZooKeeper.States.CONNECTED;
    }

    private SingleAcquireAndReleaseLock createLock() {
        return new SingleAcquireAndReleaseLock(this.mutex);
    }

    private void lock() {
        this.lockInstance.get().lock();
    }

    private void unlockIfLocked() {
        this.lockInstance.get().unlockIfNeeded();
    }

    public void register(Watcher watcher) {
        this.lock();
        this.sessionWatcher = watcher;
        this.unlockIfLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        HashSet toNotifyCreate = Sets.newHashSet();
        HashSet toNotifyParent = Sets.newHashSet();
        String parent = path.substring(0, path.lastIndexOf("/"));
        this.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.CREATE, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (this.tree.containsKey(path)) {
                throw new KeeperException.NodeExistsException(path);
            }
            if (!parent.isEmpty() && !this.tree.containsKey(parent)) {
                throw new KeeperException.NoNodeException();
            }
            if (createMode.isSequential()) {
                MockZNode parentNode = this.tree.get(parent);
                int parentVersion = this.tree.get(parent).getVersion();
                path = path + parentVersion;
                this.tree.put(parent, MockZNode.of(parentNode.getContent(), parentVersion + 1, parentNode.getEphemeralOwner()));
            }
            this.tree.put(path, MockZNode.of(data, 0, createMode.isEphemeral() ? this.getEphemeralOwner() : -1L));
            toNotifyCreate.addAll(this.watchers.get((Object)path));
            if (!parent.isEmpty()) {
                toNotifyParent.addAll(this.watchers.get((Object)parent));
            }
            this.watchers.removeAll((Object)path);
        }
        finally {
            this.unlockIfLocked();
        }
        String finalPath = path;
        this.executor.execute(() -> {
            this.triggerPersistentWatches(finalPath, parent, Watcher.Event.EventType.NodeCreated);
            toNotifyCreate.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, finalPath)));
            toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
        });
        return path;
    }

    protected long getEphemeralOwner() {
        Long epheralOwner = this.epheralOwnerThreadLocal.get();
        if (epheralOwner != null) {
            return epheralOwner;
        }
        return this.getSessionId();
    }

    public void overrideEpheralOwner(long epheralOwner) {
        this.epheralOwnerThreadLocal.set(epheralOwner);
    }

    public void removeEpheralOwnerOverride() {
        this.epheralOwnerThreadLocal.remove();
    }

    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.lock();
            try {
                if (this.stopped) {
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                    return;
                }
                HashSet toNotifyCreate = Sets.newHashSet();
                toNotifyCreate.addAll(this.watchers.get((Object)path));
                HashSet toNotifyParent = Sets.newHashSet();
                String parent = path.substring(0, path.lastIndexOf("/"));
                if (!parent.isEmpty()) {
                    toNotifyParent.addAll(this.watchers.get((Object)parent));
                }
                String name = createMode != null && createMode.isSequential() ? path + this.sequentialIdGenerator.getAndIncrement() : path;
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.CREATE, path);
                if (failure.isPresent()) {
                    this.unlockIfLocked();
                    cb.processResult(failure.get().intValue(), path, ctx, null);
                } else if (this.stopped) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                } else if (this.tree.containsKey(path)) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.NODEEXISTS.intValue(), path, ctx, null);
                } else if (!parent.isEmpty() && !this.tree.containsKey(parent)) {
                    this.unlockIfLocked();
                    toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                } else {
                    this.tree.put(name, MockZNode.of(data, 0, createMode != null && createMode.isEphemeral() ? this.getEphemeralOwner() : -1L));
                    this.watchers.removeAll((Object)name);
                    this.unlockIfLocked();
                    cb.processResult(0, path, ctx, name);
                    this.triggerPersistentWatches(path, parent, Watcher.Event.EventType.NodeCreated);
                    toNotifyCreate.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, name)));
                    toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
                }
            }
            finally {
                this.unlockIfLocked();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException {
        this.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.GET, path);
            MockZNode value = this.tree.get(path);
            if (value == null) {
                throw new KeeperException.NoNodeException(path);
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            if (stat != null) {
                MockZooKeeper.applyToStat(value, stat);
            }
            byte[] byArray = value.getContent();
            return byArray;
        }
        finally {
            this.unlockIfLocked();
        }
    }

    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.executor.execute(() -> {
            MockZNode value;
            this.checkReadOpDelay();
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET, path);
            if (failure.isPresent()) {
                cb.processResult(failure.get().intValue(), path, ctx, null, null);
                return;
            }
            if (this.stopped) {
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
                return;
            }
            this.lock();
            try {
                value = this.tree.get(path);
            }
            finally {
                this.unlockIfLocked();
            }
            if (value == null) {
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
            } else {
                cb.processResult(0, path, ctx, value.getContent(), MockZooKeeper.createStatForZNode(value));
            }
        });
    }

    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.checkReadOpDelay();
            this.lock();
            try {
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET, path);
                if (failure.isPresent()) {
                    this.unlockIfLocked();
                    cb.processResult(failure.get().intValue(), path, ctx, null, null);
                    return;
                }
                if (this.stopped) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
                    return;
                }
                MockZNode value = this.tree.get(path);
                if (value == null) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
                } else {
                    if (watcher != null) {
                        this.watchers.put((Object)path, (Object)watcher);
                    }
                    Stat stat = MockZooKeeper.createStatForZNode(value);
                    this.unlockIfLocked();
                    cb.processResult(0, path, ctx, value.getContent(), stat);
                }
            }
            finally {
                this.unlockIfLocked();
            }
        });
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.lock();
            ArrayList children = Lists.newArrayList();
            try {
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET_CHILDREN, path);
                if (failure.isPresent()) {
                    this.unlockIfLocked();
                    cb.processResult(failure.get().intValue(), path, ctx, null);
                    return;
                }
                if (this.stopped) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                    return;
                }
                if (!this.tree.containsKey(path)) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                    return;
                }
                for (String item : this.tree.tailMap(path).keySet()) {
                    if (!item.startsWith(path)) break;
                    if (path.length() >= item.length()) continue;
                    String child = item.substring(path.length() + 1);
                    if (item.charAt(path.length()) != '/' || child.contains("/")) continue;
                    children.add(child);
                }
                if (watcher != null) {
                    this.watchers.put((Object)path, (Object)watcher);
                }
            }
            finally {
                this.unlockIfLocked();
            }
            cb.processResult(0, path, ctx, (List)children);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path, Watcher watcher) throws KeeperException {
        this.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.GET_CHILDREN, path);
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException();
            }
            String firstKey = path.equals("/") ? path : path + "/";
            String lastKey = path.equals("/") ? "0" : path + "0";
            TreeSet children = new TreeSet();
            this.tree.subMap(firstKey, false, lastKey, false).forEach((key, value) -> {
                String relativePath = key.replace(firstKey, "");
                String child = relativePath.split("/", 2)[0];
                children.add(child);
            });
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            ArrayList<String> arrayList = new ArrayList<String>(children);
            return arrayList;
        }
        finally {
            this.unlockIfLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        this.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.GET_CHILDREN, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException();
            }
            String firstKey = path.equals("/") ? path : path + "/";
            String lastKey = path.equals("/") ? "0" : path + "0";
            TreeSet children = new TreeSet();
            this.tree.subMap(firstKey, false, lastKey, false).forEach((key, value) -> {
                String relativePath = key.replace(firstKey, "");
                String child = relativePath.split("/", 2)[0];
                children.add(child);
            });
            ArrayList<String> arrayList = new ArrayList<String>(children);
            return arrayList;
        }
        finally {
            this.unlockIfLocked();
        }
    }

    public void getChildren(String path, boolean watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        this.executor.execute(() -> {
            TreeSet children = new TreeSet();
            this.lock();
            try {
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET_CHILDREN, path);
                if (failure.isPresent()) {
                    this.unlockIfLocked();
                    cb.processResult(failure.get().intValue(), path, ctx, null, null);
                    return;
                }
                if (this.stopped) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
                    return;
                }
                if (!this.tree.containsKey(path)) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
                    return;
                }
                String firstKey = path.equals("/") ? path : path + "/";
                String lastKey = path.equals("/") ? "0" : path + "0";
                this.tree.subMap(firstKey, false, lastKey, false).forEach((key, value) -> {
                    String relativePath = key.replace(firstKey, "");
                    String child = relativePath.split("/", 2)[0];
                    children.add(child);
                });
            }
            finally {
                this.unlockIfLocked();
            }
            cb.processResult(0, path, ctx, new ArrayList(children), new Stat());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        this.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.EXISTS, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (this.tree.containsKey(path)) {
                Stat stat = MockZooKeeper.createStatForZNode(this.tree.get(path));
                return stat;
            }
            Stat stat = null;
            return stat;
        }
        finally {
            this.unlockIfLocked();
        }
    }

    private static Stat createStatForZNode(MockZNode zNode) {
        return MockZooKeeper.applyToStat(zNode, new Stat());
    }

    private static Stat applyToStat(MockZNode zNode, Stat stat) {
        stat.setVersion(zNode.getVersion());
        if (zNode.getEphemeralOwner() != -1L) {
            stat.setEphemeralOwner(zNode.getEphemeralOwner());
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        this.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.EXISTS, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            if (this.tree.containsKey(path)) {
                Stat stat = MockZooKeeper.createStatForZNode(this.tree.get(path));
                return stat;
            }
            Stat stat = null;
            return stat;
        }
        finally {
            this.unlockIfLocked();
        }
    }

    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.exists(path, null, cb, ctx);
    }

    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.lock();
            try {
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.EXISTS, path);
                if (failure.isPresent()) {
                    this.unlockIfLocked();
                    cb.processResult(failure.get().intValue(), path, ctx, null);
                    return;
                }
                if (this.stopped) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                    return;
                }
                if (watcher != null) {
                    this.watchers.put((Object)path, (Object)watcher);
                }
                if (this.tree.containsKey(path)) {
                    this.unlockIfLocked();
                    cb.processResult(0, path, ctx, new Stat());
                } else {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                }
            }
            finally {
                this.unlockIfLocked();
            }
        });
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        this.executor.execute(() -> {
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.SYNC, path);
            if (failure.isPresent()) {
                cb.processResult(failure.get().intValue(), path, ctx);
                return;
            }
            if (this.stopped) {
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx);
                return;
            }
            cb.processResult(0, path, ctx);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        MockZNode newZNode;
        HashSet toNotify = Sets.newHashSet();
        this.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.SET, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException();
            }
            MockZNode mockZNode = this.tree.get(path);
            int currentVersion = mockZNode.getVersion();
            if (version != -1 && version != currentVersion) {
                throw new KeeperException.BadVersionException(path);
            }
            log.debug("[{}] Updating -- current version: {}", (Object)path, (Object)currentVersion);
            newZNode = MockZNode.of(data, currentVersion + 1, mockZNode.getEphemeralOwner());
            this.tree.put(path, newZNode);
            toNotify.addAll(this.watchers.get((Object)path));
            this.watchers.removeAll((Object)path);
        }
        finally {
            this.unlockIfLocked();
        }
        this.executor.execute(() -> {
            this.triggerPersistentWatches(path, null, Watcher.Event.EventType.NodeDataChanged);
            toNotify.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path)));
        });
        return MockZooKeeper.createStatForZNode(newZNode);
    }

    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        if (this.stopped) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
            return;
        }
        this.executor.execute(() -> {
            Stat stat;
            HashSet toNotify = Sets.newHashSet();
            this.lock();
            try {
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.SET, path);
                if (failure.isPresent()) {
                    this.unlockIfLocked();
                    cb.processResult(failure.get().intValue(), path, ctx, null);
                    return;
                }
                if (this.stopped) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                    return;
                }
                if (!this.tree.containsKey(path)) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                    return;
                }
                MockZNode mockZNode = this.tree.get(path);
                int currentVersion = mockZNode.getVersion();
                if (version != -1 && version != currentVersion) {
                    log.debug("[{}] Current version: {} -- Expected: {}", new Object[]{path, currentVersion, version});
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.BADVERSION.intValue(), path, ctx, null);
                    return;
                }
                log.debug("[{}] Updating -- current version: {}", (Object)path, (Object)currentVersion);
                MockZNode newZNode = MockZNode.of(data, currentVersion + 1, mockZNode.getEphemeralOwner());
                this.tree.put(path, newZNode);
                stat = MockZooKeeper.createStatForZNode(newZNode);
            }
            finally {
                this.unlockIfLocked();
            }
            cb.processResult(0, path, ctx, stat);
            toNotify.addAll(this.watchers.get((Object)path));
            this.watchers.removeAll((Object)path);
            for (Watcher watcher : toNotify) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path));
            }
            this.triggerPersistentWatches(path, null, Watcher.Event.EventType.NodeDataChanged);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        String parent;
        HashSet toNotifyParent;
        HashSet toNotifyDelete;
        this.maybeThrowProgrammedFailure(Op.DELETE, path);
        this.lock();
        try {
            int currentVersion;
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException(path);
            }
            if (this.hasChildren(path)) {
                throw new KeeperException.NotEmptyException(path);
            }
            if (version != -1 && version != (currentVersion = this.tree.get(path).getVersion())) {
                throw new KeeperException.BadVersionException(path);
            }
            this.tree.remove(path);
            toNotifyDelete = Sets.newHashSet();
            toNotifyDelete.addAll(this.watchers.get((Object)path));
            toNotifyParent = Sets.newHashSet();
            parent = path.substring(0, path.lastIndexOf("/"));
            if (!parent.isEmpty()) {
                toNotifyParent.addAll(this.watchers.get((Object)parent));
            }
            this.watchers.removeAll((Object)path);
        }
        finally {
            this.unlockIfLocked();
        }
        this.executor.execute(() -> {
            if (this.stopped) {
                return;
            }
            for (Watcher watcher1 : toNotifyDelete) {
                watcher1.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path));
            }
            for (Watcher watcher2 : toNotifyParent) {
                watcher2.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent));
            }
            this.triggerPersistentWatches(path, parent, Watcher.Event.EventType.NodeDeleted);
        });
    }

    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        Runnable r = () -> {
            this.lock();
            try {
                HashSet toNotifyDelete = Sets.newHashSet();
                toNotifyDelete.addAll(this.watchers.get((Object)path));
                HashSet toNotifyParent = Sets.newHashSet();
                String parent = path.substring(0, path.lastIndexOf("/"));
                if (!parent.isEmpty()) {
                    toNotifyParent.addAll(this.watchers.get((Object)parent));
                }
                this.watchers.removeAll((Object)path);
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.DELETE, path);
                if (failure.isPresent()) {
                    this.unlockIfLocked();
                    cb.processResult(failure.get().intValue(), path, ctx);
                } else if (this.stopped) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx);
                } else if (!this.tree.containsKey(path)) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx);
                } else if (this.hasChildren(path)) {
                    this.unlockIfLocked();
                    cb.processResult(KeeperException.Code.NOTEMPTY.intValue(), path, ctx);
                } else {
                    int currentVersion;
                    if (version != -1 && version != (currentVersion = this.tree.get(path).getVersion())) {
                        this.unlockIfLocked();
                        cb.processResult(KeeperException.Code.BADVERSION.intValue(), path, ctx);
                        return;
                    }
                    this.tree.remove(path);
                    this.unlockIfLocked();
                    cb.processResult(0, path, ctx);
                    toNotifyDelete.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path)));
                    toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
                    this.triggerPersistentWatches(path, parent, Watcher.Event.EventType.NodeDeleted);
                }
            }
            finally {
                this.unlockIfLocked();
            }
        };
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException ree) {
            cb.processResult(KeeperException.Code.SESSIONEXPIRED.intValue(), path, ctx);
        }
    }

    public void multi(Iterable<org.apache.zookeeper.Op> ops, AsyncCallback.MultiCallback cb, Object ctx) {
        try {
            List<OpResult> res = this.multi(ops);
            cb.processResult(KeeperException.Code.OK.intValue(), null, ctx, res);
        }
        catch (Exception e) {
            cb.processResult(KeeperException.Code.APIERROR.intValue(), null, ctx, null);
        }
    }

    public List<OpResult> multi(Iterable<org.apache.zookeeper.Op> ops) throws InterruptedException, KeeperException {
        ArrayList<OpResult> res = new ArrayList<OpResult>();
        try {
            for (org.apache.zookeeper.Op op : ops) {
                switch (op.getType()) {
                    case 1: {
                        Op.Create opc = (Op.Create)op;
                        CreateMode cm = CreateMode.fromFlag((int)opc.flags);
                        String path = this.create(op.getPath(), opc.data, null, cm);
                        res.add((OpResult)new OpResult.CreateResult(path));
                        break;
                    }
                    case 2: {
                        this.delete(op.getPath(), (Integer)Whitebox.getInternalState((Object)op, (String)"version"));
                        res.add((OpResult)new OpResult.DeleteResult());
                        break;
                    }
                    case 5: {
                        Stat stat = this.setData(op.getPath(), (byte[])Whitebox.getInternalState((Object)op, (String)"data"), (Integer)Whitebox.getInternalState((Object)op, (String)"version"));
                        res.add((OpResult)new OpResult.SetDataResult(stat));
                        break;
                    }
                    case 8: {
                        try {
                            List<String> children = this.getChildren(op.getPath(), null);
                            res.add((OpResult)new OpResult.GetChildrenResult(children));
                        }
                        catch (KeeperException e) {
                            res.add((OpResult)new OpResult.ErrorResult(e.code().intValue()));
                        }
                        break;
                    }
                    case 4: {
                        Stat stat = new Stat();
                        try {
                            byte[] payload = this.getData(op.getPath(), null, stat);
                            res.add((OpResult)new OpResult.GetDataResult(payload, stat));
                        }
                        catch (KeeperException e) {
                            res.add((OpResult)new OpResult.ErrorResult(e.code().intValue()));
                        }
                        break;
                    }
                }
            }
        }
        catch (KeeperException e) {
            res.add((OpResult)new OpResult.ErrorResult(e.code().intValue()));
            int total = Iterables.size(ops);
            for (int i = res.size(); i < total; ++i) {
                res.add((OpResult)new OpResult.ErrorResult(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue()));
            }
        }
        return res;
    }

    public synchronized void addWatch(String basePath, Watcher watcher, AddWatchMode mode) {
        this.persistentWatchers.add(new PersistentWatcher(basePath, watcher, mode));
    }

    public void addWatch(String basePath, Watcher watcher, AddWatchMode mode, AsyncCallback.VoidCallback cb, Object ctx) {
        if (this.stopped) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), basePath, ctx);
            return;
        }
        this.executor.execute(() -> {
            MockZooKeeper mockZooKeeper = this;
            synchronized (mockZooKeeper) {
                this.persistentWatchers.add(new PersistentWatcher(basePath, watcher, mode));
            }
            cb.processResult(KeeperException.Code.OK.intValue(), basePath, ctx);
        });
    }

    public void close() throws InterruptedException {
    }

    public void shutdown() throws InterruptedException {
        this.lock();
        try {
            this.stopped = true;
            this.tree.clear();
            this.watchers.clear();
            try {
                this.executor.shutdownNow();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                log.error("MockZooKeeper shutdown had error", (Throwable)ex);
            }
        }
        finally {
            this.unlockIfLocked();
        }
    }

    Optional<KeeperException.Code> programmedFailure(Op op, String path) {
        KeeperException.Code error = this.alwaysFail.get();
        if (error != KeeperException.Code.OK) {
            return Optional.of(error);
        }
        Optional<Failure> failure = this.failures.stream().filter(f -> f.predicate.test(op, path)).findFirst();
        if (failure.isPresent()) {
            this.failures.remove(failure.get());
            return Optional.of(failure.get().failReturnCode);
        }
        return Optional.empty();
    }

    void maybeThrowProgrammedFailure(Op op, String path) throws KeeperException {
        Optional<KeeperException.Code> failure = this.programmedFailure(op, path);
        if (failure.isPresent()) {
            throw KeeperException.create((KeeperException.Code)failure.get());
        }
    }

    public void failConditional(KeeperException.Code rc, BiPredicate<Op, String> predicate) {
        this.failures.add(new Failure(rc, predicate));
    }

    public void setAlwaysFail(KeeperException.Code rc) {
        this.alwaysFail.set(rc);
    }

    public void unsetAlwaysFail() {
        this.alwaysFail.set(KeeperException.Code.OK);
    }

    public void setSessionId(long id) {
        this.sessionId = id;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    private boolean hasChildren(String path) {
        return !this.tree.subMap(path + '/', path + '0').isEmpty();
    }

    public String toString() {
        return "MockZookeeper";
    }

    private void checkReadOpDelay() {
        if (this.readOpDelayMs > 0) {
            try {
                Thread.sleep(this.readOpDelayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void triggerPersistentWatches(String path, String parent, Watcher.Event.EventType eventType) {
        this.persistentWatchers.forEach(w -> {
            if (w.mode == AddWatchMode.PERSISTENT_RECURSIVE) {
                if (path.startsWith(w.getPath())) {
                    w.watcher.process(new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, path));
                }
            } else if (w.mode == AddWatchMode.PERSISTENT) {
                if (w.getPath().equals(path)) {
                    w.watcher.process(new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, path));
                }
                if (eventType == Watcher.Event.EventType.NodeCreated || eventType == Watcher.Event.EventType.NodeDeleted) {
                    w.watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent));
                }
            }
        });
    }

    private static class SingleAcquireAndReleaseLock {
        private static final Logger log = LoggerFactory.getLogger(SingleAcquireAndReleaseLock.class);
        private final AtomicBoolean acquired = new AtomicBoolean(false);
        private final Lock lock;

        SingleAcquireAndReleaseLock(Lock lock) {
            this.lock = lock;
        }

        public void lock() {
            if (!this.acquired.compareAndSet(false, true)) {
                throw new IllegalStateException("Lock was already acquired!");
            }
            this.lock.lock();
        }

        public void unlockIfNeeded() {
            if (this.acquired.compareAndSet(true, false)) {
                this.lock.unlock();
            }
        }
    }

    private static class PersistentWatcher {
        final String path;
        final Watcher watcher;
        final AddWatchMode mode;

        public String getPath() {
            return this.path;
        }

        public Watcher getWatcher() {
            return this.watcher;
        }

        public AddWatchMode getMode() {
            return this.mode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PersistentWatcher)) {
                return false;
            }
            PersistentWatcher other = (PersistentWatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Watcher this$watcher = this.getWatcher();
            Watcher other$watcher = other.getWatcher();
            if (this$watcher == null ? other$watcher != null : !this$watcher.equals(other$watcher)) {
                return false;
            }
            AddWatchMode this$mode = this.getMode();
            AddWatchMode other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PersistentWatcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Watcher $watcher = this.getWatcher();
            result = result * 59 + ($watcher == null ? 43 : $watcher.hashCode());
            AddWatchMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            return result;
        }

        public String toString() {
            return "MockZooKeeper.PersistentWatcher(path=" + this.getPath() + ", watcher=" + this.getWatcher() + ", mode=" + this.getMode() + ")";
        }

        public PersistentWatcher(String path, Watcher watcher, AddWatchMode mode) {
            this.path = path;
            this.watcher = watcher;
            this.mode = mode;
        }
    }

    private static class Failure {
        final KeeperException.Code failReturnCode;
        final BiPredicate<Op, String> predicate;

        Failure(KeeperException.Code failReturnCode, BiPredicate<Op, String> predicate) {
            this.failReturnCode = failReturnCode;
            this.predicate = predicate;
        }
    }

    public static enum Op {
        CREATE,
        GET,
        SET,
        GET_CHILDREN,
        DELETE,
        EXISTS,
        SYNC;

    }

    private static class MockZNode {
        byte[] content;
        int version;
        long ephemeralOwner;

        static MockZNode of(byte[] content, int version, long ephemeralOwner) {
            return new MockZNode(content, version, ephemeralOwner);
        }

        public byte[] getContent() {
            return this.content;
        }

        public int getVersion() {
            return this.version;
        }

        public long getEphemeralOwner() {
            return this.ephemeralOwner;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void setEphemeralOwner(long ephemeralOwner) {
            this.ephemeralOwner = ephemeralOwner;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MockZNode)) {
                return false;
            }
            MockZNode other = (MockZNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            if (this.getEphemeralOwner() != other.getEphemeralOwner()) {
                return false;
            }
            return Arrays.equals(this.getContent(), other.getContent());
        }

        protected boolean canEqual(Object other) {
            return other instanceof MockZNode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            long $ephemeralOwner = this.getEphemeralOwner();
            result = result * 59 + (int)($ephemeralOwner >>> 32 ^ $ephemeralOwner);
            result = result * 59 + Arrays.hashCode(this.getContent());
            return result;
        }

        public String toString() {
            return "MockZooKeeper.MockZNode(content=" + Arrays.toString(this.getContent()) + ", version=" + this.getVersion() + ", ephemeralOwner=" + this.getEphemeralOwner() + ")";
        }

        public MockZNode(byte[] content, int version, long ephemeralOwner) {
            this.content = content;
            this.version = version;
            this.ephemeralOwner = ephemeralOwner;
        }
    }
}

