/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockZooKeeper
extends ZooKeeper {
    private TreeMap<String, Pair<byte[], Integer>> tree;
    private SetMultimap<String, Watcher> watchers;
    private volatile boolean stopped;
    private AtomicReference<KeeperException.Code> alwaysFail;
    private CopyOnWriteArrayList<Failure> failures;
    private ExecutorService executor;
    private Watcher sessionWatcher;
    private long sessionId = 0L;
    private int readOpDelayMs;
    private ReentrantLock mutex;
    private AtomicLong sequentialIdGenerator;
    private static final Objenesis objenesis = new ObjenesisStd();
    private List<PersistentWatcher> persistentWatchers;
    private static final Logger log = LoggerFactory.getLogger(MockZooKeeper.class);

    public static MockZooKeeper newInstance() {
        return MockZooKeeper.newInstance(null);
    }

    public static MockZooKeeper newInstance(ExecutorService executor) {
        return MockZooKeeper.newInstance(executor, -1);
    }

    public static MockZooKeeper newInstanceForGlobalZK(ExecutorService executor) {
        return MockZooKeeper.newInstanceForGlobalZK(executor, -1);
    }

    public static MockZooKeeper newInstanceForGlobalZK(ExecutorService executor, int readOpDelayMs) {
        try {
            ObjectInstantiator mockZooKeeperInstantiator = new ObjenesisStd().getInstantiatorOf(MockZooKeeper.class);
            MockZooKeeper zk = (MockZooKeeper)((Object)mockZooKeeperInstantiator.newInstance());
            zk.init(executor);
            zk.readOpDelayMs = readOpDelayMs;
            zk.mutex = new ReentrantLock();
            zk.sequentialIdGenerator = new AtomicLong();
            return zk;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create object", e);
        }
    }

    public static MockZooKeeper newInstance(ExecutorService executor, int readOpDelayMs) {
        try {
            ObjectInstantiator mockZooKeeperInstantiator = objenesis.getInstantiatorOf(MockZooKeeper.class);
            MockZooKeeper zk = (MockZooKeeper)((Object)mockZooKeeperInstantiator.newInstance());
            zk.init(executor);
            zk.readOpDelayMs = readOpDelayMs;
            zk.mutex = new ReentrantLock();
            ObjectInstantiator clientCnxnObjectInstantiator = objenesis.getInstantiatorOf(ClientCnxn.class);
            Whitebox.setInternalState((Object)((Object)zk), (String)"cnxn", (Object)clientCnxnObjectInstantiator.newInstance());
            zk.sequentialIdGenerator = new AtomicLong();
            return zk;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create object", e);
        }
    }

    private void init(ExecutorService executor) {
        this.tree = Maps.newTreeMap();
        this.executor = executor != null ? executor : Executors.newFixedThreadPool(1, (ThreadFactory)new DefaultThreadFactory("mock-zookeeper"));
        HashMultimap w = HashMultimap.create();
        this.watchers = Multimaps.synchronizedSetMultimap((SetMultimap)w);
        this.stopped = false;
        this.alwaysFail = new AtomicReference<KeeperException.Code>(KeeperException.Code.OK);
        this.failures = new CopyOnWriteArrayList();
        this.persistentWatchers = new ArrayList<PersistentWatcher>();
    }

    public int getSessionTimeout() {
        return 30000;
    }

    private MockZooKeeper(String quorum) throws Exception {
        super(quorum, 1, event -> {});
        assert (false);
    }

    public ZooKeeper.States getState() {
        return ZooKeeper.States.CONNECTED;
    }

    public void register(Watcher watcher) {
        this.mutex.lock();
        this.sessionWatcher = watcher;
        this.mutex.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        this.mutex.lock();
        HashSet toNotifyCreate = Sets.newHashSet();
        HashSet toNotifyParent = Sets.newHashSet();
        String parent = path.substring(0, path.lastIndexOf("/"));
        try {
            this.maybeThrowProgrammedFailure(Op.CREATE, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (this.tree.containsKey(path)) {
                throw new KeeperException.NodeExistsException(path);
            }
            if (!parent.isEmpty() && !this.tree.containsKey(parent)) {
                throw new KeeperException.NoNodeException();
            }
            if (createMode == CreateMode.EPHEMERAL_SEQUENTIAL || createMode == CreateMode.PERSISTENT_SEQUENTIAL) {
                byte[] parentData = (byte[])this.tree.get(parent).getLeft();
                int parentVersion = (Integer)this.tree.get(parent).getRight();
                path = path + parentVersion;
                this.tree.put(parent, (Pair<byte[], Integer>)Pair.of((Object)parentData, (Object)(parentVersion + 1)));
            }
            this.tree.put(path, (Pair<byte[], Integer>)Pair.of((Object)data, (Object)0));
            toNotifyCreate.addAll(this.watchers.get((Object)path));
            if (!parent.isEmpty()) {
                toNotifyParent.addAll(this.watchers.get((Object)parent));
            }
            this.watchers.removeAll((Object)path);
        }
        finally {
            this.mutex.unlock();
        }
        String finalPath = path;
        this.executor.execute(() -> {
            this.triggerPersistentWatches(finalPath, parent, Watcher.Event.EventType.NodeCreated);
            toNotifyCreate.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, finalPath)));
            toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
        });
        return path;
    }

    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.mutex.lock();
            if (this.stopped) {
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                return;
            }
            HashSet toNotifyCreate = Sets.newHashSet();
            toNotifyCreate.addAll(this.watchers.get((Object)path));
            HashSet toNotifyParent = Sets.newHashSet();
            String parent = path.substring(0, path.lastIndexOf("/"));
            if (!parent.isEmpty()) {
                toNotifyParent.addAll(this.watchers.get((Object)parent));
            }
            String name = createMode != null && createMode.isSequential() ? path + Long.toString(this.sequentialIdGenerator.getAndIncrement()) : path;
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.CREATE, path);
            if (failure.isPresent()) {
                this.mutex.unlock();
                cb.processResult(failure.get().intValue(), path, ctx, null);
            } else if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
            } else if (this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NODEEXISTS.intValue(), path, ctx, null);
            } else if (!parent.isEmpty() && !this.tree.containsKey(parent)) {
                this.mutex.unlock();
                toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
            } else {
                this.tree.put(name, (Pair<byte[], Integer>)Pair.of((Object)data, (Object)0));
                this.watchers.removeAll((Object)name);
                this.mutex.unlock();
                cb.processResult(0, path, ctx, name);
                this.triggerPersistentWatches(path, parent, Watcher.Event.EventType.NodeCreated);
                toNotifyCreate.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, name)));
                toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException {
        this.mutex.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.GET, path);
            Pair<byte[], Integer> value = this.tree.get(path);
            if (value == null) {
                throw new KeeperException.NoNodeException(path);
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            if (stat != null) {
                stat.setVersion(((Integer)value.getRight()).intValue());
            }
            byte[] byArray = (byte[])value.getLeft();
            return byArray;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.executor.execute(() -> {
            Pair<byte[], Integer> value;
            this.checkReadOpDelay();
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET, path);
            if (failure.isPresent()) {
                cb.processResult(failure.get().intValue(), path, ctx, null, null);
                return;
            }
            if (this.stopped) {
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
                return;
            }
            this.mutex.lock();
            try {
                value = this.tree.get(path);
            }
            finally {
                this.mutex.unlock();
            }
            if (value == null) {
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
            } else {
                Stat stat = new Stat();
                stat.setVersion(((Integer)value.getRight()).intValue());
                cb.processResult(0, path, ctx, (byte[])value.getLeft(), stat);
            }
        });
    }

    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.checkReadOpDelay();
            this.mutex.lock();
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET, path);
            if (failure.isPresent()) {
                this.mutex.unlock();
                cb.processResult(failure.get().intValue(), path, ctx, null, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
                return;
            }
            Pair<byte[], Integer> value = this.tree.get(path);
            if (value == null) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
            } else {
                if (watcher != null) {
                    this.watchers.put((Object)path, (Object)watcher);
                }
                Stat stat = new Stat();
                stat.setVersion(((Integer)value.getRight()).intValue());
                this.mutex.unlock();
                cb.processResult(0, path, ctx, (byte[])value.getLeft(), stat);
            }
        });
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.mutex.lock();
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET_CHILDREN, path);
            if (failure.isPresent()) {
                this.mutex.unlock();
                cb.processResult(failure.get().intValue(), path, ctx, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                return;
            }
            if (!this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                return;
            }
            ArrayList children = Lists.newArrayList();
            for (String item : this.tree.tailMap(path).keySet()) {
                if (!item.startsWith(path)) break;
                if (path.length() >= item.length()) continue;
                String child = item.substring(path.length() + 1);
                if (item.charAt(path.length()) != '/' || child.contains("/")) continue;
                children.add(child);
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            this.mutex.unlock();
            cb.processResult(0, path, ctx, (List)children);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path, Watcher watcher) throws KeeperException {
        this.mutex.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.GET_CHILDREN, path);
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException();
            }
            ArrayList children = Lists.newArrayList();
            for (String item : this.tree.tailMap(path).keySet()) {
                String child;
                if (!item.startsWith(path)) break;
                if (path.length() >= item.length() || (child = item.substring(path.length() + 1)).contains("/")) continue;
                children.add(child);
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            ArrayList arrayList = children;
            return arrayList;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        this.mutex.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.GET_CHILDREN, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException();
            }
            ArrayList children = Lists.newArrayList();
            for (String item : this.tree.tailMap(path).keySet()) {
                String child;
                if (!item.startsWith(path)) break;
                if (path.length() >= item.length() || (child = item.substring(path.length())).indexOf("/") != 0) continue;
                child = child.substring(1);
                log.debug("child: '{}'", (Object)child);
                if (child.contains("/")) continue;
                children.add(child);
            }
            ArrayList arrayList = children;
            return arrayList;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void getChildren(String path, boolean watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        this.executor.execute(() -> {
            this.mutex.lock();
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET_CHILDREN, path);
            if (failure.isPresent()) {
                this.mutex.unlock();
                cb.processResult(failure.get().intValue(), path, ctx, null, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
                return;
            }
            if (!this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
                return;
            }
            log.debug("getChildren path={}", (Object)path);
            ArrayList children = Lists.newArrayList();
            for (String item : this.tree.tailMap(path).keySet()) {
                String child;
                log.debug("Checking path {}", (Object)item);
                if (!item.startsWith(path)) break;
                if (item.equals(path) || (child = item.substring(path.length())).indexOf("/") != 0) continue;
                child = child.substring(1);
                log.debug("child: '{}'", (Object)child);
                if (child.contains("/")) continue;
                children.add(child);
            }
            log.debug("getChildren done path={} result={}", (Object)path, (Object)children);
            this.mutex.unlock();
            cb.processResult(0, path, ctx, (List)children, new Stat());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        this.mutex.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.EXISTS, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (this.tree.containsKey(path)) {
                Stat stat = new Stat();
                stat.setVersion(((Integer)this.tree.get(path).getRight()).intValue());
                Stat stat2 = stat;
                return stat2;
            }
            Stat stat = null;
            return stat;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        this.mutex.lock();
        try {
            this.maybeThrowProgrammedFailure(Op.EXISTS, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            if (this.tree.containsKey(path)) {
                Stat stat = new Stat();
                stat.setVersion(((Integer)this.tree.get(path).getRight()).intValue());
                Stat stat2 = stat;
                return stat2;
            }
            Stat stat = null;
            return stat;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.mutex.lock();
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.EXISTS, path);
            if (failure.isPresent()) {
                this.mutex.unlock();
                cb.processResult(failure.get().intValue(), path, ctx, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                return;
            }
            if (this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(0, path, ctx, new Stat());
            } else {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
            }
        });
    }

    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.mutex.lock();
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.EXISTS, path);
            if (failure.isPresent()) {
                this.mutex.unlock();
                cb.processResult(failure.get().intValue(), path, ctx, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                return;
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            if (this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(0, path, ctx, new Stat());
            } else {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
            }
        });
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        this.executor.execute(() -> {
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.SYNC, path);
            if (failure.isPresent()) {
                cb.processResult(failure.get().intValue(), path, ctx);
                return;
            }
            if (this.stopped) {
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx);
                return;
            }
            cb.processResult(0, path, ctx);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        int newVersion;
        this.mutex.lock();
        HashSet toNotify = Sets.newHashSet();
        try {
            this.maybeThrowProgrammedFailure(Op.SET, path);
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException();
            }
            int currentVersion = (Integer)this.tree.get(path).getRight();
            if (version != -1 && version != currentVersion) {
                throw new KeeperException.BadVersionException(path);
            }
            newVersion = currentVersion + 1;
            log.debug("[{}] Updating -- current version: {}", (Object)path, (Object)currentVersion);
            this.tree.put(path, (Pair<byte[], Integer>)Pair.of((Object)data, (Object)newVersion));
            toNotify.addAll(this.watchers.get((Object)path));
            this.watchers.removeAll((Object)path);
        }
        finally {
            this.mutex.unlock();
        }
        this.executor.execute(() -> {
            this.triggerPersistentWatches(path, null, Watcher.Event.EventType.NodeDataChanged);
            toNotify.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path)));
        });
        Stat stat = new Stat();
        stat.setVersion(newVersion);
        return stat;
    }

    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        if (this.stopped) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
            return;
        }
        this.executor.execute(() -> {
            HashSet toNotify = Sets.newHashSet();
            this.mutex.lock();
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.SET, path);
            if (failure.isPresent()) {
                this.mutex.unlock();
                cb.processResult(failure.get().intValue(), path, ctx, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                return;
            }
            if (!this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                return;
            }
            int currentVersion = (Integer)this.tree.get(path).getRight();
            if (version != -1 && version != currentVersion) {
                log.debug("[{}] Current version: {} -- Expected: {}", new Object[]{path, currentVersion, version});
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.BADVERSION.intValue(), path, ctx, null);
                return;
            }
            int newVersion = currentVersion + 1;
            log.debug("[{}] Updating -- current version: {}", (Object)path, (Object)currentVersion);
            this.tree.put(path, (Pair<byte[], Integer>)Pair.of((Object)data, (Object)newVersion));
            Stat stat = new Stat();
            stat.setVersion(newVersion);
            this.mutex.unlock();
            cb.processResult(0, path, ctx, stat);
            toNotify.addAll(this.watchers.get((Object)path));
            this.watchers.removeAll((Object)path);
            for (Watcher watcher : toNotify) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path));
            }
            this.triggerPersistentWatches(path, null, Watcher.Event.EventType.NodeDataChanged);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        String parent;
        HashSet toNotifyParent;
        HashSet toNotifyDelete;
        this.maybeThrowProgrammedFailure(Op.DELETE, path);
        this.mutex.lock();
        try {
            int currentVersion;
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException(path);
            }
            if (this.hasChildren(path)) {
                throw new KeeperException.NotEmptyException(path);
            }
            if (version != -1 && version != (currentVersion = ((Integer)this.tree.get(path).getRight()).intValue())) {
                throw new KeeperException.BadVersionException(path);
            }
            this.tree.remove(path);
            toNotifyDelete = Sets.newHashSet();
            toNotifyDelete.addAll(this.watchers.get((Object)path));
            toNotifyParent = Sets.newHashSet();
            parent = path.substring(0, path.lastIndexOf("/"));
            if (!parent.isEmpty()) {
                toNotifyParent.addAll(this.watchers.get((Object)parent));
            }
            this.watchers.removeAll((Object)path);
        }
        finally {
            this.mutex.unlock();
        }
        this.executor.execute(() -> {
            if (this.stopped) {
                return;
            }
            for (Watcher watcher1 : toNotifyDelete) {
                watcher1.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path));
            }
            for (Watcher watcher2 : toNotifyParent) {
                watcher2.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent));
            }
            this.triggerPersistentWatches(path, parent, Watcher.Event.EventType.NodeDeleted);
        });
    }

    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        Runnable r = () -> {
            this.mutex.lock();
            HashSet toNotifyDelete = Sets.newHashSet();
            toNotifyDelete.addAll(this.watchers.get((Object)path));
            HashSet toNotifyParent = Sets.newHashSet();
            String parent = path.substring(0, path.lastIndexOf("/"));
            if (!parent.isEmpty()) {
                toNotifyParent.addAll(this.watchers.get((Object)parent));
            }
            this.watchers.removeAll((Object)path);
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.DELETE, path);
            if (failure.isPresent()) {
                this.mutex.unlock();
                cb.processResult(failure.get().intValue(), path, ctx);
            } else if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx);
            } else if (!this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx);
            } else if (this.hasChildren(path)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NOTEMPTY.intValue(), path, ctx);
            } else {
                int currentVersion;
                if (version != -1 && version != (currentVersion = ((Integer)this.tree.get(path).getRight()).intValue())) {
                    this.mutex.unlock();
                    cb.processResult(KeeperException.Code.BADVERSION.intValue(), path, ctx);
                    return;
                }
                this.tree.remove(path);
                this.mutex.unlock();
                cb.processResult(0, path, ctx);
                toNotifyDelete.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path)));
                toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
                this.triggerPersistentWatches(path, parent, Watcher.Event.EventType.NodeDeleted);
            }
        };
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException ree) {
            cb.processResult(KeeperException.Code.SESSIONEXPIRED.intValue(), path, ctx);
            return;
        }
    }

    public void multi(Iterable<org.apache.zookeeper.Op> ops, AsyncCallback.MultiCallback cb, Object ctx) {
        try {
            List<OpResult> res = this.multi(ops);
            cb.processResult(KeeperException.Code.OK.intValue(), (String)null, ctx, res);
        }
        catch (Exception e) {
            cb.processResult(KeeperException.Code.APIERROR.intValue(), (String)null, ctx, null);
        }
    }

    public List<OpResult> multi(Iterable<org.apache.zookeeper.Op> ops) throws InterruptedException, KeeperException {
        ArrayList<OpResult> res = new ArrayList<OpResult>();
        for (org.apache.zookeeper.Op op : ops) {
            switch (op.getType()) {
                case 1: {
                    this.create(op.getPath(), ((Op.Create)op).data, null, null);
                    res.add((OpResult)new OpResult.CreateResult(op.getPath()));
                }
                case 2: {
                    this.delete(op.getPath(), -1);
                    res.add((OpResult)new OpResult.DeleteResult());
                }
                case 5: {
                    this.create(op.getPath(), ((Op.Create)op).data, null, null);
                    res.add((OpResult)new OpResult.SetDataResult(null));
                }
            }
        }
        return res;
    }

    public synchronized void addWatch(String basePath, Watcher watcher, AddWatchMode mode) {
        this.persistentWatchers.add(new PersistentWatcher(basePath, watcher, mode));
    }

    public void addWatch(String basePath, Watcher watcher, AddWatchMode mode, AsyncCallback.VoidCallback cb, Object ctx) {
        if (this.stopped) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), basePath, ctx);
            return;
        }
        this.executor.execute(() -> {
            MockZooKeeper mockZooKeeper = this;
            synchronized (mockZooKeeper) {
                this.persistentWatchers.add(new PersistentWatcher(basePath, watcher, mode));
            }
            cb.processResult(KeeperException.Code.OK.intValue(), basePath, ctx);
        });
    }

    public void close() throws InterruptedException {
    }

    public void shutdown() throws InterruptedException {
        this.mutex.lock();
        try {
            this.stopped = true;
            this.tree.clear();
            this.watchers.clear();
            try {
                this.executor.shutdownNow();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                log.error("MockZooKeeper shutdown had error", (Throwable)ex);
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    Optional<KeeperException.Code> programmedFailure(Op op, String path) {
        KeeperException.Code error = this.alwaysFail.get();
        if (error != KeeperException.Code.OK) {
            return Optional.of(error);
        }
        Optional<Failure> failure = this.failures.stream().filter(f -> f.predicate.test(op, path)).findFirst();
        if (failure.isPresent()) {
            this.failures.remove(failure.get());
            return Optional.of(failure.get().failReturnCode);
        }
        return Optional.empty();
    }

    void maybeThrowProgrammedFailure(Op op, String path) throws KeeperException {
        Optional<KeeperException.Code> failure = this.programmedFailure(op, path);
        if (failure.isPresent()) {
            throw KeeperException.create((KeeperException.Code)failure.get());
        }
    }

    public void failConditional(KeeperException.Code rc, BiPredicate<Op, String> predicate) {
        this.failures.add(new Failure(rc, predicate));
    }

    public void setAlwaysFail(KeeperException.Code rc) {
        this.alwaysFail.set(rc);
    }

    public void unsetAlwaysFail() {
        this.alwaysFail.set(KeeperException.Code.OK);
    }

    public void setSessionId(long id) {
        this.sessionId = id;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    private boolean hasChildren(String path) {
        return !this.tree.subMap(path + '/', path + '0').isEmpty();
    }

    public String toString() {
        return "MockZookeeper";
    }

    private void checkReadOpDelay() {
        if (this.readOpDelayMs > 0) {
            try {
                Thread.sleep(this.readOpDelayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void triggerPersistentWatches(String path, String parent, Watcher.Event.EventType eventType) {
        this.persistentWatchers.forEach(w -> {
            if (w.mode == AddWatchMode.PERSISTENT_RECURSIVE) {
                if (path.startsWith(w.getPath())) {
                    w.watcher.process(new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, path));
                }
            } else if (w.mode == AddWatchMode.PERSISTENT) {
                if (w.getPath().equals(path)) {
                    w.watcher.process(new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, path));
                }
                if (eventType == Watcher.Event.EventType.NodeCreated || eventType == Watcher.Event.EventType.NodeDeleted) {
                    w.watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent));
                }
            }
        });
    }

    private static class PersistentWatcher {
        final String path;
        final Watcher watcher;
        final AddWatchMode mode;

        public String getPath() {
            return this.path;
        }

        public Watcher getWatcher() {
            return this.watcher;
        }

        public AddWatchMode getMode() {
            return this.mode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PersistentWatcher)) {
                return false;
            }
            PersistentWatcher other = (PersistentWatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Watcher this$watcher = this.getWatcher();
            Watcher other$watcher = other.getWatcher();
            if (this$watcher == null ? other$watcher != null : !this$watcher.equals(other$watcher)) {
                return false;
            }
            AddWatchMode this$mode = this.getMode();
            AddWatchMode other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PersistentWatcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Watcher $watcher = this.getWatcher();
            result = result * 59 + ($watcher == null ? 43 : $watcher.hashCode());
            AddWatchMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            return result;
        }

        public String toString() {
            return "MockZooKeeper.PersistentWatcher(path=" + this.getPath() + ", watcher=" + this.getWatcher() + ", mode=" + this.getMode() + ")";
        }

        public PersistentWatcher(String path, Watcher watcher, AddWatchMode mode) {
            this.path = path;
            this.watcher = watcher;
            this.mode = mode;
        }
    }

    private class Failure {
        final KeeperException.Code failReturnCode;
        final BiPredicate<Op, String> predicate;

        Failure(KeeperException.Code failReturnCode, BiPredicate<Op, String> predicate) {
            this.failReturnCode = failReturnCode;
            this.predicate = predicate;
        }
    }

    public static enum Op {
        CREATE,
        GET,
        SET,
        GET_CHILDREN,
        DELETE,
        EXISTS,
        SYNC;

    }
}

