/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PulsarMockLedgerHandle;
import org.apache.bookkeeper.client.PulsarMockReadHandle;
import org.apache.bookkeeper.client.api.DeleteBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.OpenBuilder;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.impl.OpenBuilderBase;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarMockBookKeeper
extends BookKeeper {
    final ExecutorService executor;
    final ZooKeeper zkc;
    Map<Long, PulsarMockLedgerHandle> ledgers = new ConcurrentHashMap<Long, PulsarMockLedgerHandle>();
    AtomicLong sequence = new AtomicLong(3L);
    CompletableFuture<Void> defaultResponse = CompletableFuture.completedFuture(null);
    List<CompletableFuture<Void>> failures = new ArrayList<CompletableFuture<Void>>();
    private int emptyLedgerAfter = -1;
    private static final Logger log = LoggerFactory.getLogger(PulsarMockBookKeeper.class);

    public ZooKeeper getZkHandle() {
        return this.zkc;
    }

    public ClientConfiguration getConf() {
        return super.getConf();
    }

    public PulsarMockBookKeeper(ZooKeeper zkc, ExecutorService executor) throws Exception {
        this.zkc = zkc;
        this.executor = executor;
    }

    public LedgerHandle createLedger(BookKeeper.DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        return this.createLedger(3, 2, digestType, passwd);
    }

    public LedgerHandle createLedger(int ensSize, int qSize, BookKeeper.DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        return this.createLedger(ensSize, qSize, qSize, digestType, passwd);
    }

    public void asyncCreateLedger(int ensSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx, Map<String, byte[]> properties) {
        ((CompletableFuture)this.getProgrammedFailure().thenComposeAsync(res -> {
            try {
                long id = this.sequence.getAndIncrement();
                log.info("Creating ledger {}", (Object)id);
                PulsarMockLedgerHandle lh = new PulsarMockLedgerHandle(this, id, digestType, passwd);
                this.ledgers.put(id, lh);
                return FutureUtils.value((Object)((Object)lh));
            }
            catch (Throwable t) {
                return FutureUtils.exception((Throwable)t);
            }
        }, (Executor)this.executor)).whenCompleteAsync((lh, exception) -> {
            if (exception != null) {
                cb.createComplete(PulsarMockBookKeeper.getExceptionCode(exception), null, ctx);
            } else {
                cb.createComplete(0, (LedgerHandle)lh, ctx);
            }
        }, (Executor)this.executor);
    }

    public LedgerHandle createLedger(int ensSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        this.checkProgrammedFail();
        try {
            long id = this.sequence.getAndIncrement();
            log.info("Creating ledger {}", (Object)id);
            PulsarMockLedgerHandle lh = new PulsarMockLedgerHandle(this, id, digestType, passwd);
            this.ledgers.put(id, lh);
            return lh;
        }
        catch (Throwable t) {
            log.error("Exception:", t);
            return null;
        }
    }

    public void asyncCreateLedger(int ensSize, int qSize, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) {
        this.asyncCreateLedger(ensSize, qSize, qSize, digestType, passwd, cb, ctx, Collections.emptyMap());
    }

    public void asyncOpenLedger(long lId, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        ((CompletableFuture)this.getProgrammedFailure().thenComposeAsync(res -> {
            PulsarMockLedgerHandle lh = this.ledgers.get(lId);
            if (lh == null) {
                return FutureUtils.exception((Throwable)new BKException.BKNoSuchLedgerExistsException());
            }
            if (lh.digest != digestType) {
                return FutureUtils.exception((Throwable)new BKException.BKDigestMatchException());
            }
            if (!Arrays.equals(lh.passwd, passwd)) {
                return FutureUtils.exception((Throwable)new BKException.BKUnauthorizedAccessException());
            }
            return FutureUtils.value((Object)((Object)lh));
        }, (Executor)this.executor)).whenCompleteAsync((ledger, exception) -> {
            if (exception != null) {
                cb.openComplete(PulsarMockBookKeeper.getExceptionCode(exception), null, ctx);
            } else {
                cb.openComplete(0, (LedgerHandle)ledger, ctx);
            }
        }, (Executor)this.executor);
    }

    public void asyncOpenLedgerNoRecovery(long lId, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        this.asyncOpenLedger(lId, digestType, passwd, cb, ctx);
    }

    public void asyncDeleteLedger(long lId, AsyncCallback.DeleteCallback cb, Object ctx) {
        ((CompletableFuture)this.getProgrammedFailure().thenComposeAsync(res -> {
            if (this.ledgers.containsKey(lId)) {
                this.ledgers.remove(lId);
                return FutureUtils.value(null);
            }
            return FutureUtils.exception((Throwable)new BKException.BKNoSuchLedgerExistsException());
        }, (Executor)this.executor)).whenCompleteAsync((res, exception) -> {
            if (exception != null) {
                cb.deleteComplete(PulsarMockBookKeeper.getExceptionCode(exception), ctx);
            } else {
                cb.deleteComplete(0, ctx);
            }
        }, (Executor)this.executor);
    }

    public void deleteLedger(long lId) throws InterruptedException, BKException {
        this.checkProgrammedFail();
        if (!this.ledgers.containsKey(lId)) {
            throw BKException.create((int)-7);
        }
        this.ledgers.remove(lId);
    }

    public void close() throws InterruptedException, BKException {
        this.shutdown();
    }

    public OpenBuilder newOpenLedgerOp() {
        return new OpenBuilderBase(){

            public CompletableFuture<ReadHandle> execute() {
                return PulsarMockBookKeeper.this.getProgrammedFailure().thenCompose(res -> {
                    int rc = this.validate();
                    if (rc != 0) {
                        return FutureUtils.exception((Throwable)BKException.create((int)rc));
                    }
                    PulsarMockLedgerHandle lh = PulsarMockBookKeeper.this.ledgers.get(this.ledgerId);
                    if (lh == null) {
                        return FutureUtils.exception((Throwable)new BKException.BKNoSuchLedgerExistsException());
                    }
                    if (lh.digest != BookKeeper.DigestType.fromApiDigestType((DigestType)this.digestType)) {
                        return FutureUtils.exception((Throwable)new BKException.BKDigestMatchException());
                    }
                    if (!Arrays.equals(lh.passwd, this.password)) {
                        return FutureUtils.exception((Throwable)new BKException.BKUnauthorizedAccessException());
                    }
                    return FutureUtils.value((Object)new PulsarMockReadHandle(PulsarMockBookKeeper.this, this.ledgerId, lh.getLedgerMetadata(), lh.entries));
                });
            }
        };
    }

    public DeleteBuilder newDeleteLedgerOp() {
        return new DeleteBuilder(){
            private long ledgerId;

            public CompletableFuture<Void> execute() {
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                PulsarMockBookKeeper.this.asyncDeleteLedger(this.ledgerId, (res, ctx) -> {
                    if (res == 0) {
                        future.complete(null);
                    } else {
                        future.completeExceptionally(BKException.create((int)res));
                    }
                }, null);
                return future;
            }

            public DeleteBuilder withLedgerId(long ledgerId) {
                this.ledgerId = ledgerId;
                return this;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PulsarMockBookKeeper pulsarMockBookKeeper = this;
        synchronized (pulsarMockBookKeeper) {
            this.defaultResponse = FutureUtils.exception((Throwable)new BKException.BKClientClosedException());
        }
        for (PulsarMockLedgerHandle ledger : this.ledgers.values()) {
            ledger.entries.clear();
        }
        this.ledgers.clear();
    }

    public Set<Long> getLedgers() {
        return this.ledgers.keySet();
    }

    public Map<Long, PulsarMockLedgerHandle> getLedgerMap() {
        return this.ledgers;
    }

    void checkProgrammedFail() throws BKException, InterruptedException {
        try {
            this.getProgrammedFailure().get();
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof BKException) {
                throw (BKException)ee.getCause();
            }
            throw new BKException.BKUnexpectedConditionException();
        }
    }

    synchronized boolean checkReturnEmptyLedger() {
        boolean shouldFailNow = this.emptyLedgerAfter == 0;
        --this.emptyLedgerAfter;
        return shouldFailNow;
    }

    synchronized CompletableFuture<Void> getProgrammedFailure() {
        return this.failures.isEmpty() ? this.defaultResponse : this.failures.remove(0);
    }

    public void failNow(int rc) {
        this.failAfter(0, rc);
    }

    public void failAfter(int steps, int rc) {
        this.promiseAfter(steps).completeExceptionally(BKException.create((int)rc));
    }

    public synchronized void returnEmptyLedgerAfter(int steps) {
        this.emptyLedgerAfter = steps;
    }

    public synchronized CompletableFuture<Void> promiseAfter(int steps) {
        while (this.failures.size() <= steps) {
            this.failures.add(this.defaultResponse);
        }
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.failures.set(steps, promise);
        return promise;
    }

    static int getExceptionCode(Throwable t) {
        if (t instanceof BKException) {
            return ((BKException)t).getCode();
        }
        if (t.getCause() != null) {
            return PulsarMockBookKeeper.getExceptionCode(t.getCause());
        }
        return -999;
    }
}

