/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.grpc;

import io.grpc.HandlerRegistry;
import io.grpc.util.MutableHandlerRegistry;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.server.StorageServer;
import org.apache.bookkeeper.stream.server.conf.StorageServerConfiguration;
import org.apache.bookkeeper.stream.server.grpc.GrpcServer;
import org.apache.bookkeeper.stream.storage.api.StorageContainerStore;
import org.apache.bookkeeper.stream.storage.impl.StorageContainerStoreImpl;
import org.apache.commons.configuration.CompositeConfiguration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;

public class TestGrpcServer {
    @Rule
    public TestName name = new TestName();
    private final CompositeConfiguration compConf = new CompositeConfiguration();

    @Test
    public void testCreateLocalServer() {
        GrpcServer server = new GrpcServer((StorageContainerStore)Mockito.mock(StorageContainerStoreImpl.class), StorageServerConfiguration.of((CompositeConfiguration)this.compConf), null, this.name.getMethodName(), (HandlerRegistry)new MutableHandlerRegistry(), (StatsLogger)NullStatsLogger.INSTANCE);
        server.start();
        Assert.assertEquals((long)-1L, (long)server.getGrpcServer().getPort());
        server.close();
    }

    @Test
    public void testCreateBindServer() throws Exception {
        GrpcServer server = new GrpcServer((StorageContainerStore)Mockito.mock(StorageContainerStoreImpl.class), StorageServerConfiguration.of((CompositeConfiguration)this.compConf), StorageServer.createLocalEndpoint((int)0, (boolean)false), null, null, (StatsLogger)NullStatsLogger.INSTANCE);
        server.start();
        Assert.assertTrue((server.getGrpcServer().getPort() > 0 ? 1 : 0) != 0);
        server.close();
    }
}

