/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.protocol.util;

import org.apache.bookkeeper.stream.proto.NamespaceConfiguration;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.apache.bookkeeper.stream.proto.StreamMetadata;
import org.apache.bookkeeper.stream.proto.storage.CreateNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.DeleteNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.GetNamespaceRequest;
import org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.apache.bookkeeper.stream.protocol.util.ProtoUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestProtoUtils {
    @Rule
    public final TestName name = new TestName();

    @Test
    public void testValidateNamespaceName() {
        Assert.assertTrue((boolean)ProtoUtils.validateNamespaceName((String)"namespace_name"));
        Assert.assertTrue((boolean)ProtoUtils.validateNamespaceName((String)"NamespaceName"));
        Assert.assertTrue((boolean)ProtoUtils.validateNamespaceName((String)"9NamespaceName"));
        Assert.assertTrue((boolean)ProtoUtils.validateNamespaceName((String)"namespace-name"));
        Assert.assertTrue((boolean)ProtoUtils.validateNamespaceName((String)"!namespace_name"));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName((String)" namespace_name"));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName((String)"<namespace_name"));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName((String)">namespace_name"));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName((String)""));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName(null));
    }

    @Test
    public void testValidateStreamName() {
        Assert.assertTrue((boolean)ProtoUtils.validateStreamName((String)"stream_name"));
        Assert.assertTrue((boolean)ProtoUtils.validateStreamName((String)"StreamName"));
        Assert.assertTrue((boolean)ProtoUtils.validateStreamName((String)"9StreamName"));
        Assert.assertTrue((boolean)ProtoUtils.validateStreamName((String)"stream-name"));
        Assert.assertTrue((boolean)ProtoUtils.validateStreamName((String)"!stream_name"));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName((String)" stream_name"));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName((String)"<stream_name"));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName((String)">stream_name"));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName((String)""));
        Assert.assertFalse((boolean)ProtoUtils.validateNamespaceName(null));
    }

    @Test
    public void testKeyRangeOverlaps1() {
        Assert.assertFalse((boolean)ProtoUtils.keyRangeOverlaps((long)1000L, (long)2000L, (long)3000L, (long)4000L));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((long)1000L, (long)2000L, (long)1500L, (long)2500L));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((long)1000L, (long)2000L, (long)1500L, (long)1800L));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((long)1000L, (long)3500L, (long)3000L, (long)4000L));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((long)3200L, (long)3500L, (long)3000L, (long)4000L));
    }

    @Test
    public void testKeyRangeOverlaps2() {
        Assert.assertFalse((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)1000L, (Object)2000L), (Pair)Pair.of((Object)3000L, (Object)4000L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)1000L, (Object)2000L), (Pair)Pair.of((Object)1500L, (Object)2500L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)1000L, (Object)2000L), (Pair)Pair.of((Object)1500L, (Object)1800L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)1000L, (Object)3500L), (Pair)Pair.of((Object)3000L, (Object)4000L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)3200L, (Object)3500L), (Pair)Pair.of((Object)3000L, (Object)4000L)));
    }

    private static RangeProperties createRangeMeta(long startKey, long endKey) {
        return RangeProperties.newBuilder().setStartHashKey(startKey).setEndHashKey(endKey).setStorageContainerId(1234L).setRangeId(1234L).build();
    }

    @Test
    public void testKeyRangeOverlaps3() {
        Assert.assertFalse((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(1000L, 2000L), (RangeProperties)TestProtoUtils.createRangeMeta(3000L, 4000L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(1000L, 2000L), (RangeProperties)TestProtoUtils.createRangeMeta(1500L, 2500L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(1000L, 2000L), (RangeProperties)TestProtoUtils.createRangeMeta(1500L, 1800L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(1000L, 3500L), (RangeProperties)TestProtoUtils.createRangeMeta(3000L, 4000L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(3200L, 3500L), (RangeProperties)TestProtoUtils.createRangeMeta(3000L, 4000L)));
    }

    @Test
    public void testKeyRangeOverlaps4() {
        Assert.assertFalse((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(1000L, 2000L), (Pair)Pair.of((Object)3000L, (Object)4000L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(1000L, 2000L), (Pair)Pair.of((Object)1500L, (Object)2500L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(1000L, 2000L), (Pair)Pair.of((Object)1500L, (Object)1800L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(1000L, 3500L), (Pair)Pair.of((Object)3000L, (Object)4000L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((RangeProperties)TestProtoUtils.createRangeMeta(3200L, 3500L), (Pair)Pair.of((Object)3000L, (Object)4000L)));
    }

    @Test
    public void testKeyRangeOverlaps5() {
        Assert.assertFalse((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)1000L, (Object)2000L), (RangeProperties)TestProtoUtils.createRangeMeta(3000L, 4000L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)1000L, (Object)2000L), (RangeProperties)TestProtoUtils.createRangeMeta(1500L, 2500L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)1000L, (Object)2000L), (RangeProperties)TestProtoUtils.createRangeMeta(1500L, 1800L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)1000L, (Object)3500L), (RangeProperties)TestProtoUtils.createRangeMeta(3000L, 4000L)));
        Assert.assertTrue((boolean)ProtoUtils.keyRangeOverlaps((Pair)Pair.of((Object)3200L, (Object)3500L), (RangeProperties)TestProtoUtils.createRangeMeta(3000L, 4000L)));
    }

    @Test
    public void testIsStreamCreated() {
        Assert.assertFalse((boolean)ProtoUtils.isStreamCreated((StreamMetadata.LifecycleState)StreamMetadata.LifecycleState.UNINIT));
        Assert.assertFalse((boolean)ProtoUtils.isStreamCreated((StreamMetadata.LifecycleState)StreamMetadata.LifecycleState.CREATING));
        Assert.assertTrue((boolean)ProtoUtils.isStreamCreated((StreamMetadata.LifecycleState)StreamMetadata.LifecycleState.CREATED));
        Assert.assertTrue((boolean)ProtoUtils.isStreamCreated((StreamMetadata.LifecycleState)StreamMetadata.LifecycleState.FENCING));
        Assert.assertTrue((boolean)ProtoUtils.isStreamCreated((StreamMetadata.LifecycleState)StreamMetadata.LifecycleState.FENCED));
    }

    @Test
    public void testIsStreamWritable() {
        Assert.assertTrue((boolean)ProtoUtils.isStreamWritable((StreamMetadata.ServingState)StreamMetadata.ServingState.WRITABLE));
        Assert.assertFalse((boolean)ProtoUtils.isStreamWritable((StreamMetadata.ServingState)StreamMetadata.ServingState.READONLY));
    }

    @Test
    public void testCreateCreateNamespaceRequest() {
        NamespaceConfiguration nsConf = NamespaceConfiguration.newBuilder().setDefaultStreamConf(ProtocolConstants.DEFAULT_STREAM_CONF).build();
        CreateNamespaceRequest request = ProtoUtils.createCreateNamespaceRequest((String)this.name.getMethodName(), (NamespaceConfiguration)nsConf);
        Assert.assertEquals((Object)this.name.getMethodName(), (Object)request.getName());
        Assert.assertEquals((Object)nsConf, (Object)request.getNsConf());
    }

    @Test
    public void testCreateDeleteNamespaceRequest() {
        DeleteNamespaceRequest request = ProtoUtils.createDeleteNamespaceRequest((String)this.name.getMethodName());
        Assert.assertEquals((Object)this.name.getMethodName(), (Object)request.getName());
    }

    @Test
    public void testCreateGetNamespaceRequest() {
        GetNamespaceRequest request = ProtoUtils.createGetNamespaceRequest((String)this.name.getMethodName());
        Assert.assertEquals((Object)this.name.getMethodName(), (Object)request.getName());
    }
}

