/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.impl.mvcc.op.proto;

import io.netty.util.Recycler;
import java.util.List;
import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.Op;
import org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.bookkeeper.api.kv.op.TxnOp;
import org.apache.bookkeeper.common.collections.RecyclableArrayList;
import org.apache.bookkeeper.statelib.impl.mvcc.MVCCUtils;
import org.apache.bookkeeper.statelib.impl.mvcc.op.proto.ProtoCompareImpl;
import org.apache.bookkeeper.stream.proto.kv.rpc.Compare;
import org.apache.bookkeeper.stream.proto.kv.rpc.RequestOp;
import org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;

public class ProtoTxnOpImpl
implements TxnOp<byte[], byte[]> {
    private static final Recycler<ProtoTxnOpImpl> RECYCLER = new Recycler<ProtoTxnOpImpl>(){

        protected ProtoTxnOpImpl newObject(Recycler.Handle<ProtoTxnOpImpl> handle) {
            return new ProtoTxnOpImpl(handle);
        }
    };
    private static final RecyclableArrayList.Recycler<CompareOp<byte[], byte[]>> COMPARE_OPS_RECYCLER = new RecyclableArrayList.Recycler();
    private static final RecyclableArrayList.Recycler<Op<byte[], byte[]>> OPS_RECYCLER = new RecyclableArrayList.Recycler();
    private final Recycler.Handle<ProtoTxnOpImpl> recyclerHandle;
    private TxnRequest request;
    private RecyclableArrayList<CompareOp<byte[], byte[]>> compareOps;
    private RecyclableArrayList<Op<byte[], byte[]>> successOps;
    private RecyclableArrayList<Op<byte[], byte[]>> failureOps;

    public static ProtoTxnOpImpl newTxnOp(TxnRequest request) {
        ProtoTxnOpImpl op = (ProtoTxnOpImpl)RECYCLER.get();
        op.setRequest(request);
        RecyclableArrayList compareOps = COMPARE_OPS_RECYCLER.newInstance();
        for (Object compare : request.getCompareList()) {
            compareOps.add((Object)ProtoCompareImpl.newCompareOp((Compare)compare));
        }
        op.setCompareOps((RecyclableArrayList<CompareOp<byte[], byte[]>>)compareOps);
        RecyclableArrayList successOps = OPS_RECYCLER.newInstance();
        for (RequestOp reqOp : request.getSuccessList()) {
            successOps.add(MVCCUtils.toApiOp(reqOp));
        }
        op.setSuccessOps((RecyclableArrayList<Op<byte[], byte[]>>)successOps);
        RecyclableArrayList failureOps = OPS_RECYCLER.newInstance();
        for (RequestOp reqOp : request.getFailureList()) {
            failureOps.add(MVCCUtils.toApiOp(reqOp));
        }
        return op;
    }

    private void reset() {
        this.request = null;
        if (null != this.compareOps) {
            this.compareOps.forEach(CompareOp::close);
            this.compareOps.recycle();
        }
        if (null != this.successOps) {
            this.successOps.forEach(Op::close);
            this.successOps.recycle();
        }
        if (null != this.failureOps) {
            this.failureOps.forEach(Op::close);
            this.failureOps.recycle();
        }
    }

    public List<CompareOp<byte[], byte[]>> compareOps() {
        return this.compareOps;
    }

    public List<Op<byte[], byte[]>> successOps() {
        return this.successOps;
    }

    public List<Op<byte[], byte[]>> failureOps() {
        return this.failureOps;
    }

    public OpType type() {
        return OpType.TXN;
    }

    public void close() {
        this.reset();
        this.recyclerHandle.recycle((Object)this);
    }

    public ProtoTxnOpImpl(Recycler.Handle<ProtoTxnOpImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public String toString() {
        return "ProtoTxnOpImpl(request=" + this.request + ", compareOps=" + this.compareOps + ", successOps=" + this.successOps + ", failureOps=" + this.failureOps + ")";
    }

    private void setRequest(TxnRequest request) {
        this.request = request;
    }

    private void setCompareOps(RecyclableArrayList<CompareOp<byte[], byte[]>> compareOps) {
        this.compareOps = compareOps;
    }

    private void setSuccessOps(RecyclableArrayList<Op<byte[], byte[]>> successOps) {
        this.successOps = successOps;
    }

    private void setFailureOps(RecyclableArrayList<Op<byte[], byte[]>> failureOps) {
        this.failureOps = failureOps;
    }
}

