/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.jute.Record;
import org.apache.pulsar.zookeeper.FinalRequestProcessorAspect;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MultiOperationRecord;
import org.apache.zookeeper.MultiResponse;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.audit.AuditHelper;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.AddWatchRequest;
import org.apache.zookeeper.proto.CheckWatchesRequest;
import org.apache.zookeeper.proto.Create2Response;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.ErrorResponse;
import org.apache.zookeeper.proto.ExistsRequest;
import org.apache.zookeeper.proto.ExistsResponse;
import org.apache.zookeeper.proto.GetACLRequest;
import org.apache.zookeeper.proto.GetACLResponse;
import org.apache.zookeeper.proto.GetAllChildrenNumberRequest;
import org.apache.zookeeper.proto.GetAllChildrenNumberResponse;
import org.apache.zookeeper.proto.GetChildren2Request;
import org.apache.zookeeper.proto.GetChildren2Response;
import org.apache.zookeeper.proto.GetChildrenRequest;
import org.apache.zookeeper.proto.GetChildrenResponse;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.proto.GetDataResponse;
import org.apache.zookeeper.proto.GetEphemeralsRequest;
import org.apache.zookeeper.proto.GetEphemeralsResponse;
import org.apache.zookeeper.proto.RemoveWatchesRequest;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.SetACLResponse;
import org.apache.zookeeper.proto.SetDataResponse;
import org.apache.zookeeper.proto.SetWatches;
import org.apache.zookeeper.proto.SetWatches2;
import org.apache.zookeeper.proto.SyncRequest;
import org.apache.zookeeper.proto.SyncResponse;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import org.apache.zookeeper.server.util.RequestPathMetricsCollector;
import org.apache.zookeeper.txn.ErrorTxn;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalRequestProcessor
implements RequestProcessor {
    private static final Logger LOG;
    private final RequestPathMetricsCollector requestPathMetricsCollector;
    ZooKeeperServer zks;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public FinalRequestProcessor(ZooKeeperServer zks) {
        this.zks = zks;
        this.requestPathMetricsCollector = zks.getRequestPathMetricsCollector();
    }

    @Override
    public void processRequest(Request request) {
        Request request2 = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)request2);
        FinalRequestProcessor.processRequest_aroundBody1$advice(this, request2, joinPoint, FinalRequestProcessorAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private Record handleGetChildrenRequest(Record request, ServerCnxn cnxn, List<Id> authInfo) throws KeeperException, IOException {
        GetChildrenRequest getChildrenRequest = (GetChildrenRequest)request;
        String path = getChildrenRequest.getPath();
        DataNode n = this.zks.getZKDatabase().getNode(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        this.zks.checkACL(cnxn, this.zks.getZKDatabase().aclForNode(n), 1, authInfo, path, null);
        List<String> children = this.zks.getZKDatabase().getChildren(path, null, getChildrenRequest.getWatch() ? cnxn : null);
        return new GetChildrenResponse(children);
    }

    private Record handleGetDataRequest(Record request, ServerCnxn cnxn, List<Id> authInfo) throws KeeperException, IOException {
        GetDataRequest getDataRequest = (GetDataRequest)request;
        String path = getDataRequest.getPath();
        DataNode n = this.zks.getZKDatabase().getNode(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        this.zks.checkACL(cnxn, this.zks.getZKDatabase().aclForNode(n), 1, authInfo, path, null);
        Stat stat = new Stat();
        byte[] b = this.zks.getZKDatabase().getData(path, stat, getDataRequest.getWatch() ? cnxn : null);
        return new GetDataResponse(b, stat);
    }

    private boolean closeSession(ServerCnxnFactory serverCnxnFactory, long sessionId) {
        if (serverCnxnFactory == null) {
            return false;
        }
        return serverCnxnFactory.closeSession(sessionId, ServerCnxn.DisconnectReason.CLIENT_CLOSED_SESSION);
    }

    private boolean connClosedByClient(Request request) {
        return request.cnxn == null;
    }

    @Override
    public void shutdown() {
        LOG.info("shutdown of request processor complete");
    }

    private void updateStats(Request request, String lastOp, long lastZxid) {
        if (request.cnxn == null) {
            return;
        }
        long currentTime = Time.currentElapsedTime();
        this.zks.serverStats().updateLatency(request, currentTime);
        request.cnxn.updateStatsForResponse(request.cxid, lastZxid, lastOp, request.createTime, currentTime);
    }

    static {
        FinalRequestProcessor.ajc$preClinit();
        LOG = LoggerFactory.getLogger(FinalRequestProcessor.class);
    }

    private static final /* synthetic */ void processRequest_aroundBody0(FinalRequestProcessor ajc$this, Request request, JoinPoint joinPoint) {
        long propagationLatency;
        LOG.debug("Processing request:: {}", (Object)request);
        long traceMask = 2L;
        if (request.type == 11) {
            traceMask = 128L;
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logRequest(LOG, traceMask, 'E', request, "");
        }
        DataTree.ProcessTxnResult rc = ajc$this.zks.processTxn(request);
        if (request.type == -11 && ajc$this.connClosedByClient(request) && (ajc$this.closeSession(ajc$this.zks.serverCnxnFactory, request.sessionId) || ajc$this.closeSession(ajc$this.zks.secureServerCnxnFactory, request.sessionId))) {
            return;
        }
        if (request.getHdr() != null && (propagationLatency = Time.currentWallTime() - request.getHdr().getTime()) >= 0L) {
            ServerMetrics.getMetrics().PROPAGATION_LATENCY.add(propagationLatency);
        }
        if (request.cnxn == null) {
            return;
        }
        ServerCnxn cnxn = request.cnxn;
        long lastZxid = ajc$this.zks.getZKDatabase().getDataTreeLastProcessedZxid();
        String lastOp = "NA";
        ajc$this.zks.decInProcess();
        ajc$this.zks.requestFinished(request);
        KeeperException.Code err = KeeperException.Code.OK;
        Record rsp = null;
        String path = null;
        try {
            if (request.getHdr() != null && request.getHdr().getType() == -1) {
                AuditHelper.addAuditLog(request, rc, true);
                if (request.getException() != null) {
                    throw request.getException();
                }
                throw KeeperException.create(KeeperException.Code.get(((ErrorTxn)request.getTxn()).getErr()));
            }
            KeeperException ke = request.getException();
            if (ke instanceof KeeperException.SessionMovedException) {
                throw ke;
            }
            if (ke != null && request.type != 14) {
                throw ke;
            }
            LOG.debug("{}", (Object)request);
            if (request.isStale()) {
                ServerMetrics.getMetrics().STALE_REPLIES.add(1L);
            }
            AuditHelper.addAuditLog(request, rc);
            switch (request.type) {
                case 11: {
                    lastOp = "PING";
                    ajc$this.updateStats(request, lastOp, lastZxid);
                    cnxn.sendResponse(new ReplyHeader(-2, lastZxid, 0), null, "response");
                    return;
                }
                case -10: {
                    lastOp = "SESS";
                    ajc$this.updateStats(request, lastOp, lastZxid);
                    ajc$this.zks.finishSessionInit(request.cnxn, true);
                    return;
                }
                case 14: {
                    lastOp = "MULT";
                    rsp = new MultiResponse();
                    for (DataTree.ProcessTxnResult subTxnResult : rc.multiResult) {
                        OpResult subResult;
                        switch (subTxnResult.type) {
                            case 13: {
                                subResult = new OpResult.CheckResult();
                                break;
                            }
                            case 1: {
                                subResult = new OpResult.CreateResult(subTxnResult.path);
                                break;
                            }
                            case 15: 
                            case 19: 
                            case 21: {
                                subResult = new OpResult.CreateResult(subTxnResult.path, subTxnResult.stat);
                                break;
                            }
                            case 2: 
                            case 20: {
                                subResult = new OpResult.DeleteResult();
                                break;
                            }
                            case 5: {
                                subResult = new OpResult.SetDataResult(subTxnResult.stat);
                                break;
                            }
                            case -1: {
                                subResult = new OpResult.ErrorResult(subTxnResult.err);
                                if (subTxnResult.err != KeeperException.Code.SESSIONMOVED.intValue()) break;
                                throw new KeeperException.SessionMovedException();
                            }
                            default: {
                                throw new IOException("Invalid type of op");
                            }
                        }
                        ((MultiResponse)rsp).add(subResult);
                    }
                    break;
                }
                case 22: {
                    lastOp = "MLTR";
                    MultiOperationRecord multiReadRecord = new MultiOperationRecord();
                    ByteBufferInputStream.byteBuffer2Record(request.request, multiReadRecord);
                    rsp = new MultiResponse();
                    for (Op readOp : multiReadRecord) {
                        OpResult subResult;
                        try {
                            switch (readOp.getType()) {
                                case 8: {
                                    Record rec = ajc$this.handleGetChildrenRequest(readOp.toRequestRecord(), cnxn, request.authInfo);
                                    subResult = new OpResult.GetChildrenResult(((GetChildrenResponse)rec).getChildren());
                                    break;
                                }
                                case 4: {
                                    Record rec = ajc$this.handleGetDataRequest(readOp.toRequestRecord(), cnxn, request.authInfo);
                                    GetDataResponse gdr = (GetDataResponse)rec;
                                    subResult = new OpResult.GetDataResult(gdr.getData(), gdr.getStat());
                                    break;
                                }
                                default: {
                                    throw new IOException("Invalid type of readOp");
                                }
                            }
                        }
                        catch (KeeperException e) {
                            subResult = new OpResult.ErrorResult(e.code().intValue());
                        }
                        ((MultiResponse)rsp).add(subResult);
                    }
                    break;
                }
                case 1: {
                    lastOp = "CREA";
                    rsp = new CreateResponse(rc.path);
                    err = KeeperException.Code.get(rc.err);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 15: 
                case 19: 
                case 21: {
                    lastOp = "CREA";
                    rsp = new Create2Response(rc.path, rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 2: 
                case 20: {
                    lastOp = "DELE";
                    err = KeeperException.Code.get(rc.err);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 5: {
                    lastOp = "SETD";
                    rsp = new SetDataResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 16: {
                    lastOp = "RECO";
                    rsp = new GetDataResponse(((QuorumZooKeeperServer)ajc$this.zks).self.getQuorumVerifier().toString().getBytes(), rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 7: {
                    lastOp = "SETA";
                    rsp = new SetACLResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case -11: {
                    lastOp = "CLOS";
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 9: {
                    lastOp = "SYNC";
                    SyncRequest syncRequest = new SyncRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, syncRequest);
                    rsp = new SyncResponse(syncRequest.getPath());
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, syncRequest.getPath());
                    break;
                }
                case 13: {
                    lastOp = "CHEC";
                    rsp = new SetDataResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 3: {
                    lastOp = "EXIS";
                    ExistsRequest existsRequest = new ExistsRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, existsRequest);
                    path = existsRequest.getPath();
                    if (path.indexOf(0) != -1) {
                        throw new KeeperException.BadArgumentsException();
                    }
                    Stat stat = ajc$this.zks.getZKDatabase().statNode(path, existsRequest.getWatch() ? cnxn : null);
                    rsp = new ExistsResponse(stat);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, path);
                    break;
                }
                case 4: {
                    lastOp = "GETD";
                    GetDataRequest getDataRequest = new GetDataRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getDataRequest);
                    path = getDataRequest.getPath();
                    rsp = ajc$this.handleGetDataRequest(getDataRequest, cnxn, request.authInfo);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, path);
                    break;
                }
                case 101: {
                    lastOp = "SETW";
                    Record setWatches = new SetWatches();
                    request.request.rewind();
                    ByteBufferInputStream.byteBuffer2Record(request.request, setWatches);
                    long relativeZxid = ((SetWatches)setWatches).getRelativeZxid();
                    ajc$this.zks.getZKDatabase().setWatches(relativeZxid, ((SetWatches)setWatches).getDataWatches(), ((SetWatches)setWatches).getExistWatches(), ((SetWatches)setWatches).getChildWatches(), Collections.emptyList(), Collections.emptyList(), cnxn);
                    break;
                }
                case 105: {
                    lastOp = "STW2";
                    Record setWatches = new SetWatches2();
                    request.request.rewind();
                    ByteBufferInputStream.byteBuffer2Record(request.request, setWatches);
                    long relativeZxid = ((SetWatches2)setWatches).getRelativeZxid();
                    ajc$this.zks.getZKDatabase().setWatches(relativeZxid, ((SetWatches2)setWatches).getDataWatches(), ((SetWatches2)setWatches).getExistWatches(), ((SetWatches2)setWatches).getChildWatches(), ((SetWatches2)setWatches).getPersistentWatches(), ((SetWatches2)setWatches).getPersistentRecursiveWatches(), cnxn);
                    break;
                }
                case 106: {
                    lastOp = "ADDW";
                    AddWatchRequest addWatcherRequest = new AddWatchRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, addWatcherRequest);
                    ajc$this.zks.getZKDatabase().addWatch(addWatcherRequest.getPath(), cnxn, addWatcherRequest.getMode());
                    rsp = new ErrorResponse(0);
                    break;
                }
                case 6: {
                    lastOp = "GETA";
                    GetACLRequest getACLRequest = new GetACLRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getACLRequest);
                    path = getACLRequest.getPath();
                    DataNode n = ajc$this.zks.getZKDatabase().getNode(path);
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    ajc$this.zks.checkACL(request.cnxn, ajc$this.zks.getZKDatabase().aclForNode(n), 17, request.authInfo, path, null);
                    Stat stat = new Stat();
                    List<ACL> acl = ajc$this.zks.getZKDatabase().getACL(path, stat);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, getACLRequest.getPath());
                    try {
                        ajc$this.zks.checkACL(request.cnxn, ajc$this.zks.getZKDatabase().aclForNode(n), 16, request.authInfo, path, null);
                        rsp = new GetACLResponse(acl, stat);
                    }
                    catch (KeeperException.NoAuthException e) {
                        ArrayList<ACL> acl1 = new ArrayList<ACL>(acl.size());
                        for (ACL a : acl) {
                            if ("digest".equals(a.getId().getScheme())) {
                                Id id = a.getId();
                                Id id1 = new Id(id.getScheme(), id.getId().replaceAll(":.*", ":x"));
                                acl1.add(new ACL(a.getPerms(), id1));
                                continue;
                            }
                            acl1.add(a);
                        }
                        rsp = new GetACLResponse(acl1, stat);
                    }
                    break;
                }
                case 8: {
                    lastOp = "GETC";
                    GetChildrenRequest getChildrenRequest = new GetChildrenRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getChildrenRequest);
                    path = getChildrenRequest.getPath();
                    rsp = ajc$this.handleGetChildrenRequest(getChildrenRequest, cnxn, request.authInfo);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, path);
                    break;
                }
                case 104: {
                    lastOp = "GETACN";
                    GetAllChildrenNumberRequest getAllChildrenNumberRequest = new GetAllChildrenNumberRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getAllChildrenNumberRequest);
                    path = getAllChildrenNumberRequest.getPath();
                    DataNode n = ajc$this.zks.getZKDatabase().getNode(path);
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    ajc$this.zks.checkACL(request.cnxn, ajc$this.zks.getZKDatabase().aclForNode(n), 1, request.authInfo, path, null);
                    int number = ajc$this.zks.getZKDatabase().getAllChildrenNumber(path);
                    rsp = new GetAllChildrenNumberResponse(number);
                    break;
                }
                case 12: {
                    lastOp = "GETC";
                    GetChildren2Request getChildren2Request = new GetChildren2Request();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getChildren2Request);
                    Stat stat = new Stat();
                    path = getChildren2Request.getPath();
                    DataNode n = ajc$this.zks.getZKDatabase().getNode(path);
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    ajc$this.zks.checkACL(request.cnxn, ajc$this.zks.getZKDatabase().aclForNode(n), 1, request.authInfo, path, null);
                    List<String> children = ajc$this.zks.getZKDatabase().getChildren(path, stat, getChildren2Request.getWatch() ? cnxn : null);
                    rsp = new GetChildren2Response(children, stat);
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, path);
                    break;
                }
                case 17: {
                    lastOp = "CHKW";
                    CheckWatchesRequest checkWatches = new CheckWatchesRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, checkWatches);
                    Watcher.WatcherType type = Watcher.WatcherType.fromInt(checkWatches.getType());
                    path = checkWatches.getPath();
                    boolean containsWatcher = ajc$this.zks.getZKDatabase().containsWatcher(path, type, cnxn);
                    if (!containsWatcher) {
                        String msg = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{path, type});
                        throw new KeeperException.NoWatcherException(msg);
                    }
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, checkWatches.getPath());
                    break;
                }
                case 18: {
                    lastOp = "REMW";
                    RemoveWatchesRequest removeWatches = new RemoveWatchesRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, removeWatches);
                    Watcher.WatcherType type = Watcher.WatcherType.fromInt(removeWatches.getType());
                    path = removeWatches.getPath();
                    boolean removed = ajc$this.zks.getZKDatabase().removeWatch(path, type, cnxn);
                    if (!removed) {
                        String msg = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{path, type});
                        throw new KeeperException.NoWatcherException(msg);
                    }
                    ajc$this.requestPathMetricsCollector.registerRequest(request.type, removeWatches.getPath());
                    break;
                }
                case 103: {
                    lastOp = "GETE";
                    GetEphemeralsRequest getEphemerals = new GetEphemeralsRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getEphemerals);
                    String prefixPath = getEphemerals.getPrefixPath();
                    Set<String> allEphems = ajc$this.zks.getZKDatabase().getDataTree().getEphemerals(request.sessionId);
                    ArrayList<String> ephemerals = new ArrayList<String>();
                    if (StringUtils.isBlank((String)prefixPath) || "/".equals(prefixPath.trim())) {
                        ephemerals.addAll(allEphems);
                    } else {
                        for (String p : allEphems) {
                            if (!p.startsWith(prefixPath)) continue;
                            ephemerals.add(p);
                        }
                    }
                    rsp = new GetEphemeralsResponse(ephemerals);
                    break;
                }
            }
        }
        catch (KeeperException.SessionMovedException e) {
            cnxn.sendCloseSession();
            return;
        }
        catch (KeeperException e) {
            err = e.code();
        }
        catch (Exception e) {
            LOG.error("Failed to process {}", (Object)request, (Object)e);
            StringBuilder sb = new StringBuilder();
            ByteBuffer bb = request.request;
            bb.rewind();
            while (bb.hasRemaining()) {
                sb.append(Integer.toHexString(bb.get() & 0xFF));
            }
            LOG.error("Dumping request buffer: 0x{}", (Object)sb.toString());
            err = KeeperException.Code.MARSHALLINGERROR;
        }
        ReplyHeader hdr = new ReplyHeader(request.cxid, lastZxid, err.intValue());
        ajc$this.updateStats(request, lastOp, lastZxid);
        try {
            if (path == null || rsp == null) {
                cnxn.sendResponse(hdr, rsp, "response");
            } else {
                int opCode = request.type;
                Stat stat = null;
                switch (opCode) {
                    case 4: {
                        GetDataResponse getDataResponse = (GetDataResponse)rsp;
                        stat = getDataResponse.getStat();
                        cnxn.sendResponse(hdr, rsp, "response", path, stat, opCode);
                        break;
                    }
                    case 12: {
                        GetChildren2Response getChildren2Response = (GetChildren2Response)rsp;
                        stat = getChildren2Response.getStat();
                        cnxn.sendResponse(hdr, rsp, "response", path, stat, opCode);
                        break;
                    }
                    default: {
                        cnxn.sendResponse(hdr, rsp, "response");
                    }
                }
            }
            if (request.type == -11) {
                cnxn.sendCloseSession();
            }
        }
        catch (IOException e) {
            LOG.error("FIXMSG", (Throwable)e);
        }
    }

    private static final /* synthetic */ void processRequest_aroundBody1$advice(FinalRequestProcessor ajc$this, Request request, JoinPoint thisJoinPoint, FinalRequestProcessorAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint) {
        ProceedingJoinPoint proceedingJoinPoint = joinPoint;
        FinalRequestProcessor.processRequest_aroundBody0(ajc$this, request, (JoinPoint)proceedingJoinPoint);
        Request request2 = (Request)joinPoint.getArgs()[0];
        String type = FinalRequestProcessorAspect.ajc$inlineAccessFieldGet$org_apache_pulsar_zookeeper_FinalRequestProcessorAspect$org_apache_pulsar_zookeeper_FinalRequestProcessorAspect$requestTypeMap().getOrDefault(request2.type, "unknown");
        ((Counter.Child)FinalRequestProcessorAspect.ajc$inlineAccessFieldGet$org_apache_pulsar_zookeeper_FinalRequestProcessorAspect$org_apache_pulsar_zookeeper_FinalRequestProcessorAspect$requests().labels(new String[]{type})).inc();
        long latencyMs = Time.currentElapsedTime() - request2.createTime;
        String latencyLabel = FinalRequestProcessorAspect.ajc$inlineAccessMethod$org_apache_pulsar_zookeeper_FinalRequestProcessorAspect$org_apache_pulsar_zookeeper_FinalRequestProcessorAspect$isWriteRequest(request2.type) ? "write" : "read";
        ((Summary.Child)FinalRequestProcessorAspect.ajc$inlineAccessFieldGet$org_apache_pulsar_zookeeper_FinalRequestProcessorAspect$org_apache_pulsar_zookeeper_FinalRequestProcessorAspect$requestsLatency().labels(new String[]{latencyLabel})).observe((double)latencyMs);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FinalRequestProcessor.java", FinalRequestProcessor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "processRequest", "org.apache.zookeeper.server.FinalRequestProcessor", "org.apache.zookeeper.server.Request", "request", "", "void"), 110);
    }
}

