/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.HashMap;
import java.util.Map;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.server.Request;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class FinalRequestProcessorAspect {
    private static final Map<Integer, String> requestTypeMap = new HashMap<Integer, String>();
    private static final Counter requests;
    private static final Summary requestsLatency;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ FinalRequestProcessorAspect ajc$perSingletonInstance;

    static {
        requestTypeMap.put(0, "notification");
        requestTypeMap.put(1, "create");
        requestTypeMap.put(2, "delete");
        requestTypeMap.put(3, "exists");
        requestTypeMap.put(4, "getData");
        requestTypeMap.put(5, "setData");
        requestTypeMap.put(6, "getACL");
        requestTypeMap.put(7, "setACL");
        requestTypeMap.put(8, "getChildren");
        requestTypeMap.put(9, "sync");
        requestTypeMap.put(11, "ping");
        requestTypeMap.put(12, "getChildren2");
        requestTypeMap.put(13, "check");
        requestTypeMap.put(14, "multi");
        requestTypeMap.put(100, "auth");
        requestTypeMap.put(101, "setWatches");
        requestTypeMap.put(102, "sasl");
        requestTypeMap.put(-10, "createSession");
        requestTypeMap.put(-11, "closeSession");
        requestTypeMap.put(-1, "error");
        requests = (Counter)((Counter.Builder)Counter.build((String)"zookeeper_server_requests", (String)"Requests issued to a particular server").labelNames(new String[]{"type"})).create().register();
        requestsLatency = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("zookeeper_server_requests_latency_ms")).help("Requests latency in millis")).quantile(0.5, 0.01).quantile(0.75, 0.01).quantile(0.95, 0.01).quantile(0.99, 0.01).quantile(0.999, 0.01).quantile(0.9999, 0.01).quantile(1.0, 0.01).maxAgeSeconds(60L).labelNames(new String[]{"type"})).create().register();
        try {
            FinalRequestProcessorAspect.ajc$perSingletonInstance = new FinalRequestProcessorAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(void org.apache.zookeeper.server.FinalRequestProcessor.processRequest(..))")
    public /* synthetic */ void processRequest() {
    }

    @Around(value="processRequest()")
    public void timedProcessRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        joinPoint.proceed();
        Request request = (Request)joinPoint.getArgs()[0];
        String type = FinalRequestProcessorAspect.requestTypeMap.getOrDefault(request.type, "unknown");
        ((Counter.Child)FinalRequestProcessorAspect.requests.labels(new String[]{type})).inc();
        long latencyMs = Time.currentElapsedTime() - request.createTime;
        String latencyLabel = FinalRequestProcessorAspect.isWriteRequest(request.type) ? "write" : "read";
        ((Summary.Child)FinalRequestProcessorAspect.requestsLatency.labels(new String[]{latencyLabel})).observe((double)latencyMs);
    }

    private static boolean isWriteRequest(int opCode) {
        switch (opCode) {
            case -11: 
            case -10: 
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static FinalRequestProcessorAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.apache.pulsar.zookeeper.FinalRequestProcessorAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

