/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.testclient.IMessageFormatter;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PositiveNumberParameterValidator;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceProducer {
    private static final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("pulsar-perf-producer-exec"));
    private static final LongAdder messagesSent = new LongAdder();
    private static final LongAdder messagesFailed = new LongAdder();
    private static final LongAdder bytesSent = new LongAdder();
    private static final LongAdder totalNumTxnOpenTxnFail = new LongAdder();
    private static final LongAdder totalNumTxnOpenTxnSuccess = new LongAdder();
    private static final LongAdder totalMessagesSent = new LongAdder();
    private static final LongAdder totalBytesSent = new LongAdder();
    private static final Recorder recorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final Recorder cumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final LongAdder totalEndTxnOpSuccessNum = new LongAdder();
    private static final LongAdder totalEndTxnOpFailNum = new LongAdder();
    private static final LongAdder numTxnOpSuccess = new LongAdder();
    private static IMessageFormatter messageFormatter = null;
    static final DecimalFormat THROUGHPUTFORMAT = new PaddingDecimalFormat("0.0", 8);
    static final DecimalFormat DEC = new PaddingDecimalFormat("0.000", 7);
    static final DecimalFormat INTFORMAT = new PaddingDecimalFormat("0", 7);
    static final DecimalFormat TOTALFORMAT = new DecimalFormat("0.000");
    private static final Logger log = LoggerFactory.getLogger(PerformanceProducer.class);

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jc = new JCommander((Object)arguments);
        jc.setProgramName("pulsar-perf produce");
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (arguments.help) {
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (StringUtils.isBlank((CharSequence)arguments.authPluginClassName) && !StringUtils.isBlank((CharSequence)arguments.deprecatedAuthPluginClassName)) {
            arguments.authPluginClassName = arguments.deprecatedAuthPluginClassName;
        }
        if (arguments.topics != null && arguments.topics.size() != arguments.numTopics) {
            if (arguments.topics.size() == 1) {
                String prefixTopicName = arguments.topics.get(0);
                ArrayList<String> defaultTopics = new ArrayList<String>();
                for (int i = 0; i < arguments.numTopics; ++i) {
                    defaultTopics.add(String.format("%s%s%d", prefixTopicName, arguments.separator, i));
                }
                arguments.topics = defaultTopics;
            } else {
                System.out.println("The size of topics list should be equal to --num-topic");
                jc.usage();
                PerfClientUtils.exit(-1);
            }
        }
        if (arguments.confFile != null) {
            Properties prop = new Properties(System.getProperties());
            prop.load(new FileInputStream(arguments.confFile));
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("brokerServiceUrl");
            }
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("webServiceUrl");
            }
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("serviceUrl", "http://localhost:8080/");
            }
            if (arguments.adminURL == null) {
                arguments.adminURL = prop.getProperty("webServiceUrl");
            }
            if (arguments.adminURL == null) {
                arguments.adminURL = prop.getProperty("adminURL", "http://localhost:8080/");
            }
            if (arguments.authPluginClassName == null) {
                arguments.authPluginClassName = prop.getProperty("authPlugin", null);
            }
            if (arguments.authParams == null) {
                arguments.authParams = prop.getProperty("authParams", null);
            }
            if (StringUtils.isBlank((CharSequence)arguments.tlsTrustCertsFilePath)) {
                arguments.tlsTrustCertsFilePath = prop.getProperty("tlsTrustCertsFilePath", "");
            }
            if (StringUtils.isBlank((CharSequence)arguments.messageKeyGenerationMode)) {
                arguments.messageKeyGenerationMode = prop.getProperty("messageKeyGenerationMode", null);
            }
            if (arguments.tlsAllowInsecureConnection == null) {
                arguments.tlsAllowInsecureConnection = Boolean.parseBoolean(prop.getProperty("tlsAllowInsecureConnection", ""));
            }
        }
        PerfClientUtils.printJVMInformation(log);
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting Pulsar perf producer with config: {}", (Object)w.writeValueAsString((Object)arguments));
        byte[] payloadBytes = new byte[arguments.msgSize];
        Random random = new Random(0L);
        ArrayList<byte[]> payloadByteList = new ArrayList<byte[]>();
        if (arguments.payloadFilename != null) {
            Path payloadFilePath = Paths.get(arguments.payloadFilename, new String[0]);
            if (Files.notExists(payloadFilePath, new LinkOption[0]) || Files.size(payloadFilePath) == 0L) {
                throw new IllegalArgumentException("Payload file doesn't exist or it is empty.");
            }
            String delimiter = arguments.payloadDelimiter.equals("\\n") ? "\n" : arguments.payloadDelimiter;
            String[] payloadList = new String(Files.readAllBytes(payloadFilePath), StandardCharsets.UTF_8).split(delimiter);
            log.info("Reading payloads from {} and {} records read", (Object)payloadFilePath.toAbsolutePath(), (Object)payloadList.length);
            for (String payload : payloadList) {
                payloadByteList.add(payload.getBytes(StandardCharsets.UTF_8));
            }
            if (arguments.formatPayload) {
                messageFormatter = PerformanceProducer.getMessageFormatter(arguments.formatterClass);
            }
        } else {
            for (int i = 0; i < payloadBytes.length; ++i) {
                payloadBytes[i] = (byte)(random.nextInt(26) + 65);
            }
        }
        long start = System.nanoTime();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            PerformanceProducer.printAggregatedThroughput(start, arguments);
            PerformanceProducer.printAggregatedStats();
        }));
        if (arguments.partitions != null) {
            PulsarAdminBuilder clientBuilder = PulsarAdmin.builder().serviceHttpUrl(arguments.adminURL).tlsTrustCertsFilePath(arguments.tlsTrustCertsFilePath);
            if (StringUtils.isNotBlank((CharSequence)arguments.authPluginClassName)) {
                clientBuilder.authentication(arguments.authPluginClassName, arguments.authParams);
            }
            if (arguments.tlsAllowInsecureConnection != null) {
                clientBuilder.allowTlsInsecureConnection(arguments.tlsAllowInsecureConnection.booleanValue());
            }
            try (PulsarAdmin client = clientBuilder.build();){
                for (String topic : arguments.topics) {
                    log.info("Creating partitioned topic {} with {} partitions", (Object)topic, (Object)arguments.partitions);
                    try {
                        client.topics().createPartitionedTopic(topic, arguments.partitions.intValue());
                    }
                    catch (PulsarAdminException.ConflictException alreadyExists) {
                        if (log.isDebugEnabled()) {
                            log.debug("Topic {} already exists: {}", (Object)topic, (Object)alreadyExists);
                        }
                        PartitionedTopicMetadata partitionedTopicMetadata = client.topics().getPartitionedTopicMetadata(topic);
                        if (partitionedTopicMetadata.partitions == arguments.partitions) continue;
                        log.error("Topic {} already exists but it has a wrong number of partitions: {}, expecting {}", new Object[]{topic, partitionedTopicMetadata.partitions, arguments.partitions});
                        PerfClientUtils.exit(-1);
                    }
                }
            }
        }
        CountDownLatch doneLatch = new CountDownLatch(arguments.numTestThreads);
        long numMessagesPerThread = arguments.numMessages / (long)arguments.numTestThreads;
        int msgRatePerThread = arguments.msgRate / arguments.numTestThreads;
        int i = 0;
        while (i < arguments.numTestThreads) {
            int threadIdx = i++;
            executor.submit(() -> {
                log.info("Started performance test thread {}", (Object)threadIdx);
                PerformanceProducer.runProducer(threadIdx, arguments, numMessagesPerThread, msgRatePerThread, payloadByteList, payloadBytes, random, doneLatch);
            });
        }
        long oldTime = System.nanoTime();
        Histogram reportHistogram = null;
        HistogramLogWriter histogramLogWriter = null;
        if (arguments.histogramFile != null) {
            String statsFileName = arguments.histogramFile;
            log.info("Dumping latency stats to {}", (Object)statsFileName);
            PrintStream histogramLog = new PrintStream(new FileOutputStream(statsFileName), false);
            histogramLogWriter = new HistogramLogWriter(histogramLog);
            histogramLogWriter.outputLogFormatVersion();
            histogramLogWriter.outputLegend();
        }
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (doneLatch.getCount() <= 0L) break;
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            long total = totalMessagesSent.sum();
            long totalTxnOpSuccess = 0L;
            long totalTxnOpFail = 0L;
            double rateOpenTxn = 0.0;
            double rate = (double)messagesSent.sumThenReset() / elapsed;
            double failureRate = (double)messagesFailed.sumThenReset() / elapsed;
            double throughput = (double)bytesSent.sumThenReset() / elapsed / 1024.0 / 1024.0 * 8.0;
            reportHistogram = recorder.getIntervalHistogram(reportHistogram);
            if (arguments.isEnableTransaction) {
                totalTxnOpSuccess = totalEndTxnOpSuccessNum.sum();
                totalTxnOpFail = totalEndTxnOpFailNum.sum();
                rateOpenTxn = (double)numTxnOpSuccess.sumThenReset() / elapsed;
                log.info("--- Transaction : {} transaction end successfully --- {} transaction end failed --- {} Txn/s", new Object[]{totalTxnOpSuccess, totalTxnOpFail, TOTALFORMAT.format(rateOpenTxn)});
            }
            log.info("Throughput produced: {} msg --- {} msg/s --- {} Mbit/s  --- failure {} msg/s --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{INTFORMAT.format(total), THROUGHPUTFORMAT.format(rate), THROUGHPUTFORMAT.format(throughput), THROUGHPUTFORMAT.format(failureRate), DEC.format(reportHistogram.getMean() / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportHistogram.getMaxValue() / 1000.0)});
            if (histogramLogWriter != null) {
                histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportHistogram);
            }
            reportHistogram.reset();
            oldTime = now;
        }
    }

    static IMessageFormatter getMessageFormatter(String formatterClass) {
        try {
            ClassLoader classLoader = PerformanceProducer.class.getClassLoader();
            Class<?> clz = classLoader.loadClass(formatterClass);
            return (IMessageFormatter)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private static void runProducer(int producerId, Arguments arguments, long numMessages, int msgRate, List<byte[]> payloadByteList, byte[] payloadBytes, Random random, CountDownLatch doneLatch) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void printAggregatedThroughput(long start, Arguments arguments) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        double rate = (double)totalMessagesSent.sum() / elapsed;
        double throughput = (double)totalBytesSent.sum() / elapsed / 1024.0 / 1024.0 * 8.0;
        long totalTxnSuccess = 0L;
        long totalTxnFail = 0L;
        double rateOpenTxn = 0.0;
        long numTransactionOpenFailed = 0L;
        long numTransactionOpenSuccess = 0L;
        if (arguments.isEnableTransaction) {
            totalTxnSuccess = totalEndTxnOpSuccessNum.sum();
            totalTxnFail = totalEndTxnOpFailNum.sum();
            rateOpenTxn = elapsed / (double)(totalTxnFail + totalTxnSuccess);
            numTransactionOpenFailed = totalNumTxnOpenTxnFail.sum();
            numTransactionOpenSuccess = totalNumTxnOpenTxnSuccess.sum();
            log.info("--- Transaction : {} transaction end successfully --- {} transaction end failed --- {} transaction open successfully --- {} transaction open failed --- {} Txn/s", new Object[]{totalTxnSuccess, totalTxnFail, numTransactionOpenSuccess, numTransactionOpenFailed, TOTALFORMAT.format(rateOpenTxn)});
        }
        log.info("Aggregated throughput stats --- {} records sent --- {} msg/s --- {} Mbit/s ", new Object[]{totalMessagesSent.sum(), TOTALFORMAT.format(rate), TOTALFORMAT.format(throughput)});
    }

    private static void printAggregatedStats() {
        Histogram reportHistogram = cumulativeRecorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{DEC.format(reportHistogram.getMean() / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.999) / 1000.0), DEC.format((double)reportHistogram.getMaxValue() / 1000.0)});
    }

    private static /* synthetic */ Void lambda$runProducer$7(Transaction transaction, Throwable exception) {
        log.error("Commit transaction {} failed with exception", (Object)transaction.getTxnID().toString(), (Object)exception);
        totalEndTxnOpFailNum.increment();
        return null;
    }

    private static /* synthetic */ void lambda$runProducer$6(Transaction transaction) {
        log.info("Abort transaction {}", (Object)transaction.getTxnID().toString());
        totalEndTxnOpSuccessNum.increment();
        numTxnOpSuccess.increment();
    }

    private static /* synthetic */ Void lambda$runProducer$5(Throwable exception) {
        log.error("Commit transaction failed with exception : ", exception);
        totalEndTxnOpFailNum.increment();
        return null;
    }

    private static /* synthetic */ void lambda$runProducer$4(Transaction transaction) {
        log.info("Committed transaction {}", (Object)transaction.getTxnID().toString());
        totalEndTxnOpSuccessNum.increment();
        numTxnOpSuccess.increment();
    }

    private static /* synthetic */ Void lambda$runProducer$3(Arguments arguments, Throwable ex) {
        if (ex.getCause() instanceof ArrayIndexOutOfBoundsException) {
            return null;
        }
        log.warn("Write message error with exception", ex);
        messagesFailed.increment();
        if (arguments.exitOnFailure) {
            PerfClientUtils.exit(-1);
        }
        return null;
    }

    private static /* synthetic */ void lambda$runProducer$2(byte[] payloadData, long warmupEndTime, long sendTime) {
        bytesSent.add(payloadData.length);
        messagesSent.increment();
        totalMessagesSent.increment();
        totalBytesSent.add(payloadData.length);
        long now = System.nanoTime();
        if (now > warmupEndTime) {
            long latencyMicros = TimeUnit.NANOSECONDS.toMicros(now - sendTime);
            recorder.recordValue(latencyMicros);
            cumulativeRecorder.recordValue(latencyMicros);
        }
    }

    public static enum MessageKeyGenerationMode {
        autoIncrement,
        random;

    }

    @Parameters(commandDescription="Test pulsar producer performance.")
    static class Arguments {
        @Parameter(names={"-h", "--help"}, description="Help message", help=true)
        boolean help;
        @Parameter(names={"--conf-file"}, description="Configuration file")
        public String confFile;
        @Parameter(description="persistent://prop/ns/my-topic", required=true)
        public List<String> topics;
        @Parameter(names={"-threads", "--num-test-threads"}, description="Number of test threads", validateWith={PositiveNumberParameterValidator.class})
        public int numTestThreads = 1;
        @Parameter(names={"-r", "--rate"}, description="Publish rate msg/s across topics")
        public int msgRate = 100;
        @Parameter(names={"-s", "--size"}, description="Message size (bytes)")
        public int msgSize = 1024;
        @Parameter(names={"-t", "--num-topic"}, description="Number of topics", validateWith={PositiveNumberParameterValidator.class})
        public int numTopics = 1;
        @Parameter(names={"-n", "--num-producers"}, description="Number of producers (per topic)", validateWith={PositiveNumberParameterValidator.class})
        public int numProducers = 1;
        @Parameter(names={"--separator"}, description="Separator between the topic and topic number")
        public String separator = "-";
        @Parameter(names={"--send-timeout"}, description="Set the sendTimeout value default 0 to keep compatibility with previous version of pulsar-perf")
        public int sendTimeout = 0;
        @Parameter(names={"-pn", "--producer-name"}, description="Producer Name")
        public String producerName = null;
        @Parameter(names={"-u", "--service-url"}, description="Pulsar Service URL")
        public String serviceURL;
        @Parameter(names={"-au", "--admin-url"}, description="Pulsar Admin URL")
        public String adminURL;
        @Parameter(names={"--auth_plugin"}, description="Authentication plugin class name", hidden=true)
        public String deprecatedAuthPluginClassName;
        @Parameter(names={"--auth-plugin"}, description="Authentication plugin class name")
        public String authPluginClassName;
        @Parameter(names={"--listener-name"}, description="Listener name for the broker.")
        String listenerName = null;
        @Parameter(names={"-ch", "--chunking"}, description="Should split the message and publish in chunks if message size is larger than allowed max size")
        private boolean chunkingAllowed = false;
        @Parameter(names={"--auth-params"}, description="Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}.")
        public String authParams;
        @Parameter(names={"-o", "--max-outstanding"}, description="Max number of outstanding messages")
        public int maxOutstanding = 0;
        @Parameter(names={"-p", "--max-outstanding-across-partitions"}, description="Max number of outstanding messages across partitions")
        public int maxPendingMessagesAcrossPartitions = 0;
        @Parameter(names={"-np", "--partitions"}, description="Create partitioned topics with the given number of partitions, set 0 to not try to create the topic")
        public Integer partitions = null;
        @Parameter(names={"-c", "--max-connections"}, description="Max number of TCP connections to a single broker")
        public int maxConnections = 100;
        @Parameter(names={"-m", "--num-messages"}, description="Number of messages to publish in total. If <= 0, it will keep publishing")
        public long numMessages = 0L;
        @Parameter(names={"-i", "--stats-interval-seconds"}, description="Statistics Interval Seconds. If 0, statistics will be disabled")
        public long statsIntervalSeconds = 0L;
        @Parameter(names={"-z", "--compression"}, description="Compress messages payload")
        public CompressionType compression = CompressionType.NONE;
        @Parameter(names={"-f", "--payload-file"}, description="Use payload from an UTF-8 encoded text file and a payload will be randomly selected when publishing messages")
        public String payloadFilename = null;
        @Parameter(names={"-e", "--payload-delimiter"}, description="The delimiter used to split lines when using payload from a file")
        public String payloadDelimiter = "\\n";
        @Parameter(names={"-b", "--batch-time-window"}, description="Batch messages in 'x' ms window (Default: 1ms)")
        public double batchTimeMillis = 1.0;
        @Parameter(names={"-bm", "--batch-max-messages"}, description="Maximum number of messages per batch")
        public int batchMaxMessages = 1000;
        @Parameter(names={"-bb", "--batch-max-bytes"}, description="Maximum number of bytes per batch")
        public int batchMaxBytes = 0x400000;
        @Parameter(names={"-time", "--test-duration"}, description="Test duration in secs. If <= 0, it will keep publishing")
        public long testTime = 0L;
        @Parameter(names={"--warmup-time"}, description="Warm-up time in seconds (Default: 1 sec)")
        public double warmupTimeSeconds = 1.0;
        @Parameter(names={"--trust-cert-file"}, description="Path for the trusted TLS certificate file")
        public String tlsTrustCertsFilePath = "";
        @Parameter(names={"--tls-allow-insecure"}, description="Allow insecure TLS connection")
        public Boolean tlsAllowInsecureConnection = null;
        @Parameter(names={"-k", "--encryption-key-name"}, description="The public key name to encrypt payload")
        public String encKeyName = null;
        @Parameter(names={"-v", "--encryption-key-value-file"}, description="The file which contains the public key to encrypt payload")
        public String encKeyFile = null;
        @Parameter(names={"-d", "--delay"}, description="Mark messages with a given delay in seconds")
        public long delay = 0L;
        @Parameter(names={"-ef", "--exit-on-failure"}, description="Exit from the process on publish failure (default: disable)")
        public boolean exitOnFailure = false;
        @Parameter(names={"-mk", "--message-key-generation-mode"}, description="The generation mode of message key, valid options are: [autoIncrement, random]")
        public String messageKeyGenerationMode = null;
        @Parameter(names={"-ioThreads", "--num-io-threads"}, description="Set the number of threads to be used for handling connections to brokers. The default value is 1.")
        public int ioThreads = 1;
        @Parameter(names={"-bw", "--busy-wait"}, description="Enable Busy-Wait on the Pulsar client")
        public boolean enableBusyWait = false;
        @Parameter(names={"-am", "--access-mode"}, description="Producer access mode")
        public ProducerAccessMode producerAccessMode = ProducerAccessMode.Shared;
        @Parameter(names={"-fp", "--format-payload"}, description="Format %i as a message index in the stream from producer and/or %t as the timestamp nanoseconds.")
        public boolean formatPayload = false;
        @Parameter(names={"-fc", "--format-class"}, description="Custom Formatter class name")
        public String formatterClass = "org.apache.pulsar.testclient.DefaultMessageFormatter";
        @Parameter(names={"-tto", "--txn-timeout"}, description="Set the time value of transaction timeout, and the time unit is second. (After --txn-enable setting to true, --txn-timeout takes effect)")
        public long transactionTimeout = 10L;
        @Parameter(names={"-nmt", "--numMessage-perTransaction"}, description="The number of messages sent by a transaction. (After --txn-enable setting to true, -nmt takes effect)")
        public int numMessagesPerTransaction = 50;
        @Parameter(names={"-txn", "--txn-enable"}, description="Enable or disable the transaction")
        public boolean isEnableTransaction = false;
        @Parameter(names={"-abort"}, description="Abort the transaction. (After --txn-enable setting to true, -abort takes effect)")
        public boolean isAbortTransaction = false;
        @Parameter(names={"--histogram-file"}, description="HdrHistogram output file")
        public String histogramFile = null;

        Arguments() {
        }

        static /* synthetic */ boolean access$000(Arguments x0) {
            return x0.chunkingAllowed;
        }
    }
}

