/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PositiveNumberParameterValidator;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceConsumer {
    private static final LongAdder messagesReceived = new LongAdder();
    private static final LongAdder bytesReceived = new LongAdder();
    private static final DecimalFormat intFormat = new PaddingDecimalFormat("0", 7);
    private static final DecimalFormat dec = new DecimalFormat("0.000");
    private static final LongAdder totalMessagesReceived = new LongAdder();
    private static final LongAdder totalBytesReceived = new LongAdder();
    private static Recorder recorder = new Recorder(TimeUnit.DAYS.toMillis(10L), 5);
    private static Recorder cumulativeRecorder = new Recorder(TimeUnit.DAYS.toMillis(10L), 5);
    private static final Logger log = LoggerFactory.getLogger(PerformanceConsumer.class);

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jc = new JCommander((Object)arguments);
        jc.setProgramName("pulsar-perf consume");
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (arguments.help) {
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (StringUtils.isBlank((CharSequence)arguments.authPluginClassName) && !StringUtils.isBlank((CharSequence)arguments.deprecatedAuthPluginClassName)) {
            arguments.authPluginClassName = arguments.deprecatedAuthPluginClassName;
        }
        if (arguments.topic != null && arguments.topic.size() != arguments.numTopics) {
            if (arguments.topic.size() == 1) {
                String prefixTopicName = TopicName.get((String)arguments.topic.get(0)).toString().trim();
                ArrayList defaultTopics = Lists.newArrayList();
                for (int i = 0; i < arguments.numTopics; ++i) {
                    defaultTopics.add(String.format("%s-%d", prefixTopicName, i));
                }
                arguments.topic = defaultTopics;
            } else {
                System.out.println("The size of topics list should be equal to --num-topics");
                jc.usage();
                PerfClientUtils.exit(-1);
            }
        }
        if (arguments.subscriptionType == SubscriptionType.Exclusive && arguments.numConsumers > 1) {
            System.out.println("Only one consumer is allowed when subscriptionType is Exclusive");
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (arguments.subscriptions != null && arguments.subscriptions.size() != arguments.numSubscriptions) {
            if (arguments.subscriptions.size() == 1) {
                if (arguments.subscriberName == null) {
                    arguments.subscriberName = arguments.subscriptions.get(0);
                }
                ArrayList defaultSubscriptions = Lists.newArrayList();
                for (int i = 0; i < arguments.numSubscriptions; ++i) {
                    defaultSubscriptions.add(String.format("%s-%d", arguments.subscriberName, i));
                }
                arguments.subscriptions = defaultSubscriptions;
            } else {
                System.out.println("The size of subscriptions list should be equal to --num-subscriptions");
                jc.usage();
                PerfClientUtils.exit(-1);
            }
        }
        if (arguments.confFile != null) {
            Properties prop = new Properties(System.getProperties());
            prop.load(new FileInputStream(arguments.confFile));
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("brokerServiceUrl");
            }
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("webServiceUrl");
            }
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("serviceUrl", "http://localhost:8080/");
            }
            if (arguments.authPluginClassName == null) {
                arguments.authPluginClassName = prop.getProperty("authPlugin", null);
            }
            if (arguments.authParams == null) {
                arguments.authParams = prop.getProperty("authParams", null);
            }
            if (StringUtils.isBlank((CharSequence)arguments.tlsTrustCertsFilePath)) {
                arguments.tlsTrustCertsFilePath = prop.getProperty("tlsTrustCertsFilePath", "");
            }
            if (arguments.tlsAllowInsecureConnection == null) {
                arguments.tlsAllowInsecureConnection = Boolean.parseBoolean(prop.getProperty("tlsAllowInsecureConnection", ""));
            }
        }
        PerfClientUtils.printJVMInformation(log);
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting Pulsar performance consumer with config: {}", (Object)w.writeValueAsString((Object)arguments));
        RateLimiter limiter = arguments.rate > 0.0 ? RateLimiter.create((double)arguments.rate) : null;
        long startTime = System.nanoTime();
        long testEndTime = startTime + (long)((double)arguments.testTime * 1.0E9);
        MessageListener & Serializable listener = (MessageListener & Serializable)(consumer, msg) -> {
            long latencyMillis;
            if (arguments.testTime > 0L && System.nanoTime() > testEndTime) {
                log.info("------------- DONE (reached the maximum duration: [{} seconds] of consumption) --------------", (Object)arguments.testTime);
                PerformanceConsumer.printAggregatedStats();
                PerfClientUtils.exit(0);
            }
            if (arguments.numMessages > 0L && totalMessagesReceived.sum() >= arguments.numMessages) {
                log.info("------------- DONE (reached the maximum number: [{}] of consumption) --------------", (Object)arguments.numMessages);
                PerformanceConsumer.printAggregatedStats();
                PerfClientUtils.exit(0);
            }
            messagesReceived.increment();
            bytesReceived.add(msg.size());
            totalMessagesReceived.increment();
            totalBytesReceived.add(msg.size());
            if (limiter != null) {
                limiter.acquire();
            }
            if ((latencyMillis = System.currentTimeMillis() - msg.getPublishTime()) >= 0L) {
                recorder.recordValue(latencyMillis);
                cumulativeRecorder.recordValue(latencyMillis);
            }
            consumer.acknowledgeAsync(msg);
            if (arguments.poolMessages) {
                msg.release();
            }
        };
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(arguments.serviceURL).connectionsPerBroker(arguments.maxConnections).statsInterval(arguments.statsIntervalSeconds, TimeUnit.SECONDS).ioThreads(arguments.ioThreads).enableBusyWait(arguments.enableBusyWait).tlsTrustCertsFilePath(arguments.tlsTrustCertsFilePath);
        if (StringUtils.isNotBlank((CharSequence)arguments.authPluginClassName)) {
            clientBuilder.authentication(arguments.authPluginClassName, arguments.authParams);
        }
        if (arguments.tlsAllowInsecureConnection != null) {
            clientBuilder.allowTlsInsecureConnection(arguments.tlsAllowInsecureConnection.booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)arguments.listenerName)) {
            clientBuilder.listenerName(arguments.listenerName);
        }
        PulsarClient pulsarClient = clientBuilder.build();
        ArrayList futures = Lists.newArrayList();
        ConsumerBuilder consumerBuilder = pulsarClient.newConsumer(Schema.BYTEBUFFER).messageListener((MessageListener)listener).receiverQueueSize(arguments.receiverQueueSize).maxTotalReceiverQueueSizeAcrossPartitions(arguments.maxTotalReceiverQueueSizeAcrossPartitions).acknowledgmentGroupTime((long)arguments.acknowledgmentsGroupingDelayMillis, TimeUnit.MILLISECONDS).subscriptionType(arguments.subscriptionType).subscriptionInitialPosition(arguments.subscriptionInitialPosition).autoAckOldestChunkedMessageOnQueueFull(arguments.autoAckOldestChunkedMessageOnQueueFull).enableBatchIndexAcknowledgment(arguments.batchIndexAck).poolMessages(arguments.poolMessages).replicateSubscriptionState(arguments.replicatedSubscription);
        if (arguments.maxPendingChunkedMessage > 0) {
            consumerBuilder.maxPendingChunkedMessage(arguments.maxPendingChunkedMessage);
        }
        if (arguments.expireTimeOfIncompleteChunkedMessageMs > 0L) {
            consumerBuilder.expireTimeOfIncompleteChunkedMessage(arguments.expireTimeOfIncompleteChunkedMessageMs, TimeUnit.MILLISECONDS);
        }
        if (StringUtils.isNotBlank((CharSequence)arguments.encKeyFile)) {
            consumerBuilder.defaultCryptoKeyReader(arguments.encKeyFile);
        }
        for (int i = 0; i < arguments.numTopics; ++i) {
            TopicName topicName = TopicName.get((String)arguments.topic.get(i));
            log.info("Adding {} consumers per subscription on topic {}", (Object)arguments.numConsumers, (Object)topicName);
            for (int j = 0; j < arguments.numSubscriptions; ++j) {
                String subscriberName = arguments.subscriptions.get(j);
                for (int k = 0; k < arguments.numConsumers; ++k) {
                    futures.add(consumerBuilder.clone().topic(new String[]{topicName.toString()}).subscriptionName(subscriberName).subscribeAsync());
                }
            }
        }
        for (Future future : futures) {
            future.get();
        }
        log.info("Start receiving from {} consumers per subscription on {} topics", (Object)arguments.numConsumers, (Object)arguments.numTopics);
        long start = System.nanoTime();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            PerformanceConsumer.printAggregatedThroughput(start);
            PerformanceConsumer.printAggregatedStats();
        }));
        long oldTime = System.nanoTime();
        Histogram reportHistogram = null;
        HistogramLogWriter histogramLogWriter = null;
        if (arguments.histogramFile != null) {
            String statsFileName = arguments.histogramFile;
            log.info("Dumping latency stats to {}", (Object)statsFileName);
            PrintStream histogramLog = new PrintStream(new FileOutputStream(statsFileName), false);
            histogramLogWriter = new HistogramLogWriter(histogramLog);
            histogramLogWriter.outputLogFormatVersion();
            histogramLogWriter.outputLegend();
        }
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            long total = totalMessagesReceived.sum();
            double rate = (double)messagesReceived.sumThenReset() / elapsed;
            double throughput = (double)bytesReceived.sumThenReset() / elapsed * 8.0 / 1024.0 / 1024.0;
            reportHistogram = recorder.getIntervalHistogram(reportHistogram);
            log.info("Throughput received: {} msg --- {}  msg/s -- {} Mbit/s --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{intFormat.format(total), dec.format(rate), dec.format(throughput), dec.format(reportHistogram.getMean()), reportHistogram.getValueAtPercentile(50.0), reportHistogram.getValueAtPercentile(95.0), reportHistogram.getValueAtPercentile(99.0), reportHistogram.getValueAtPercentile(99.9), reportHistogram.getValueAtPercentile(99.99), reportHistogram.getMaxValue()});
            if (histogramLogWriter != null) {
                histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportHistogram);
            }
            reportHistogram.reset();
            oldTime = now;
        }
        pulsarClient.close();
    }

    private static void printAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        double rate = (double)totalMessagesReceived.sum() / elapsed;
        double throughput = (double)totalBytesReceived.sum() / elapsed * 8.0 / 1024.0 / 1024.0;
        log.info("Aggregated throughput stats --- {} records received --- {} msg/s --- {} Mbit/s", new Object[]{totalMessagesReceived, dec.format(rate), dec.format(throughput)});
    }

    private static void printAggregatedStats() {
        Histogram reportHistogram = cumulativeRecorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{dec.format(reportHistogram.getMean()), reportHistogram.getValueAtPercentile(50.0), reportHistogram.getValueAtPercentile(95.0), reportHistogram.getValueAtPercentile(99.0), reportHistogram.getValueAtPercentile(99.9), reportHistogram.getValueAtPercentile(99.99), reportHistogram.getValueAtPercentile(99.999), reportHistogram.getMaxValue()});
    }

    @Parameters(commandDescription="Test pulsar consumer performance.")
    static class Arguments {
        @Parameter(names={"-h", "--help"}, description="Help message", help=true)
        boolean help;
        @Parameter(names={"--conf-file"}, description="Configuration file")
        public String confFile;
        @Parameter(description="persistent://prop/ns/my-topic", required=true)
        public List<String> topic;
        @Parameter(names={"-t", "--num-topics"}, description="Number of topics", validateWith={PositiveNumberParameterValidator.class})
        public int numTopics = 1;
        @Parameter(names={"-n", "--num-consumers"}, description="Number of consumers (per subscription), only one consumer is allowed when subscriptionType is Exclusive", validateWith={PositiveNumberParameterValidator.class})
        public int numConsumers = 1;
        @Parameter(names={"-ns", "--num-subscriptions"}, description="Number of subscriptions (per topic)", validateWith={PositiveNumberParameterValidator.class})
        public int numSubscriptions = 1;
        @Parameter(names={"-s", "--subscriber-name"}, description="Subscriber name prefix", hidden=true)
        public String subscriberName;
        @Parameter(names={"-ss", "--subscriptions"}, description="A list of subscriptions to consume on (e.g. sub1,sub2)")
        public List<String> subscriptions = Collections.singletonList("sub");
        @Parameter(names={"-st", "--subscription-type"}, description="Subscription type")
        public SubscriptionType subscriptionType = SubscriptionType.Exclusive;
        @Parameter(names={"-sp", "--subscription-position"}, description="Subscription position")
        private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Latest;
        @Parameter(names={"-r", "--rate"}, description="Simulate a slow message consumer (rate in msg/s)")
        public double rate = 0.0;
        @Parameter(names={"-q", "--receiver-queue-size"}, description="Size of the receiver queue")
        public int receiverQueueSize = 1000;
        @Parameter(names={"-p", "--receiver-queue-size-across-partitions"}, description="Max total size of the receiver queue across partitions")
        public int maxTotalReceiverQueueSizeAcrossPartitions = 50000;
        @Parameter(names={"--replicated"}, description="Whether the subscription status should be replicated")
        public boolean replicatedSubscription = false;
        @Parameter(names={"--acks-delay-millis"}, description="Acknowledgements grouping delay in millis")
        public int acknowledgmentsGroupingDelayMillis = 100;
        @Parameter(names={"-m", "--num-messages"}, description="Number of messages to consume in total. If <= 0, it will keep consuming")
        public long numMessages = 0L;
        @Parameter(names={"-c", "--max-connections"}, description="Max number of TCP connections to a single broker")
        public int maxConnections = 100;
        @Parameter(names={"-i", "--stats-interval-seconds"}, description="Statistics Interval Seconds. If 0, statistics will be disabled")
        public long statsIntervalSeconds = 0L;
        @Parameter(names={"-u", "--service-url"}, description="Pulsar Service URL")
        public String serviceURL;
        @Parameter(names={"--auth_plugin"}, description="Authentication plugin class name", hidden=true)
        public String deprecatedAuthPluginClassName;
        @Parameter(names={"--auth-plugin"}, description="Authentication plugin class name")
        public String authPluginClassName;
        @Parameter(names={"--listener-name"}, description="Listener name for the broker.")
        String listenerName = null;
        @Parameter(names={"-mc", "--max_chunked_msg"}, description="Max pending chunk messages")
        private int maxPendingChunkedMessage = 0;
        @Parameter(names={"-ac", "--auto_ack_chunk_q_full"}, description="Auto ack for oldest message on queue is full")
        private boolean autoAckOldestChunkedMessageOnQueueFull = false;
        @Parameter(names={"-e", "--expire_time_incomplete_chunked_messages"}, description="Expire time in ms for incomplete chunk messages")
        private long expireTimeOfIncompleteChunkedMessageMs = 0L;
        @Parameter(names={"--auth-params"}, description="Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}.")
        public String authParams;
        @Parameter(names={"--trust-cert-file"}, description="Path for the trusted TLS certificate file")
        public String tlsTrustCertsFilePath = "";
        @Parameter(names={"--tls-allow-insecure"}, description="Allow insecure TLS connection")
        public Boolean tlsAllowInsecureConnection = null;
        @Parameter(names={"-v", "--encryption-key-value-file"}, description="The file which contains the private key to decrypt payload")
        public String encKeyFile = null;
        @Parameter(names={"-time", "--test-duration"}, description="Test duration in secs. If <= 0, it will keep consuming")
        public long testTime = 0L;
        @Parameter(names={"-ioThreads", "--num-io-threads"}, description="Set the number of threads to be used for handling connections to brokers, default is 1 thread")
        public int ioThreads = 1;
        @Parameter(names={"--batch-index-ack"}, description="Enable or disable the batch index acknowledgment")
        public boolean batchIndexAck = false;
        @Parameter(names={"-pm", "--pool-messages"}, description="Use the pooled message", arity=1)
        private boolean poolMessages = true;
        @Parameter(names={"-bw", "--busy-wait"}, description="Enable Busy-Wait on the Pulsar client")
        public boolean enableBusyWait = false;
        @Parameter(names={"--histogram-file"}, description="HdrHistogram output file")
        public String histogramFile = null;

        Arguments() {
        }
    }
}

