/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.common.protocol.OptionalProxyProtocolDecoder;
import org.apache.pulsar.common.util.NettyClientSslContextRefresher;
import org.apache.pulsar.common.util.NettyServerSslContextBuilder;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.common.util.keystoretls.NettySSLContextAutoRefreshBuilder;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.apache.pulsar.proxy.server.ProxyService;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final ProxyService proxyService;
    private final boolean enableTls;
    private final boolean tlsEnabledWithKeyStore;
    private final int brokerProxyReadTimeoutMs;
    private SslContextAutoRefreshBuilder<SslContext> serverSslCtxRefresher;
    private SslContextAutoRefreshBuilder<SslContext> clientSslCtxRefresher;
    private NettySSLContextAutoRefreshBuilder serverSSLContextAutoRefreshBuilder;
    private NettySSLContextAutoRefreshBuilder clientSSLContextAutoRefreshBuilder;

    public ServiceChannelInitializer(ProxyService proxyService, ProxyConfiguration serviceConfig, boolean enableTls) throws Exception {
        this.proxyService = proxyService;
        this.enableTls = enableTls;
        this.tlsEnabledWithKeyStore = serviceConfig.isTlsEnabledWithKeyStore();
        this.brokerProxyReadTimeoutMs = serviceConfig.getBrokerProxyReadTimeoutMs();
        if (enableTls) {
            if (this.tlsEnabledWithKeyStore) {
                this.serverSSLContextAutoRefreshBuilder = new NettySSLContextAutoRefreshBuilder(serviceConfig.getTlsProvider(), serviceConfig.getTlsKeyStoreType(), serviceConfig.getTlsKeyStore(), serviceConfig.getTlsKeyStorePassword(), serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustStoreType(), serviceConfig.getTlsTrustStore(), serviceConfig.getTlsTrustStorePassword(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.getTlsCertRefreshCheckDurationSec());
            } else {
                SslProvider sslProvider = null;
                if (serviceConfig.getTlsProvider() != null) {
                    sslProvider = SslProvider.valueOf((String)serviceConfig.getTlsProvider());
                }
                this.serverSslCtxRefresher = new NettyServerSslContextBuilder(sslProvider, serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustCertsFilePath(), serviceConfig.getTlsCertificateFilePath(), serviceConfig.getTlsKeyFilePath(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCertRefreshCheckDurationSec());
            }
        } else {
            this.serverSslCtxRefresher = null;
        }
        if (serviceConfig.isTlsEnabledWithBroker()) {
            AuthenticationDataProvider authData = null;
            if (!StringUtils.isEmpty((CharSequence)serviceConfig.getBrokerClientAuthenticationPlugin())) {
                authData = AuthenticationFactory.create((String)serviceConfig.getBrokerClientAuthenticationPlugin(), (String)serviceConfig.getBrokerClientAuthenticationParameters()).getAuthData();
            }
            if (this.tlsEnabledWithKeyStore) {
                this.clientSSLContextAutoRefreshBuilder = new NettySSLContextAutoRefreshBuilder(serviceConfig.getBrokerClientSslProvider(), serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getBrokerClientTlsTrustStoreType(), serviceConfig.getBrokerClientTlsTrustStore(), serviceConfig.getBrokerClientTlsTrustStorePassword(), serviceConfig.getBrokerClientTlsCiphers(), serviceConfig.getBrokerClientTlsProtocols(), serviceConfig.getTlsCertRefreshCheckDurationSec(), authData);
            } else {
                SslProvider sslProvider = null;
                if (serviceConfig.getBrokerClientSslProvider() != null) {
                    sslProvider = SslProvider.valueOf((String)serviceConfig.getBrokerClientSslProvider());
                }
                this.clientSslCtxRefresher = new NettyClientSslContextRefresher(sslProvider, serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getBrokerClientTrustCertsFilePath(), authData, serviceConfig.getBrokerClientTlsCiphers(), serviceConfig.getBrokerClientTlsProtocols(), serviceConfig.getTlsCertRefreshCheckDurationSec());
            }
        } else {
            this.clientSslCtxRefresher = null;
        }
    }

    protected void initChannel(final SocketChannel ch) throws Exception {
        if (this.serverSslCtxRefresher != null && this.enableTls) {
            SslContext sslContext = (SslContext)this.serverSslCtxRefresher.get();
            if (sslContext != null) {
                ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)sslContext.newHandler(ch.alloc()));
            }
        } else if (this.tlsEnabledWithKeyStore && this.serverSSLContextAutoRefreshBuilder != null) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)new SslHandler(((KeyStoreSSLContext)this.serverSSLContextAutoRefreshBuilder.get()).createSSLEngine()));
        }
        if (this.brokerProxyReadTimeoutMs > 0) {
            ch.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)this.brokerProxyReadTimeoutMs, TimeUnit.MILLISECONDS));
        }
        if (this.proxyService.getConfiguration().isHaProxyProtocolEnabled()) {
            ch.pipeline().addLast("optional-proxy-protocol-decoder", (ChannelHandler)new OptionalProxyProtocolDecoder());
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(5253120, 0, 4, 0, 4));
        Supplier<SslHandler> sslHandlerSupplier = null;
        if (this.clientSslCtxRefresher != null) {
            sslHandlerSupplier = new Supplier<SslHandler>(){

                @Override
                public SslHandler get() {
                    return ((SslContext)ServiceChannelInitializer.this.clientSslCtxRefresher.get()).newHandler(ch.alloc());
                }
            };
        } else if (this.clientSSLContextAutoRefreshBuilder != null) {
            sslHandlerSupplier = new Supplier<SslHandler>(){

                @Override
                public SslHandler get() {
                    return new SslHandler(((KeyStoreSSLContext)ServiceChannelInitializer.this.clientSSLContextAutoRefreshBuilder.get()).createSSLEngine());
                }
            };
        }
        ch.pipeline().addLast("handler", (ChannelHandler)new ProxyConnection(this.proxyService, sslHandlerSupplier, this.proxyService.getDnsNameResolver()));
    }
}

