/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.airlift.event.client.EventDataType;
import io.airlift.event.client.EventFieldMetadata;
import io.airlift.event.client.EventTypeMetadata;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;

public class EventJsonSerializer<T>
extends JsonSerializer<T> {
    private final EventTypeMetadata<T> eventTypeMetadata;
    private final String hostName;

    public EventJsonSerializer(EventTypeMetadata<T> eventTypeMetadata) {
        Objects.requireNonNull(eventTypeMetadata, "eventTypeMetadata is null");
        this.eventTypeMetadata = eventTypeMetadata;
        if (eventTypeMetadata.getHostField() == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unable to determine local host name");
            }
        } else {
            this.hostName = null;
        }
    }

    public Class<T> handledType() {
        return this.eventTypeMetadata.getEventClass();
    }

    public void serialize(T event, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", this.eventTypeMetadata.getTypeName());
        if (this.eventTypeMetadata.getUuidField() != null) {
            this.eventTypeMetadata.getUuidField().writeField(jsonGenerator, event);
        } else {
            jsonGenerator.writeStringField("uuid", UUID.randomUUID().toString());
        }
        if (this.eventTypeMetadata.getHostField() != null) {
            this.eventTypeMetadata.getHostField().writeField(jsonGenerator, event);
        } else {
            jsonGenerator.writeStringField("host", this.hostName);
        }
        if (this.eventTypeMetadata.getTimestampField() != null) {
            this.eventTypeMetadata.getTimestampField().writeField(jsonGenerator, event);
        } else {
            jsonGenerator.writeFieldName("timestamp");
            EventDataType.DATETIME.writeFieldValue(jsonGenerator, new DateTime());
        }
        jsonGenerator.writeObjectFieldStart("data");
        for (EventFieldMetadata field : this.eventTypeMetadata.getFields()) {
            field.writeField(jsonGenerator, event);
        }
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
        jsonGenerator.flush();
    }
}

