/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Offset
extends Node {
    private final String rowCount;

    public Offset(String rowCount) {
        this(Optional.empty(), rowCount);
    }

    public Offset(NodeLocation location, String rowCount) {
        this(Optional.of(location), rowCount);
    }

    public Offset(Optional<NodeLocation> location, String rowCount) {
        super(location);
        this.rowCount = rowCount;
    }

    public String getRowCount() {
        return this.rowCount;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitOffset(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Offset o = (Offset)obj;
        return Objects.equals(this.rowCount, o.rowCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rowCount);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rowCount", (Object)this.rowCount).toString();
    }
}

